/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSuccessorList;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallTree;
import org.graalvm.compiler.truffle.compiler.phases.inlining.GraphManager;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicy;

@NodeInfo(nameTemplate="{p#truffleAST}", cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public final class CallNode
extends Node {
    private static final NodeClass<CallNode> TYPE = NodeClass.create(CallNode.class);
    private final TruffleCallNode truffleCaller;
    private final CompilableTruffleAST truffleAST;
    private final TruffleCallNode[] truffleCallees;
    private final double rootRelativeFrequency;
    private Object data;
    private State state = State.Cutoff;
    @Node.Successor
    private NodeSuccessorList<CallNode> children;
    private int recursionDepth = -1;
    private int depth;
    private StructuredGraph ir;
    private EconomicMap<CallNode, Invoke> childInvokes;

    protected CallNode(TruffleCallNode truffleCallNode, CompilableTruffleAST truffleAST, StructuredGraph ir, double rootRelativeFrequency, int depth) {
        super(TYPE);
        this.rootRelativeFrequency = rootRelativeFrequency;
        this.truffleCaller = truffleCallNode;
        this.truffleAST = truffleAST;
        this.truffleCallees = truffleAST.getCallNodes();
        this.ir = ir;
        this.childInvokes = EconomicMap.create();
        this.children = new NodeSuccessorList((Node)this, 0);
        this.depth = depth;
    }

    static CallNode makeRoot(CallTree callTree, CompilableTruffleAST truffleAST, StructuredGraph ir) {
        Objects.requireNonNull(callTree);
        Objects.requireNonNull(truffleAST);
        Objects.requireNonNull(ir);
        CallNode root = new CallNode(null, truffleAST, ir, 1.0, 0);
        callTree.add(root);
        root.data = callTree.getPolicy().newCallNodeData(root);
        assert (root.state == State.Cutoff) : "Cannot expand a non-cutoff node. State is " + (Object)((Object)root.state);
        root.addChildren();
        root.partiallyEvaluateRoot();
        callTree.getPolicy().afterExpand(root);
        return root;
    }

    private static double calculateFrequency(CompilableTruffleAST target, TruffleCallNode callNode) {
        return (double)Math.max(1, callNode.getCallCount()) / (double)Math.max(1, target.getCallCount());
    }

    public CompilableTruffleAST getTruffleAST() {
        return this.truffleAST;
    }

    void putProperties(Map<Object, Object> properties) {
        properties.put("Frequency", this.rootRelativeFrequency);
        properties.put("Recursion Depth", this.getRecursionDepth());
        properties.put("IR Nodes", this.ir == null ? 0 : this.ir.getNodeCount());
        properties.put("Truffle Callees", this.truffleCallees.length);
        properties.put("Explore/inline ratio", this.exploreInlineRatio());
        properties.put("Depth", this.depth);
        properties.put("Forced", this.isRoot() ? false : this.isForced());
        this.getPolicy().putProperties(this, properties);
    }

    private double exploreInlineRatio() {
        CallTree callTree = this.getCallTree();
        return this.isRoot() ? (double)callTree.expanded / (double)callTree.inlined : Double.NaN;
    }

    public int getRecursionDepth() {
        if (this.recursionDepth == -1) {
            this.recursionDepth = this.computeRecursionDepth();
        }
        return this.recursionDepth;
    }

    private int computeRecursionDepth() {
        return this.computeRecursionDepth(this.getParent(), this.truffleAST);
    }

    private int computeRecursionDepth(CallNode node, CompilableTruffleAST target) {
        if (node == null) {
            return 0;
        }
        int parentDepth = this.computeRecursionDepth(node.getParent(), target);
        if (node.truffleAST.isSameOrSplit(target)) {
            return parentDepth + 1;
        }
        return parentDepth;
    }

    private void addChildren() {
        for (TruffleCallNode childCallNode : this.truffleCallees) {
            double relativeFrequency = CallNode.calculateFrequency(this.truffleAST, childCallNode);
            double childFrequency = relativeFrequency * this.rootRelativeFrequency;
            CallNode callNode = new CallNode(childCallNode, childCallNode.getCurrentCallTarget(), null, childFrequency, this.depth + 1);
            this.getCallTree().add(callNode);
            this.children.add((Object)callNode);
            callNode.data = this.getPolicy().newCallNodeData(callNode);
        }
        this.getPolicy().afterAddChildren(this);
    }

    public int getDepth() {
        return this.depth;
    }

    public InliningPolicy getPolicy() {
        return this.getCallTree().getPolicy();
    }

    private void partiallyEvaluateRoot() {
        assert (this.getParent() == null);
        EconomicMap<TruffleCallNode, Invoke> truffleCallNodeToInvoke = this.getCallTree().getGraphManager().peRoot(this.truffleAST);
        this.state = State.Inlined;
        for (CallNode child : this.children) {
            Invoke invoke = (Invoke)truffleCallNodeToInvoke.get((Object)child.getTruffleCaller());
            this.putChildInvokeOrRemoveChild(child, invoke);
        }
    }

    private void putChildInvokeOrRemoveChild(CallNode child, Invoke invoke) {
        if (invoke == null || !invoke.isAlive()) {
            child.state = State.Removed;
            this.getPolicy().removedNode(this, child);
        } else {
            this.childInvokes.put((Object)child, (Object)invoke);
        }
    }

    private void updateChildrenList(EconomicMap<TruffleCallNode, Invoke> truffleCallNodeToInvoke) {
        for (CallNode child : this.children) {
            Invoke childInvoke = (Invoke)truffleCallNodeToInvoke.get((Object)child.getTruffleCaller());
            if (childInvoke != null && childInvoke.isAlive()) continue;
            child.state = State.Removed;
            this.getPolicy().removedNode(this, child);
        }
    }

    public void expand() {
        assert (this.state == State.Cutoff) : "Cannot expand a non-cutoff node. Not is " + (Object)((Object)this.state);
        assert (this.getParent() != null);
        this.state = State.Expanded;
        ++this.getCallTree().expanded;
        this.addChildren();
        EconomicMap<TruffleCallNode, Invoke> truffleCallNodeInvoke = this.partiallyEvaluate();
        this.getPolicy().afterPartialEvaluation(this);
        this.updateChildrenList(truffleCallNodeInvoke);
        this.getPolicy().afterExpand(this);
    }

    private EconomicMap<TruffleCallNode, Invoke> partiallyEvaluate() {
        assert (this.state == State.Expanded);
        assert (this.ir == null);
        GraphManager.Entry entry = this.getCallTree().getGraphManager().get(this.truffleAST);
        this.ir = this.copyGraphAndUpdateInvokes(entry);
        return entry.truffleCallNodeToInvoke;
    }

    private StructuredGraph copyGraphAndUpdateInvokes(final GraphManager.Entry entry) {
        StructuredGraph graph = entry.graph;
        return (StructuredGraph)graph.copy(new Consumer<UnmodifiableEconomicMap<Node, Node>>(){

            @Override
            public void accept(UnmodifiableEconomicMap<Node, Node> duplicates) {
                for (CallNode child : CallNode.this.children) {
                    TruffleCallNode childTruffleCallNode = child.getTruffleCaller();
                    Invoke original = (Invoke)entry.truffleCallNodeToInvoke.get((Object)childTruffleCallNode);
                    if (original == null || !original.isAlive()) {
                        child.state = State.Removed;
                        CallNode.this.getPolicy().removedNode(CallNode.this, child);
                        continue;
                    }
                    Invoke replacement = (Invoke)duplicates.get((Object)((Node)((Object)original)));
                    CallNode.this.putChildInvokeOrRemoveChild(child, replacement);
                }
            }
        }, graph.getDebug());
    }

    public void inline() {
        assert (this.state == State.Expanded) : "Cannot inline node that is not expanded: " + (Object)((Object)this.state);
        assert (this.ir != null && this.getParent() != null);
        Invoke invoke = this.getInvoke();
        if (!invoke.isAlive()) {
            this.state = State.Removed;
            return;
        }
        UnmodifiableEconomicMap<Node, Node> replacements = this.getCallTree().getGraphManager().doInline(invoke, this.ir, this.truffleAST);
        for (CallNode child : this.childInvokes.getKeys()) {
            if (child.state == State.Removed) continue;
            Node childInvoke = (Node)this.childInvokes.get((Object)child);
            if (!childInvoke.isAlive()) {
                child.state = State.Removed;
                this.getPolicy().removedNode(this, child);
                continue;
            }
            Invoke value = (Invoke)replacements.get((Object)childInvoke);
            this.putChildInvokeOrRemoveChild(child, value);
        }
        this.state = State.Inlined;
        ++this.getCallTree().inlined;
    }

    void cancelCompilationIfSingleCallsite() {
        if (this.truffleAST != this.getCallTree().getRoot().truffleAST && this.truffleAST.getKnownCallSiteCount() == 1) {
            this.truffleAST.cancelInstalledTask();
        }
    }

    public boolean isForced() {
        return this.truffleCaller.isInliningForced();
    }

    private Invoke getChildInvoke(CallNode child) {
        return (Invoke)this.childInvokes.get((Object)child);
    }

    public CallNode getParent() {
        return (CallNode)this.predecessor();
    }

    public Invoke getInvoke() {
        CallNode parent = this.getParent();
        return parent != null ? parent.getChildInvoke(this) : null;
    }

    public State getState() {
        return this.state;
    }

    public boolean isRoot() {
        return this.truffleCaller == null;
    }

    public String getName() {
        return this.truffleAST.toString();
    }

    public List<CallNode> getChildren() {
        return this.children;
    }

    public StructuredGraph getIR() {
        return this.ir;
    }

    public CallTree getCallTree() {
        return (CallTree)this.graph();
    }

    TruffleCallNode getTruffleCaller() {
        return this.truffleCaller;
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> debugProperties = super.getDebugProperties(map);
        this.putProperties(debugProperties);
        if (this.ir != null) {
            debugProperties.put("ir node count", this.ir.getNodeCount());
        }
        return debugProperties;
    }

    HashMap<String, Object> getStringProperties() {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        this.putProperties(properties);
        HashMap<String, Object> stringProperties = new HashMap<String, Object>();
        for (Object key : properties.keySet()) {
            stringProperties.put(key.toString(), properties.get(key));
        }
        return stringProperties;
    }

    public double getRootRelativeFrequency() {
        return this.rootRelativeFrequency;
    }

    public Object getData() {
        return this.data;
    }

    public TruffleCallNode[] getTruffleCallees() {
        return this.truffleCallees;
    }

    @Override
    public String toString(Verbosity v) {
        return "CallNode{state=" + (Object)((Object)this.state) + ", children=" + this.children + ", truffleCallNode=" + this.truffleCaller + ", truffleAST=" + this.truffleAST + '}';
    }

    public static enum State {
        Cutoff,
        Expanded,
        Inlined,
        Removed,
        Indirect;

    }
}

