/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.truffle.common.CallNodeProvider;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.SharedTruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallNode;
import org.graalvm.compiler.truffle.compiler.phases.inlining.GraphManager;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicy;

public final class CallTree
extends Graph {
    private final InliningPolicy policy;
    private final GraphManager graphManager;
    private final CallNode root;
    int expanded = 1;
    int inlined = 1;

    CallTree(PartialEvaluator partialEvaluator, CallNodeProvider callNodeProvider, CompilableTruffleAST truffleAST, StructuredGraph ir, InliningPolicy policy) {
        super(ir.getOptions(), ir.getDebug());
        this.policy = policy;
        this.graphManager = new GraphManager(ir, partialEvaluator, callNodeProvider);
        this.root = CallNode.makeRoot(this, truffleAST, ir);
    }

    InliningPolicy getPolicy() {
        return this.policy;
    }

    public CallNode getRoot() {
        return this.root;
    }

    public int getInlinedCount() {
        return this.inlined;
    }

    public int getExpandedCount() {
        return this.expanded;
    }

    GraphManager getGraphManager() {
        return this.graphManager;
    }

    public void trace() {
        Boolean details = TruffleCompilerOptions.getValue(TruffleCompilerOptions.TraceTruffleInliningDetails);
        if (TruffleCompilerOptions.getValue(SharedTruffleCompilerOptions.TraceTruffleInlining).booleanValue() || details.booleanValue()) {
            TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
            runtime.logEvent(0, "inline start", this.root.getName(), this.root.getStringProperties());
            this.traceRecursive(runtime, this.root, details, 0);
            runtime.logEvent(0, "inline done", this.root.getName(), this.root.getStringProperties());
        }
    }

    private void traceRecursive(TruffleCompilerRuntime runtime, CallNode node, boolean details, int depth) {
        if (depth != 0) {
            runtime.logEvent(depth, node.getState().toString(), node.getName(), node.getStringProperties());
        }
        if (node.getState() == CallNode.State.Inlined || details) {
            for (CallNode child : node.getChildren()) {
                this.traceRecursive(runtime, child, details, depth + 1);
            }
        }
    }

    public void dequeueInlined() {
        this.dequeueInlined(this.root);
    }

    private void dequeueInlined(CallNode node) {
        if (node.getState() == CallNode.State.Inlined) {
            for (CallNode child : node.getChildren()) {
                this.dequeueInlined(child);
            }
            if (!node.isRoot()) {
                node.cancelCompilationIfSingleCallsite();
            }
        }
    }

    @Override
    public String toString() {
        return "Call Tree";
    }

    public void dumpBasic(String format, Object arg) {
        this.getDebug().dump(1, (Object)this, format, arg);
    }

    public void dumpInfo(String format, Object arg) {
        this.getDebug().dump(2, (Object)this, format, arg);
    }
}

