/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.compiler.SharedTruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallNode;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallTree;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicy;

final class DefaultPolicy
implements InliningPolicy {
    private static final int MAX_DEPTH = 15;
    private static final Comparator<CallNode> CALL_NODE_COMPARATOR = (o1, o2) -> Double.compare(o2.getRootRelativeFrequency(), o1.getRootRelativeFrequency());
    private final OptionValues optionValues;
    private int expandedCount = 0;

    DefaultPolicy(OptionValues optionValues) {
        this.optionValues = optionValues;
    }

    private static PriorityQueue<CallNode> getQueue(CallTree tree, CallNode.State state) {
        PriorityQueue<CallNode> queue = new PriorityQueue<CallNode>(CALL_NODE_COMPARATOR);
        for (CallNode child : tree.getRoot().getChildren()) {
            if (child.getState() != state) continue;
            queue.add(child);
        }
        return queue;
    }

    private static void doInline(CallNode candidate, PriorityQueue<CallNode> inlineQueue) {
        candidate.inline();
        for (CallNode child : candidate.getChildren()) {
            if (child.getState() != CallNode.State.Expanded) continue;
            inlineQueue.add(child);
        }
    }

    @Override
    public void run(CallTree tree) {
        this.expand(tree);
        this.inline(tree);
    }

    private void inline(CallTree tree) {
        CallNode candidate;
        int inliningBudget = TruffleCompilerOptions.TruffleInliningInliningBudget.getValue(this.optionValues);
        PriorityQueue<CallNode> inlineQueue = DefaultPolicy.getQueue(tree, CallNode.State.Expanded);
        while ((candidate = inlineQueue.poll()) != null) {
            if (candidate.isForced()) {
                DefaultPolicy.doInline(candidate, inlineQueue);
                continue;
            }
            if (tree.getRoot().getIR().getNodeCount() + candidate.getIR().getNodeCount() > inliningBudget) break;
            DefaultPolicy.doInline(candidate, inlineQueue);
        }
    }

    private void expand(CallTree tree) {
        CallNode candidate;
        int expansionBudget = TruffleCompilerOptions.TruffleInliningExpansionBudget.getValue(this.optionValues);
        PriorityQueue<CallNode> expandQueue = DefaultPolicy.getQueue(tree, CallNode.State.Cutoff);
        while ((candidate = expandQueue.poll()) != null) {
            if (candidate.isForced()) {
                this.doExpand(candidate, expandQueue);
                continue;
            }
            if (this.expandedCount > expansionBudget) break;
            Integer maximumRecursiveInliningValue = SharedTruffleCompilerOptions.TruffleMaximumRecursiveInlining.getValue(this.optionValues);
            if (candidate.getRecursionDepth() > maximumRecursiveInliningValue || candidate.getDepth() > 15) continue;
            this.doExpand(candidate, expandQueue);
        }
    }

    private void doExpand(CallNode candidate, PriorityQueue<CallNode> expandQueue) {
        candidate.expand();
        this.expandedCount += candidate.getIR().getNodeCount();
        for (CallNode child : candidate.getChildren()) {
            if (child.getState() != CallNode.State.Cutoff) continue;
            expandQueue.add(child);
        }
    }
}

