/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.substitutions;

import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;

public class AbstractKnownTruffleTypes {
    protected final TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
    protected final MetaAccessProvider metaAccess;
    private FieldsCache fieldsCache;

    protected AbstractKnownTruffleTypes(MetaAccessProvider metaAccess) {
        this.metaAccess = metaAccess;
    }

    protected ResolvedJavaType lookupType(String className) {
        return this.runtime.resolveType(this.metaAccess, className);
    }

    protected ResolvedJavaType lookupType(Class<?> c) {
        return this.metaAccess.lookupJavaType(c);
    }

    protected ResolvedJavaField findField(ResolvedJavaType declaringClass, String name) {
        FieldsCache fc = this.fieldsCache;
        if (fc == null || !fc.declaringClass.equals(declaringClass)) {
            this.fieldsCache = fc = new FieldsCache(declaringClass, declaringClass.getInstanceFields(false));
        }
        for (ResolvedJavaField f : fc.fields) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        throw new GraalError("Could not find required field %s.%s", declaringClass.getName(), name);
    }

    static class FieldsCache {
        final ResolvedJavaType declaringClass;
        final ResolvedJavaField[] fields;

        FieldsCache(ResolvedJavaType declaringClass, ResolvedJavaField[] fields) {
            this.declaringClass = declaringClass;
            this.fields = fields;
        }
    }
}

