/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;

public final class CancellableCompileTask
implements TruffleCompilationTask {
    private volatile Future<?> future;
    private volatile boolean cancelled;
    private final boolean lastTierCompilation;

    public CancellableCompileTask(boolean lastTierCompilation) {
        this.lastTierCompilation = lastTierCompilation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFuture(Future<?> future) {
        CancellableCompileTask cancellableCompileTask = this;
        synchronized (cancellableCompileTask) {
            if (this.future != null) {
                throw new IllegalStateException("The future should not be re-set.");
            }
            this.future = future;
        }
    }

    public void awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.future.get(timeout, unit);
    }

    public void awaitCompletion() throws ExecutionException, InterruptedException {
        this.future.get();
    }

    public synchronized boolean cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isLastTier() {
        return this.lastTierCompilation;
    }
}

