/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerOptions;
import org.graalvm.compiler.truffle.runtime.GraalCompilerOptions;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.TruffleInliningPolicy;
import org.graalvm.compiler.truffle.runtime.TruffleInliningProfile;

public class DefaultInliningPolicy
implements TruffleInliningPolicy {
    @Override
    public double calculateScore(TruffleInliningProfile profile) {
        return profile.getFrequency() / (double)profile.getDeepNodeCount();
    }

    @Override
    public boolean isAllowed(TruffleInliningProfile profile, int currentNodeCount, CompilerOptions options) {
        if (profile.isCached()) {
            profile.setFailedReason(profile.getCached().getFailedReason());
            return false;
        }
        OptimizedCallTarget target = profile.getCallNode().getCallTarget();
        if (profile.getRecursions() > target.getOptionValue(PolyglotCompilerOptions.InliningRecursionDepth)) {
            profile.setFailedReason(TruffleInliningPolicy.FailedReason.REASON_RECURSION);
            return false;
        }
        int inliningMaxCallerSize = target.getOptionValue(PolyglotCompilerOptions.InliningNodeBudget);
        if (options instanceof GraalCompilerOptions) {
            inliningMaxCallerSize = Math.max(inliningMaxCallerSize, ((GraalCompilerOptions)options).getMinInliningMaxCallerSize());
        }
        if (currentNodeCount + profile.getDeepNodeCount() > inliningMaxCallerSize) {
            profile.setFailedReason(TruffleInliningPolicy.FailedReason.REASON_MAXIMUM_TOTAL_NODE_COUNT);
            return false;
        }
        if (profile.isForced()) {
            return true;
        }
        int cappedCallSites = Math.min(Math.max(profile.getCallSites(), 1), 10);
        if (profile.getDeepNodeCount() * cappedCallSites > inliningMaxCallerSize) {
            profile.setFailedReason(TruffleInliningPolicy.FailedReason.REASON_MAXIMUM_NODE_COUNT);
            return false;
        }
        return true;
    }
}

