/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Method;
import jdk.vm.ci.code.stack.InspectedFrame;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedOSRLoopNode;

public final class GraalFrameInstance
implements FrameInstance {
    private static final int CALL_TARGET_INDEX = 0;
    private static final int CALL_TARGET_FRAME_INDEX = 1;
    private static final int CALL_NODE_NOTIFY_INDEX = 1;
    public static final Method CALL_TARGET_METHOD;
    public static final Method CALL_DIRECT;
    public static final Method CALL_INLINED;
    public static final Method CALL_INLINED_AGNOSTIC;
    public static final Method CALL_INLINED_FORCED;
    public static final Method CALL_INDIRECT;
    public static final Method CALL_OSR_METHOD;
    private final InspectedFrame callTargetFrame;
    private final InspectedFrame callNodeFrame;

    public GraalFrameInstance(InspectedFrame callTargetFrame, InspectedFrame callNodeFrame) {
        this.callTargetFrame = callTargetFrame;
        this.callNodeFrame = callNodeFrame;
    }

    @CompilerDirectives.TruffleBoundary
    public Frame getFrame(FrameInstance.FrameAccess access) {
        if ((access == FrameInstance.FrameAccess.READ_WRITE || access == FrameInstance.FrameAccess.MATERIALIZE) && this.callTargetFrame.isVirtual(1)) {
            this.callTargetFrame.materializeVirtualObjects(false);
        }
        Frame frame = (Frame)this.callTargetFrame.getLocal(1);
        if (access == FrameInstance.FrameAccess.MATERIALIZE) {
            frame = frame.materialize();
        }
        return frame;
    }

    public boolean isVirtualFrame() {
        return this.callTargetFrame.isVirtual(1);
    }

    public CallTarget getCallTarget() {
        return (CallTarget)this.callTargetFrame.getLocal(0);
    }

    public Node getCallNode() {
        Object receiver;
        if (this.callNodeFrame != null && (receiver = this.callNodeFrame.getLocal(1)) instanceof Node) {
            return (Node)receiver;
        }
        return null;
    }

    static {
        try {
            CALL_DIRECT = OptimizedCallTarget.class.getDeclaredMethod("callDirect", Node.class, Object[].class);
            CALL_INLINED = OptimizedCallTarget.class.getDeclaredMethod("callInlined", Node.class, Object[].class);
            CALL_INLINED_AGNOSTIC = OptimizedCallTarget.class.getDeclaredMethod("callInlinedAgnostic", Object[].class);
            CALL_INLINED_FORCED = OptimizedCallTarget.class.getDeclaredMethod("callInlinedForced", Node.class, Object[].class);
            CALL_INDIRECT = OptimizedCallTarget.class.getDeclaredMethod("callIndirect", Node.class, Object[].class);
            CALL_TARGET_METHOD = OptimizedCallTarget.class.getDeclaredMethod("callProxy", VirtualFrame.class);
            CALL_OSR_METHOD = OptimizedOSRLoopNode.OSRRootNode.class.getDeclaredMethod("callProxy", OptimizedOSRLoopNode.OSRRootNode.class, VirtualFrame.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InternalError(e);
        }
    }
}

