/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.TVMCI;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.OptimizedBlockNode;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedIndirectCallNode;
import org.graalvm.compiler.truffle.runtime.OptimizedOSRLoopNode;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.TruffleSplittingStrategy;
import org.graalvm.options.OptionDescriptors;

final class GraalTVMCI
extends TVMCI {
    private static final GraalCastUnsafe CAST_UNSAFE = new GraalCastUnsafe();

    GraalTVMCI() {
    }

    public void onLoopCount(Node source, int count) {
        RootCallTarget target;
        Node parentNode;
        Node node = parentNode = source != null ? source.getParent() : null;
        for (Node node2 = source; node2 != null; node2 = node2.getParent()) {
            if (node2 instanceof OptimizedOSRLoopNode) {
                ((OptimizedOSRLoopNode)node2).reportChildLoopCount(count);
            }
            parentNode = node2;
        }
        if (parentNode != null && parentNode instanceof RootNode && (target = ((RootNode)parentNode).getCallTarget()) instanceof OptimizedCallTarget) {
            ((OptimizedCallTarget)target).onLoopCount(count);
        }
    }

    protected boolean isGuestCallStackFrame(StackTraceElement e) {
        return e.getMethodName().equals("callProxy") && e.getClassName().equals(OptimizedCallTarget.class.getName()) || e.getMethodName().equals("call") && e.getClassName().equals(OptimizedCallTarget.OptimizedCallInlined.class.getName());
    }

    protected void initializeProfile(CallTarget target, Class<?>[] argumentTypes) {
        ((OptimizedCallTarget)target).getCompilationProfile().initializeArgumentTypes(argumentTypes);
    }

    protected OptionDescriptors getCompilerOptionDescriptors() {
        return PolyglotCompilerOptions.getDescriptors();
    }

    void onFirstExecution(OptimizedCallTarget callTarget) {
        super.onFirstExecution(callTarget.getRootNode());
    }

    protected void onLoad(RootNode rootNode) {
        super.onLoad(rootNode);
    }

    protected void setCallTarget(RootNode root, RootCallTarget callTarget) {
        super.setCallTarget(root, callTarget);
    }

    protected void markFrameMaterializeCalled(FrameDescriptor descriptor) {
        super.markFrameMaterializeCalled(descriptor);
    }

    protected void onThrowable(Node callNode, RootCallTarget root, Throwable e, Frame frame) {
        super.onThrowable(callNode, root, e, frame);
    }

    protected boolean getFrameMaterializeCalled(FrameDescriptor descriptor) {
        return super.getFrameMaterializeCalled(descriptor);
    }

    public RootNode cloneUninitialized(RootNode root) {
        return super.cloneUninitialized(root);
    }

    protected int adoptChildrenAndCount(RootNode root) {
        return super.adoptChildrenAndCount(root);
    }

    public boolean isCloneUninitializedSupported(RootNode root) {
        return super.isCloneUninitializedSupported(root);
    }

    protected IndirectCallNode createUncachedIndirectCall() {
        return OptimizedIndirectCallNode.createUncached();
    }

    static EngineData getEngineData(RootNode rootNode) {
        return (EngineData)GraalTVMCI.getOrCreateRuntimeData((RootNode)rootNode, EngineData.ENGINE_DATA_SUPPLIER);
    }

    protected void reportPolymorphicSpecialize(Node source) {
        OptimizedCallTarget callTarget;
        RootNode rootNode = source.getRootNode();
        OptimizedCallTarget optimizedCallTarget = callTarget = rootNode == null ? null : (OptimizedCallTarget)rootNode.getCallTarget();
        if (callTarget == null || callTarget.engineData.options.isLegacySplitting()) {
            return;
        }
        TruffleSplittingStrategy.newPolymorphicSpecialize(source, callTarget.engineData);
        callTarget.polymorphicSpecialize(source);
    }

    protected Accessor.CallInlined getCallInlined() {
        return new OptimizedCallTarget.OptimizedCallInlined();
    }

    protected Accessor.CallProfiled getCallProfiled() {
        return new OptimizedCallTarget.OptimizedCallProfiled();
    }

    protected Accessor.CastUnsafe getCastUnsafe() {
        return CAST_UNSAFE;
    }

    protected <T extends Node> BlockNode<T> createBlockNode(T[] elements, BlockNode.ElementExecutor<T> executor) {
        return new OptimizedBlockNode(elements, executor);
    }

    private static final class GraalCastUnsafe
    extends Accessor.CastUnsafe {
        private GraalCastUnsafe() {
        }

        public Object[] castArrayFixedLength(Object[] args, int length) {
            return OptimizedCallTarget.castArrayFixedLength(args, length);
        }

        public <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
            return OptimizedCallTarget.unsafeCast(value, type, condition, nonNull, exact);
        }
    }
}

