/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.frame.Frame;
import java.util.concurrent.CopyOnWriteArrayList;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;

final class GraalTruffleRuntimeListenerDispatcher
extends CopyOnWriteArrayList<GraalTruffleRuntimeListener>
implements GraalTruffleRuntimeListener,
TruffleCompilerListener {
    GraalTruffleRuntimeListenerDispatcher() {
    }

    @Override
    public boolean add(GraalTruffleRuntimeListener e) {
        if (e != this && !this.contains(e)) {
            return super.add(e);
        }
        return false;
    }

    @Override
    public void onCompilationSplit(OptimizedDirectCallNode callNode) {
        for (GraalTruffleRuntimeListener l : this) {
            l.onCompilationSplit(callNode);
        }
    }

    @Override
    public void onCompilationQueued(OptimizedCallTarget target) {
        for (GraalTruffleRuntimeListener l : this) {
            l.onCompilationQueued(target);
        }
    }

    @Override
    public void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason) {
        for (GraalTruffleRuntimeListener l : this) {
            l.onCompilationDequeued(target, source, reason);
        }
    }

    @Override
    public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanent) {
        for (GraalTruffleRuntimeListener l : this) {
            l.onCompilationFailed(target, reason, bailout, permanent);
        }
    }

    @Override
    public void onCompilationStarted(OptimizedCallTarget target) {
        for (GraalTruffleRuntimeListener l : this) {
            l.onCompilationStarted(target);
        }
    }

    @Override
    public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
        for (GraalTruffleRuntimeListener l : this) {
            l.onCompilationTruffleTierFinished(target, inliningDecision, graph);
        }
    }

    @Override
    public void onCompilationGraalTierFinished(OptimizedCallTarget target, TruffleCompilerListener.GraphInfo graph) {
        for (GraalTruffleRuntimeListener l : this) {
            l.onCompilationGraalTierFinished(target, graph);
        }
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        for (GraalTruffleRuntimeListener l : this) {
            l.onCompilationSuccess(target, inliningDecision, graph, result);
        }
    }

    @Override
    public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
        for (GraalTruffleRuntimeListener l : this) {
            l.onCompilationInvalidated(target, source, reason);
        }
    }

    @Override
    public void onCompilationDeoptimized(OptimizedCallTarget target, Frame frame) {
        for (GraalTruffleRuntimeListener l : this) {
            l.onCompilationDeoptimized(target, frame);
        }
    }

    @Override
    public void onShutdown() {
        for (GraalTruffleRuntimeListener l : this) {
            l.onShutdown();
        }
    }

    @Override
    public void onTruffleTierFinished(CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, TruffleCompilerListener.GraphInfo graph) {
        this.onCompilationTruffleTierFinished((OptimizedCallTarget)compilable, (TruffleInlining)inliningPlan, graph);
    }

    @Override
    public void onGraalTierFinished(CompilableTruffleAST compilable, TruffleCompilerListener.GraphInfo graph) {
        this.onCompilationGraalTierFinished((OptimizedCallTarget)compilable, graph);
    }

    @Override
    public void onSuccess(CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        this.onCompilationSuccess((OptimizedCallTarget)compilable, (TruffleInlining)inliningPlan, graph, result);
    }

    @Override
    public void onFailure(CompilableTruffleAST compilable, String reason, boolean bailout, boolean permanentBailout) {
        this.onCompilationFailed((OptimizedCallTarget)compilable, reason, bailout, permanentBailout);
    }
}

