/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graalvm.compiler.truffle.runtime.OptimizedAssumption;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.options.OptionValues;

public final class OptimizedCompilationProfile {
    private static final int MAX_PROFILED_ARGUMENTS = 256;
    private static final String ARGUMENT_TYPES_ASSUMPTION_NAME = "Profiled Argument Types";
    private static final String RETURN_TYPE_ASSUMPTION_NAME = "Profiled Return Type";
    private int invalidationCount;
    private int callCount;
    private int callAndLoopCount;
    private final int lastTierCompilationCallAndLoopThreshold;
    private final boolean multiTierEnabled;
    private final long timestamp;
    private final OptionValues options;
    private int compilationCallThreshold;
    private int compilationCallAndLoopThreshold;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private Class<?>[] profiledArgumentTypes;
    @CompilerDirectives.CompilationFinal
    private OptimizedAssumption profiledArgumentTypesAssumption;
    @CompilerDirectives.CompilationFinal
    private Class<?> profiledReturnType;
    @CompilerDirectives.CompilationFinal
    private OptimizedAssumption profiledReturnTypeAssumption;
    @CompilerDirectives.CompilationFinal
    private Class<?> exceptionType;
    private volatile boolean compilationFailed;
    @CompilerDirectives.CompilationFinal
    private boolean callProfiled;

    public OptimizedCompilationProfile(OptionValues options) {
        this.options = options;
        boolean compileImmediately = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.CompileImmediately);
        int callThreshold = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.MinInvokeThreshold);
        int callAndLoopThreshold = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.CompilationThreshold);
        assert (callThreshold >= 0);
        assert (callAndLoopThreshold >= 0);
        this.multiTierEnabled = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.MultiTier);
        this.compilationCallThreshold = compileImmediately ? 0 : Math.min(callThreshold, callAndLoopThreshold);
        this.lastTierCompilationCallAndLoopThreshold = this.compilationCallAndLoopThreshold = compileImmediately ? 0 : callAndLoopThreshold;
        if (this.multiTierEnabled) {
            int firstTierCallThreshold = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.FirstTierMinInvokeThreshold);
            int firstTierCallAndLoopThreshold = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.FirstTierCompilationThreshold);
            this.compilationCallThreshold = compileImmediately ? 0 : Math.min(firstTierCallThreshold, firstTierCallAndLoopThreshold);
            this.compilationCallAndLoopThreshold = firstTierCallAndLoopThreshold;
        }
        this.timestamp = System.nanoTime();
    }

    public String toString() {
        return String.format("CompilationProfile(callCount=%d/%d, callAndLoopCount=%d/%d)", this.callCount, this.compilationCallThreshold, this.callAndLoopCount, this.compilationCallAndLoopThreshold);
    }

    void initializeArgumentTypes(Class<?>[] argumentTypes) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.profiledArgumentTypesAssumption != null) {
            this.profiledArgumentTypesAssumption.invalidate();
            throw new AssertionError((Object)"Argument types already initialized. initializeArgumentTypes must be called before any profile is initialized.");
        }
        this.profiledArgumentTypes = argumentTypes;
        this.profiledArgumentTypesAssumption = OptimizedCompilationProfile.createValidAssumption("Custom profiled argument types");
        this.callProfiled = true;
    }

    List<OptimizedAssumption> getProfiledTypesAssumptions() {
        ArrayList<OptimizedAssumption> result = new ArrayList<OptimizedAssumption>();
        if (this.getProfiledArgumentTypes() != null) {
            result.add(this.profiledArgumentTypesAssumption);
        }
        if (this.getProfiledReturnType() != null) {
            result.add(this.profiledReturnTypeAssumption);
        }
        return result;
    }

    Class<?>[] getProfiledArgumentTypes() {
        if (this.profiledArgumentTypesAssumption == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.profiledArgumentTypesAssumption = OptimizedCompilationProfile.createInvalidAssumption(ARGUMENT_TYPES_ASSUMPTION_NAME);
        }
        if (this.profiledArgumentTypesAssumption.isValid()) {
            return this.profiledArgumentTypes;
        }
        return null;
    }

    Class<?> getProfiledReturnType() {
        if (this.profiledReturnTypeAssumption == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.profiledReturnTypeAssumption = OptimizedCompilationProfile.createInvalidAssumption(RETURN_TYPE_ASSUMPTION_NAME);
        }
        if (this.profiledReturnTypeAssumption.isValid()) {
            return this.profiledReturnType;
        }
        return null;
    }

    @ExplodeLoop
    void profileDirectCall(Object[] args) {
        block6: {
            OptimizedAssumption typesAssumption;
            block5: {
                typesAssumption = this.profiledArgumentTypesAssumption;
                if (typesAssumption != null) break block5;
                if (!CompilerDirectives.inInterpreter()) break block6;
                this.initializeProfiledArgumentTypes(args);
                break block6;
            }
            Class<?>[] types = this.profiledArgumentTypes;
            if (types != null) {
                if (types.length != args.length) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    typesAssumption.invalidate();
                    this.profiledArgumentTypes = null;
                } else if (typesAssumption.isValid()) {
                    for (int i = 0; i < types.length; ++i) {
                        Class<?> type = types[i];
                        Object value = args[i];
                        if (type == null || value != null && value.getClass() == type) continue;
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.updateProfiledArgumentTypes(args, types);
                        break;
                    }
                }
            }
        }
    }

    void profileIndirectCall() {
        OptimizedAssumption argumentTypesAssumption = this.profiledArgumentTypesAssumption;
        if (argumentTypesAssumption != null && argumentTypesAssumption.isValid()) {
            CompilerDirectives.transferToInterpreter();
            argumentTypesAssumption.invalidate();
            this.profiledArgumentTypes = null;
        }
    }

    void profileInlinedCall() {
    }

    void profileReturnValue(Object result) {
        OptimizedAssumption returnTypeAssumption = this.profiledReturnTypeAssumption;
        if (CompilerDirectives.inInterpreter() && returnTypeAssumption == null) {
            if (PolyglotCompilerOptions.getValue(this.options, PolyglotCompilerOptions.ReturnTypeSpeculation).booleanValue()) {
                this.profiledReturnType = OptimizedCompilationProfile.classOf(result);
                this.profiledReturnTypeAssumption = OptimizedCompilationProfile.createValidAssumption(RETURN_TYPE_ASSUMPTION_NAME);
            }
        } else if (this.profiledReturnType != null && (result == null || this.profiledReturnType != result.getClass())) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            returnTypeAssumption.invalidate();
            this.profiledReturnType = null;
        }
    }

    <E extends Throwable> E profileExceptionType(E ex) {
        Class<?> cachedClass = this.exceptionType;
        if (cachedClass != Object.class) {
            if (cachedClass != null && cachedClass == ex.getClass()) {
                return (E)((Throwable)cachedClass.cast(ex));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.exceptionType = cachedClass == null ? ex.getClass() : Object.class;
        }
        return ex;
    }

    Object[] injectArgumentProfile(Object[] originalArguments) {
        OptimizedAssumption argumentTypesAssumption = this.profiledArgumentTypesAssumption;
        Object[] args = originalArguments;
        if (argumentTypesAssumption != null && argumentTypesAssumption.isValid()) {
            args = OptimizedCallTarget.unsafeCast(OptimizedCallTarget.castArrayFixedLength(args, this.profiledArgumentTypes.length), Object[].class, true, true, true);
            args = this.castArgumentsImpl(args);
        }
        return args;
    }

    @ExplodeLoop
    private Object[] castArgumentsImpl(Object[] originalArguments) {
        Class<?>[] types = this.profiledArgumentTypes;
        Object[] castArguments = new Object[types.length];
        boolean isCallProfiled = this.callProfiled;
        for (int i = 0; i < types.length; ++i) {
            Class<?> targetType = types[i];
            boolean exact = !isCallProfiled || i == 0;
            castArguments[i] = targetType != null ? OptimizedCallTarget.unsafeCast(originalArguments[i], targetType, true, true, exact) : originalArguments[i];
        }
        return castArguments;
    }

    Object injectReturnValueProfile(Object result) {
        Class<?> klass = this.profiledReturnType;
        if (klass != null && CompilerDirectives.inCompiledCode() && this.profiledReturnTypeAssumption.isValid()) {
            return OptimizedCallTarget.unsafeCast(result, klass, true, true, true);
        }
        return result;
    }

    void reportCompilationFailure() {
        this.compilationFailed = true;
    }

    void reportLoopCount(int count) {
        this.callAndLoopCount += count;
    }

    void reportCompilationIgnored() {
        this.compilationFailed = true;
    }

    void reportInvalidated() {
        ++this.invalidationCount;
        int reprofile = PolyglotCompilerOptions.getValue(this.options, PolyglotCompilerOptions.InvalidationReprofileCount);
        this.ensureProfiling(reprofile, reprofile);
    }

    void reportNodeReplaced() {
        int replaceBackoff = PolyglotCompilerOptions.getValue(this.options, PolyglotCompilerOptions.ReplaceReprofileCount);
        this.ensureProfiling(1, replaceBackoff);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean firstTierCompile(OptimizedCallTarget callTarget) {
        return callTarget.compile(true);
    }

    boolean firstTierCall(OptimizedCallTarget callTarget) {
        int totalCallCount;
        if ((totalCallCount = ++this.callCount) >= this.lastTierCompilationCallAndLoopThreshold && !callTarget.isCompiling() && !this.compilationFailed) {
            return OptimizedCompilationProfile.firstTierCompile(callTarget);
        }
        return false;
    }

    boolean interpreterCall(OptimizedCallTarget callTarget) {
        int intCallCount = ++this.callCount;
        int intAndLoopCallCount = ++this.callAndLoopCount;
        int callThreshold = this.compilationCallThreshold;
        if (callThreshold == 0 || intCallCount >= callThreshold && intAndLoopCallCount >= this.compilationCallAndLoopThreshold && !this.compilationFailed && !callTarget.isCompiling()) {
            return callTarget.compile(!this.multiTierEnabled);
        }
        return false;
    }

    private void initializeProfiledArgumentTypes(Object[] args) {
        CompilerAsserts.neverPartOfCompilation();
        if (args.length <= 256 && PolyglotCompilerOptions.getValue(this.options, PolyglotCompilerOptions.ArgumentTypeSpeculation).booleanValue()) {
            Class[] result = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                result[i] = OptimizedCompilationProfile.classOf(args[i]);
            }
            this.profiledArgumentTypes = result;
            this.profiledArgumentTypesAssumption = OptimizedCompilationProfile.createValidAssumption(ARGUMENT_TYPES_ASSUMPTION_NAME);
        } else {
            this.profiledArgumentTypesAssumption = OptimizedCompilationProfile.createInvalidAssumption(ARGUMENT_TYPES_ASSUMPTION_NAME);
        }
    }

    private void updateProfiledArgumentTypes(Object[] args, Class<?>[] types) {
        CompilerAsserts.neverPartOfCompilation();
        this.profiledArgumentTypesAssumption.invalidate();
        for (int j = 0; j < types.length; ++j) {
            types[j] = OptimizedCompilationProfile.joinTypes(types[j], OptimizedCompilationProfile.classOf(args[j]));
        }
        this.profiledArgumentTypesAssumption = OptimizedCompilationProfile.createValidAssumption(ARGUMENT_TYPES_ASSUMPTION_NAME);
    }

    private static boolean checkProfiledArgumentTypes(Object[] args, Class<?>[] types) {
        assert (types != null);
        if (args.length != types.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (types[0] != args[0].getClass()) {
            throw new ClassCastException();
        }
        for (int j = 1; j < types.length; ++j) {
            if (types[j] == null) continue;
            types[j].cast(args[j]);
            Objects.requireNonNull(args[j]);
        }
        return true;
    }

    private static Class<?> classOf(Object arg) {
        return arg != null ? arg.getClass() : null;
    }

    private static Class<?> joinTypes(Class<?> class1, Class<?> class2) {
        if (class1 == class2) {
            return class1;
        }
        return null;
    }

    private synchronized void ensureProfiling(int calls, int callsAndLoop) {
        int increaseCallsThreshold;
        if (this.compilationCallThreshold == 0) {
            return;
        }
        int increaseCallAndLoopThreshold = callsAndLoop - Math.max(0, this.compilationCallAndLoopThreshold - this.callAndLoopCount);
        if (increaseCallAndLoopThreshold > 0) {
            this.compilationCallAndLoopThreshold += increaseCallAndLoopThreshold;
        }
        if ((increaseCallsThreshold = calls - Math.max(0, this.compilationCallThreshold - this.callCount)) > 0) {
            this.compilationCallThreshold += increaseCallsThreshold;
        }
    }

    public Map<String, Object> getDebugProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        String callsThreshold = String.format("%7d/%5d", this.getCallCount(), this.getCompilationCallThreshold());
        String loopsThreshold = String.format("%7d/%5d", this.getCallAndLoopCount(), this.getCompilationCallAndLoopThreshold());
        String invalidations = String.format("%5d", this.invalidationCount);
        properties.put("Calls/Thres", callsThreshold);
        properties.put("CallsAndLoop/Thres", loopsThreshold);
        properties.put("Inval#", invalidations);
        return properties;
    }

    public int getInvalidationCount() {
        return this.invalidationCount;
    }

    public int getCallAndLoopCount() {
        return this.callAndLoopCount;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public int getCompilationCallAndLoopThreshold() {
        return this.compilationCallAndLoopThreshold;
    }

    public int getCompilationCallThreshold() {
        return this.compilationCallThreshold;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static OptimizedCompilationProfile create(OptionValues options) {
        return new OptimizedCompilationProfile(options);
    }

    private static OptimizedAssumption createValidAssumption(String name) {
        return (OptimizedAssumption)Truffle.getRuntime().createAssumption(name);
    }

    private static OptimizedAssumption createInvalidAssumption(String name) {
        OptimizedAssumption result = OptimizedCompilationProfile.createValidAssumption(name);
        result.invalidate();
        return result;
    }

    public boolean isValidArgumentProfile(Object[] args) {
        return this.profiledArgumentTypesAssumption != null && this.profiledArgumentTypesAssumption.isValid() && OptimizedCompilationProfile.checkProfiledArgumentTypes(args, this.profiledArgumentTypes);
    }
}

