/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.impl.DefaultCompilerOptions;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ValueProfile;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.TruffleSplittingStrategy;

@NodeInfo
public final class OptimizedDirectCallNode
extends DirectCallNode
implements TruffleCallNode {
    private int callCount;
    private boolean inliningForced;
    @CompilerDirectives.CompilationFinal
    private ValueProfile exceptionProfile;
    @CompilerDirectives.CompilationFinal
    private OptimizedCallTarget splitCallTarget;

    public OptimizedDirectCallNode(OptimizedCallTarget target) {
        super((CallTarget)target);
        assert (target.getSourceCallTarget() == null);
    }

    public Object call(Object ... arguments) {
        if (CompilerDirectives.inInterpreter()) {
            this.onInterpreterCall();
        }
        try {
            return this.getCurrentCallTarget().callDirect((Node)this, arguments);
        }
        catch (Throwable t) {
            if (this.exceptionProfile == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.exceptionProfile = ValueProfile.createClassProfile();
            }
            Throwable profiledT = (Throwable)this.exceptionProfile.profile((Object)t);
            OptimizedCallTarget.runtime().getTvmci().onThrowable((Node)this, null, profiledT, null);
            throw OptimizedCallTarget.rethrow(profiledT);
        }
    }

    public boolean isInlinable() {
        CompilerAsserts.neverPartOfCompilation();
        return true;
    }

    public void forceInlining() {
        CompilerAsserts.neverPartOfCompilation();
        this.inliningForced = true;
    }

    @Override
    public boolean isInliningForced() {
        CompilerAsserts.neverPartOfCompilation();
        return this.inliningForced;
    }

    public boolean isCallTargetCloningAllowed() {
        return this.getCallTarget().getRootNode().isCloningAllowed();
    }

    public OptimizedCallTarget getCallTarget() {
        return (OptimizedCallTarget)super.getCallTarget();
    }

    @Override
    public int getCallCount() {
        return this.callCount;
    }

    public CompilerOptions getCompilerOptions() {
        RootNode rootNode = this.getRootNode();
        return rootNode != null ? rootNode.getCompilerOptions() : DefaultCompilerOptions.INSTANCE;
    }

    @Override
    public OptimizedCallTarget getCurrentCallTarget() {
        return (OptimizedCallTarget)super.getCurrentCallTarget();
    }

    public int getKnownCallSiteCount() {
        return this.getCurrentCallTarget().getKnownCallSiteCount();
    }

    public OptimizedCallTarget getClonedCallTarget() {
        return this.splitCallTarget;
    }

    private void onInterpreterCall() {
        int calls;
        if ((calls = ++this.callCount) == 1) {
            this.getCurrentCallTarget().incrementKnownCallSites();
        }
        TruffleSplittingStrategy.beforeCall(this);
    }

    void split() {
        CompilerAsserts.neverPartOfCompilation();
        this.atomic(() -> {
            if (this.splitCallTarget != null) {
                return;
            }
            assert (this.isCallTargetCloningAllowed());
            OptimizedCallTarget currentTarget = this.getCallTarget();
            OptimizedCallTarget splitTarget = this.getCallTarget().cloneUninitialized();
            splitTarget.setCallSiteForSplit(this);
            if (this.callCount >= 1) {
                currentTarget.decrementKnownCallSites();
                if (!currentTarget.getOptionValue(PolyglotCompilerOptions.LegacySplitting).booleanValue()) {
                    currentTarget.removeKnownCallSite(this);
                }
                splitTarget.incrementKnownCallSites();
            }
            if (!currentTarget.getOptionValue(PolyglotCompilerOptions.LegacySplitting).booleanValue()) {
                splitTarget.addKnownCallNode(this);
            }
            if (this.getParent() != null) {
                this.replace((Node)this, "Split call node");
            }
            this.splitCallTarget = splitTarget;
            OptimizedCallTarget.runtime().getListener().onCompilationSplit(this);
        });
    }

    public boolean cloneCallTarget() {
        TruffleSplittingStrategy.forceSplitting(this);
        return true;
    }
}

