/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.SharedTruffleRuntimeOptions;
import org.graalvm.compiler.truffle.runtime.TruffleInliningDecision;
import org.graalvm.compiler.truffle.runtime.TruffleInliningPolicy;
import org.graalvm.compiler.truffle.runtime.TruffleInliningProfile;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;

public class TruffleInlining
implements Iterable<TruffleInliningDecision>,
TruffleInliningPlan {
    private final List<TruffleInliningDecision> callSites;

    protected TruffleInlining(List<TruffleInliningDecision> callSites) {
        this.callSites = callSites;
    }

    public TruffleInlining(OptimizedCallTarget sourceTarget, TruffleInliningPolicy policy) {
        this(TruffleInlining.createDecisions(sourceTarget, policy, sourceTarget.getCompilerOptions()));
    }

    private static List<TruffleInliningDecision> createDecisions(OptimizedCallTarget sourceTarget, TruffleInliningPolicy policy, CompilerOptions options) {
        if (!sourceTarget.getOptionValue(PolyglotCompilerOptions.Inlining).booleanValue() || sourceTarget.getOptionValue(PolyglotCompilerOptions.Mode) == PolyglotCompilerOptions.EngineModeEnum.LATENCY || TruffleRuntimeOptions.getValue(SharedTruffleRuntimeOptions.TruffleLanguageAgnosticInlining).booleanValue()) {
            return Collections.emptyList();
        }
        int[] visitedNodes = new int[]{0};
        int nodeCount = sourceTarget.getNonTrivialNodeCount();
        List<TruffleInliningDecision> exploredCallSites = TruffleInlining.exploreCallSites(new ArrayList<OptimizedCallTarget>(Arrays.asList(sourceTarget)), nodeCount, policy, visitedNodes, new HashMap<OptimizedCallTarget, TruffleInliningDecision>());
        return TruffleInlining.decideInlining(exploredCallSites, policy, nodeCount, options);
    }

    private static List<TruffleInliningDecision> exploreCallSites(List<OptimizedCallTarget> stack, int callStackNodeCount, TruffleInliningPolicy policy, int[] visitedNodes, Map<OptimizedCallTarget, TruffleInliningDecision> rejectedDecisionsCache) {
        ArrayList<TruffleInliningDecision> exploredCallSites = new ArrayList<TruffleInliningDecision>();
        LinkedList<OptimizedCallTarget> toRemoveFromCache = new LinkedList<OptimizedCallTarget>();
        OptimizedCallTarget parentTarget = stack.get(stack.size() - 1);
        for (OptimizedDirectCallNode callNode : TruffleInlining.getCallNodes(parentTarget)) {
            OptimizedCallTarget currentTarget = callNode.getCurrentCallTarget();
            stack.add(currentTarget);
            TruffleInliningDecision decision = rejectedDecisionsCache.get(currentTarget);
            if (decision == null) {
                decision = TruffleInlining.exploreCallSite(stack, callStackNodeCount, policy, callNode, visitedNodes, rejectedDecisionsCache);
                if (!policy.isAllowed(decision.getProfile(), callStackNodeCount, callNode.getCompilerOptions())) {
                    rejectedDecisionsCache.put(currentTarget, decision);
                    toRemoveFromCache.add(currentTarget);
                }
            } else {
                TruffleInliningDecision newDecision;
                TruffleInliningProfile cachedProfile = decision.getProfile();
                TruffleInliningProfile newProfile = new TruffleInliningProfile(callNode, cachedProfile.getNodeCount(), cachedProfile.getDeepNodeCount(), cachedProfile.getFrequency(), cachedProfile.getRecursions());
                newProfile.setCached(cachedProfile);
                decision = newDecision = new TruffleInliningDecision(decision.getTarget(), newProfile, decision.getCallSites());
            }
            exploredCallSites.add(decision);
            stack.remove(stack.size() - 1);
        }
        for (OptimizedCallTarget target : toRemoveFromCache) {
            rejectedDecisionsCache.remove(target);
        }
        return exploredCallSites;
    }

    private static List<OptimizedDirectCallNode> getCallNodes(OptimizedCallTarget target) {
        final ArrayList<OptimizedDirectCallNode> callNodes = new ArrayList<OptimizedDirectCallNode>();
        target.getRootNode().accept(new NodeVisitor(){

            public boolean visit(Node node) {
                if (node instanceof OptimizedDirectCallNode) {
                    callNodes.add((OptimizedDirectCallNode)node);
                }
                return true;
            }
        });
        return callNodes;
    }

    private static TruffleInliningDecision exploreCallSite(List<OptimizedCallTarget> callStack, int callStackNodeCount, TruffleInliningPolicy policy, OptimizedDirectCallNode callNode, int[] visitedNodes, Map<OptimizedCallTarget, TruffleInliningDecision> rejectedDecisionsCache) {
        OptimizedCallTarget parentTarget = callStack.get(callStack.size() - 2);
        OptimizedCallTarget currentTarget = callStack.get(callStack.size() - 1);
        List<TruffleInliningDecision> childCallSites = Collections.emptyList();
        double frequency = TruffleInlining.calculateFrequency(parentTarget, callNode);
        int nodeCount = callNode.getCurrentCallTarget().getNonTrivialNodeCount();
        int recursions = TruffleInlining.countRecursions(callStack);
        int deepNodeCount = nodeCount;
        if (visitedNodes[0] < 100 * currentTarget.getOptionValue(PolyglotCompilerOptions.InliningNodeBudget) && callStack.size() < 15 && recursions <= currentTarget.getOptionValue(PolyglotCompilerOptions.InliningRecursionDepth)) {
            visitedNodes[0] = visitedNodes[0] + 1;
            CompilerOptions options = callNode.getCompilerOptions();
            if (policy.isAllowed(new TruffleInliningProfile(callNode, nodeCount, nodeCount, frequency, recursions), callStackNodeCount, options)) {
                List<TruffleInliningDecision> exploredCallSites = TruffleInlining.exploreCallSites(callStack, callStackNodeCount + nodeCount, policy, visitedNodes, rejectedDecisionsCache);
                childCallSites = TruffleInlining.decideInlining(exploredCallSites, policy, nodeCount, options);
                for (TruffleInliningDecision childCallSite : childCallSites) {
                    if (childCallSite.shouldInline()) {
                        deepNodeCount += childCallSite.getProfile().getDeepNodeCount();
                        continue;
                    }
                    childCallSite.getCallSites().clear();
                }
            }
        }
        TruffleInliningProfile profile = new TruffleInliningProfile(callNode, nodeCount, deepNodeCount, frequency, recursions);
        profile.setScore(policy.calculateScore(profile));
        return new TruffleInliningDecision(currentTarget, profile, childCallSites);
    }

    private static double calculateFrequency(OptimizedCallTarget target, OptimizedDirectCallNode ocn) {
        return (double)Math.max(1, ocn.getCallCount()) / (double)Math.max(1, target.getCompilationProfile().getCallCount());
    }

    private static int countRecursions(List<OptimizedCallTarget> stack) {
        int count = 0;
        OptimizedCallTarget top = stack.get(stack.size() - 1);
        for (int i = 0; i < stack.size() - 1; ++i) {
            OptimizedCallTarget frameTarget = stack.get(i);
            if (frameTarget != top && frameTarget != top.getSourceCallTarget() && top != frameTarget.getSourceCallTarget() && (frameTarget.getSourceCallTarget() == null || top.getSourceCallTarget() == null || frameTarget.getSourceCallTarget() != top.getSourceCallTarget())) continue;
            ++count;
        }
        return count;
    }

    private static List<TruffleInliningDecision> decideInlining(List<TruffleInliningDecision> callSites, TruffleInliningPolicy policy, int nodeCount, CompilerOptions options) {
        int deepNodeCount = nodeCount;
        int index = 0;
        Collections.sort(callSites);
        for (TruffleInliningDecision callSite : callSites) {
            TruffleInliningProfile profile = callSite.getProfile();
            profile.setQueryIndex(index++);
            if (!policy.isAllowed(profile, deepNodeCount, options)) continue;
            callSite.setInline(true);
            deepNodeCount += profile.getDeepNodeCount();
        }
        return callSites;
    }

    public int getInlinedNodeCount() {
        int sum = 0;
        for (TruffleInliningDecision callSite : this.getCallSites()) {
            if (!callSite.shouldInline()) continue;
            sum += callSite.getProfile().getDeepNodeCount();
        }
        return sum;
    }

    public int countCalls() {
        int sum = 0;
        for (TruffleInliningDecision callSite : this.getCallSites()) {
            sum += callSite.shouldInline() ? callSite.countCalls() + 1 : 1;
        }
        return sum;
    }

    public int countInlinedCalls() {
        int sum = 0;
        for (TruffleInliningDecision callSite : this.getCallSites()) {
            if (!callSite.shouldInline()) continue;
            sum += callSite.countInlinedCalls() + 1;
        }
        return sum;
    }

    public final List<TruffleInliningDecision> getCallSites() {
        return this.callSites;
    }

    @Override
    public Iterator<TruffleInliningDecision> iterator() {
        return this.callSites.iterator();
    }

    @Override
    public TruffleInliningPlan.Decision findDecision(JavaConstant callNodeConstant) {
        OptimizedDirectCallNode callNode = this.findCallNode(callNodeConstant);
        return this.findByCall(callNode);
    }

    @Override
    public OptimizedDirectCallNode findCallNode(JavaConstant callNodeConstant) {
        return OptimizedCallTarget.runtime().asObject(OptimizedDirectCallNode.class, callNodeConstant);
    }

    @Override
    public org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition getPosition(JavaConstant node) {
        Node truffleNode = OptimizedCallTarget.runtime().asObject(Node.class, node);
        if (truffleNode == null) {
            return null;
        }
        SourceSection section = null;
        if (truffleNode instanceof DirectCallNode) {
            section = ((DirectCallNode)truffleNode).getCurrentRootNode().getSourceSection();
        }
        if (section == null) {
            section = truffleNode.getSourceSection();
        }
        if (section == null) {
            for (Node cur = truffleNode.getParent(); cur != null && (section = cur.getSourceSection()) == null; cur = cur.getParent()) {
            }
        }
        if (section != null) {
            return new TruffleSourceLanguagePosition(section);
        }
        return null;
    }

    public TruffleInliningDecision findByCall(OptimizedDirectCallNode callNode) {
        for (TruffleInliningDecision d : this.getCallSites()) {
            if (d.getProfile().getCallNode() != callNode) continue;
            return d;
        }
        return null;
    }

    public void accept(OptimizedCallTarget target, NodeVisitor visitor) {
        target.getRootNode().accept((NodeVisitor)new CallTreeNodeVisitorImpl(visitor));
    }

    public Iterator<Node> makeNodeIterator(OptimizedCallTarget target) {
        return new CallTreeNodeIterator(target);
    }

    private final class CallTreeNodeIterator
    implements Iterator<Node> {
        private List<TruffleInlining> inliningDecisionStack = new ArrayList<TruffleInlining>();
        private List<Iterator<Node>> iteratorStack = new ArrayList<Iterator<Node>>();

        CallTreeNodeIterator(OptimizedCallTarget target) {
            this.inliningDecisionStack.add(TruffleInlining.this);
            this.iteratorStack.add(NodeUtil.makeRecursiveIterator((Node)target.getRootNode()));
        }

        @Override
        public boolean hasNext() {
            return this.peekIterator() != null;
        }

        @Override
        public Node next() {
            Iterator<Node> iterator = this.peekIterator();
            if (iterator == null) {
                throw new NoSuchElementException();
            }
            Node node = iterator.next();
            if (node instanceof OptimizedDirectCallNode) {
                this.visitInlinedCall(node);
            }
            return node;
        }

        private void visitInlinedCall(Node node) {
            TruffleInlining currentDecision = this.inliningDecisionStack.get(this.inliningDecisionStack.size() - 1);
            if (currentDecision == null) {
                return;
            }
            TruffleInliningDecision decision = currentDecision.findByCall((OptimizedDirectCallNode)node);
            if (decision != null && decision.shouldInline()) {
                this.inliningDecisionStack.add(decision);
                this.iteratorStack.add(NodeUtil.makeRecursiveIterator((Node)decision.getTarget().getRootNode()));
            }
        }

        private Iterator<Node> peekIterator() {
            int tos = this.iteratorStack.size() - 1;
            while (tos >= 0) {
                Iterator<Node> iterable = this.iteratorStack.get(tos);
                if (iterable.hasNext()) {
                    return iterable;
                }
                this.iteratorStack.remove(tos);
                this.inliningDecisionStack.remove(tos--);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class CallTreeNodeVisitorImpl
    implements NodeVisitor {
        protected final List<TruffleInlining> stack = new ArrayList<TruffleInlining>();
        private final NodeVisitor visitor;
        private boolean continueTraverse = true;

        CallTreeNodeVisitorImpl(NodeVisitor visitor) {
            this.stack.add(TruffleInlining.this);
            this.visitor = visitor;
        }

        public boolean visit(Node node) {
            if (node instanceof OptimizedDirectCallNode) {
                TruffleInliningDecision childInlining;
                OptimizedDirectCallNode callNode = (OptimizedDirectCallNode)node;
                TruffleInlining inlining = this.stack.get(this.stack.size() - 1);
                if (inlining != null && (childInlining = inlining.findByCall(callNode)) != null) {
                    this.stack.add(childInlining);
                    this.continueTraverse = this.visitNode(node);
                    if (this.continueTraverse && childInlining.shouldInline()) {
                        childInlining.getTarget().getRootNode().accept((NodeVisitor)this);
                    }
                    this.stack.remove(this.stack.size() - 1);
                }
                return this.continueTraverse;
            }
            this.continueTraverse = this.visitNode(node);
            return this.continueTraverse;
        }

        private boolean visitNode(Node node) {
            if (this.visitor instanceof CallTreeNodeVisitor) {
                return ((CallTreeNodeVisitor)this.visitor).visit(this.stack, node);
            }
            return this.visitor.visit(node);
        }
    }

    public static interface CallTreeNodeVisitor
    extends NodeVisitor {
        public boolean visit(List<TruffleInlining> var1, Node var2);

        default public boolean visit(Node node) {
            return this.visit(null, node);
        }

        public static int getNodeDepth(List<TruffleInlining> decisionStack, Node node) {
            int depth = CallTreeNodeVisitor.calculateNodeDepth(node);
            if (decisionStack != null) {
                for (int i = decisionStack.size() - 1; i > 0; --i) {
                    TruffleInliningDecision decision = (TruffleInliningDecision)decisionStack.get(i);
                    depth += CallTreeNodeVisitor.calculateNodeDepth((Node)decision.getProfile().getCallNode());
                }
            }
            return depth;
        }

        public static int calculateNodeDepth(Node node) {
            int depth = 0;
            for (Node traverseNode = node; traverseNode != null; traverseNode = traverseNode.getParent()) {
                ++depth;
            }
            return depth;
        }

        public static TruffleInliningDecision getCurrentInliningDecision(List<TruffleInlining> decisionStack) {
            if (decisionStack == null || decisionStack.size() <= 1) {
                return null;
            }
            return (TruffleInliningDecision)decisionStack.get(decisionStack.size() - 1);
        }
    }

    static class TruffleSourceLanguagePosition
    implements org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition {
        private final SourceSection sourceSection;

        TruffleSourceLanguagePosition(SourceSection section) {
            this.sourceSection = section;
        }

        @Override
        public String getDescription() {
            return this.sourceSection.getSource().getURI() + " " + this.sourceSection.getStartLine() + ":" + this.sourceSection.getStartColumn();
        }

        @Override
        public int getOffsetEnd() {
            return this.sourceSection.getCharEndIndex();
        }

        @Override
        public int getOffsetStart() {
            return this.sourceSection.getCharIndex();
        }

        @Override
        public int getLineNumber() {
            return this.sourceSection.getStartLine();
        }

        @Override
        public URI getURI() {
            return this.sourceSection.getSource().getURI();
        }

        @Override
        public String getLanguage() {
            return this.sourceSection.getSource().getLanguage();
        }
    }
}

