/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import java.util.LinkedHashMap;
import java.util.Map;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleInliningPolicy;

public class TruffleInliningProfile {
    private final OptimizedDirectCallNode callNode;
    private final int nodeCount;
    private final int deepNodeCount;
    private final double frequency;
    private final int recursions;
    private TruffleInliningPolicy.FailedReason failedReason;
    private int queryIndex = -1;
    private double score;
    private TruffleInliningProfile cached;

    public TruffleInliningProfile(OptimizedDirectCallNode callNode, int nodeCount, int deepNodeCount, double frequency, int recursions) {
        this.callNode = callNode;
        this.nodeCount = nodeCount;
        this.deepNodeCount = deepNodeCount;
        this.frequency = frequency;
        this.recursions = recursions;
    }

    public boolean isCached() {
        return this.cached != null;
    }

    public TruffleInliningProfile getCached() {
        return this.cached;
    }

    public void setCached(TruffleInliningProfile cached) {
        this.cached = cached;
    }

    public int getRecursions() {
        return this.recursions;
    }

    public OptimizedDirectCallNode getCallNode() {
        return this.callNode;
    }

    public int getCallSites() {
        return this.callNode.getKnownCallSiteCount();
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public double getScore() {
        return this.score;
    }

    public TruffleInliningPolicy.FailedReason getFailedReason() {
        return this.failedReason;
    }

    public void setQueryIndex(int queryIndex) {
        this.queryIndex = queryIndex;
    }

    public int getQueryIndex() {
        return this.queryIndex;
    }

    public void setFailedReason(TruffleInliningPolicy.FailedReason reason) {
        this.failedReason = reason;
    }

    public boolean isForced() {
        return this.callNode.isInliningForced();
    }

    public double getFrequency() {
        return this.frequency;
    }

    public int getDeepNodeCount() {
        return this.deepNodeCount;
    }

    private String formatReason() {
        if (this.failedReason == null) {
            return null;
        }
        return this.failedReason.format(this.callNode.getCallTarget());
    }

    public Map<String, Object> getDebugProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("ASTSize", String.format("%5d/%5d", this.nodeCount, this.deepNodeCount));
        properties.put("frequency", String.format("%8.4f", this.getFrequency()));
        properties.put("score", String.format("%8.4f", this.getScore()));
        properties.put(String.format("index=%3d, force=%s, callSites=%2d", this.queryIndex, this.isForced() ? "Y" : "N", this.getCallSites()), "");
        properties.put("reason", this.cached == null ? this.formatReason() : this.formatReason() + " (cached)");
        return properties;
    }
}

