/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import java.util.List;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;

public final class TraceASTCompilationListener
extends AbstractGraalTruffleRuntimeListener {
    private TraceASTCompilationListener(GraalTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(GraalTruffleRuntime runtime) {
        runtime.addListener(new TraceASTCompilationListener(runtime));
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graphInfo, TruffleCompilerListener.CompilationResultInfo compilationResultInfo) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilationAST).booleanValue()) {
            this.runtime.logEvent(0, "opt AST", target.toString(), target.getDebugProperties(inliningDecision));
            this.printCompactTree(target, inliningDecision);
        }
    }

    private void printCompactTree(OptimizedCallTarget target, TruffleInlining inliningDecision) {
        target.accept(new TruffleInlining.CallTreeNodeVisitor(){

            @Override
            public boolean visit(List<TruffleInlining> decisionStack, Node node) {
                if (node == null) {
                    return true;
                }
                int level = TruffleInlining.CallTreeNodeVisitor.getNodeDepth(decisionStack, node);
                StringBuilder indent = new StringBuilder();
                for (int i = 0; i < level; ++i) {
                    indent.append("  ");
                }
                Node parent = node.getParent();
                if (parent == null) {
                    TraceASTCompilationListener.this.runtime.log(String.format("%s%s", indent, node.getClass().getSimpleName()));
                } else {
                    String fieldName = this.getFieldName(parent, node);
                    TraceASTCompilationListener.this.runtime.log(String.format("%s%s = %s", indent, fieldName, node.getClass().getSimpleName()));
                }
                return true;
            }

            private String getFieldName(Node parent, Node node) {
                for (NodeFieldAccessor field : NodeClass.get((Node)parent).getFields()) {
                    Object value = field.loadValue(parent);
                    if (value == node) {
                        return field.getName();
                    }
                    if (!(value instanceof Node[])) continue;
                    int index = 0;
                    for (Node arrayNode : (Node[])value) {
                        if (arrayNode == node) {
                            return field.getName() + "[" + index + "]";
                        }
                        ++index;
                    }
                }
                return "unknownField";
            }
        }, inliningDecision);
    }
}

