/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import com.oracle.truffle.api.nodes.Node;
import java.util.LinkedHashMap;
import java.util.List;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.OptimizedIndirectCallNode;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.TruffleInliningDecision;

public final class TraceCallTreeListener
extends AbstractGraalTruffleRuntimeListener {
    private TraceCallTreeListener(GraalTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(GraalTruffleRuntime runtime) {
        runtime.addListener(new TraceCallTreeListener(runtime));
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graphInfo, TruffleCompilerListener.CompilationResultInfo compilationResultInfo) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilationCallTree).booleanValue()) {
            this.runtime.logEvent(0, "opt call tree", target.toString(), target.getDebugProperties(inliningDecision));
            this.logTruffleCallTree(target, inliningDecision);
        }
    }

    private void logTruffleCallTree(OptimizedCallTarget compilable, final TruffleInlining inliningDecision) {
        TruffleInlining.CallTreeNodeVisitor visitor = new TruffleInlining.CallTreeNodeVisitor(){

            @Override
            public boolean visit(List<TruffleInlining> decisionStack, Node node) {
                if (node instanceof OptimizedDirectCallNode) {
                    OptimizedDirectCallNode callNode = (OptimizedDirectCallNode)node;
                    int depth = decisionStack == null ? 0 : decisionStack.size() - 1;
                    TruffleInliningDecision inlining = TruffleInlining.CallTreeNodeVisitor.getCurrentInliningDecision(decisionStack);
                    String dispatched = "<dispatched>";
                    if (inlining != null && inlining.shouldInline()) {
                        dispatched = "";
                    }
                    LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                    GraalTruffleRuntimeListener.addASTSizeProperty(callNode.getCurrentCallTarget(), inliningDecision, properties);
                    properties.putAll(callNode.getCurrentCallTarget().getDebugProperties(inliningDecision));
                    TraceCallTreeListener.this.runtime.logEvent(depth, "opt call tree", callNode.getCurrentCallTarget().toString() + dispatched, properties);
                } else if (node instanceof OptimizedIndirectCallNode) {
                    int depth = decisionStack == null ? 0 : decisionStack.size() - 1;
                    TraceCallTreeListener.this.runtime.logEvent(depth, "opt call tree", "<indirect>", new LinkedHashMap());
                }
                return true;
            }
        };
        compilable.accept(visitor, inliningDecision);
    }
}

