/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;

public final class TraceCompilationListener
extends AbstractGraalTruffleRuntimeListener {
    private final ThreadLocal<Times> currentCompilation = new ThreadLocal();

    private TraceCompilationListener(GraalTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(GraalTruffleRuntime runtime) {
        runtime.addListener(new TraceCompilationListener(runtime));
    }

    @Override
    public void onCompilationQueued(OptimizedCallTarget target) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilationDetails).booleanValue()) {
            this.runtime.logEvent(0, "opt queued", target.toString(), target.getDebugProperties(null));
        }
    }

    @Override
    public void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilationDetails).booleanValue()) {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            TraceCompilationListener.addSourceInfo(properties, source);
            properties.put("Reason", reason);
            this.runtime.logEvent(0, "opt unqueued", target.toString(), properties);
        }
    }

    @Override
    public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilation).booleanValue() || target.getOptionValue(PolyglotCompilerOptions.TraceCompilationDetails).booleanValue()) {
            if (!TraceCompilationListener.isPermanentFailure(bailout, permanentBailout)) {
                this.onCompilationDequeued(target, null, "Non permanent bailout: " + reason);
            }
            this.currentCompilation.set(null);
        }
    }

    @Override
    public void onCompilationStarted(OptimizedCallTarget target) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilationDetails).booleanValue()) {
            this.runtime.logEvent(0, "opt start", target.toString(), target.getDebugProperties(null));
        }
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilation).booleanValue() || target.getOptionValue(PolyglotCompilerOptions.TraceCompilationDetails).booleanValue()) {
            this.currentCompilation.set(new Times());
        }
    }

    @Override
    public void onCompilationDeoptimized(OptimizedCallTarget target, Frame frame) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilation).booleanValue() || target.getOptionValue(PolyglotCompilerOptions.TraceCompilationDetails).booleanValue()) {
            this.runtime.logEvent(0, "opt deopt", target.toString(), target.getDebugProperties(null));
        }
    }

    @Override
    public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilation).booleanValue() || target.getOptionValue(PolyglotCompilerOptions.TraceCompilationDetails).booleanValue()) {
            Times current = this.currentCompilation.get();
            current.timePartialEvaluationFinished = System.nanoTime();
            current.nodeCountPartialEval = graph.getNodeCount();
        }
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        int inlinedCalls;
        if (!target.getOptionValue(PolyglotCompilerOptions.TraceCompilation).booleanValue() && !target.getOptionValue(PolyglotCompilerOptions.TraceCompilationDetails).booleanValue()) {
            return;
        }
        long timeCompilationFinished = System.nanoTime();
        int nodeCountLowered = graph.getNodeCount();
        Times compilation = this.currentCompilation.get();
        int calls = 0;
        if (inliningDecision == null) {
            for (Node node : target.nodeIterable(null)) {
                if (!(node instanceof OptimizedDirectCallNode)) continue;
                ++calls;
            }
            inlinedCalls = 0;
        } else {
            calls = inliningDecision.countCalls();
            inlinedCalls = inliningDecision.countInlinedCalls();
        }
        int dispatchedCalls = calls - inlinedCalls;
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        GraalTruffleRuntimeListener.addASTSizeProperty(target, inliningDecision, properties);
        properties.put("Time", String.format("%5.0f(%4.0f+%-4.0f)ms", (double)(timeCompilationFinished - compilation.timeCompilationStarted) / 1000000.0, (double)(compilation.timePartialEvaluationFinished - compilation.timeCompilationStarted) / 1000000.0, (double)(timeCompilationFinished - compilation.timePartialEvaluationFinished) / 1000000.0));
        properties.put("DirectCallNodes", String.format("I %4d/D %4d", inlinedCalls, dispatchedCalls));
        properties.put("GraalNodes", String.format("%5d/%5d", compilation.nodeCountPartialEval, nodeCountLowered));
        properties.put("CodeSize", result.getTargetCodeSize());
        properties.put("CodeAddress", "0x" + Long.toHexString(target.getCodeAddress()));
        properties.put("Source", TraceCompilationListener.formatSourceSection(target.getRootNode().getSourceSection()));
        this.runtime.logEvent(0, "opt done", target.toString(), properties);
        this.currentCompilation.set(null);
    }

    private static String formatSourceSection(SourceSection sourceSection) {
        if (sourceSection == null || sourceSection.getSource() == null) {
            return "n/a";
        }
        return String.format("%s:%d", sourceSection.getSource().getName(), sourceSection.getStartLine());
    }

    @Override
    public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilation).booleanValue() || target.getOptionValue(PolyglotCompilerOptions.TraceCompilationDetails).booleanValue()) {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            TraceCompilationListener.addSourceInfo(properties, source);
            properties.put("Reason", reason);
            this.runtime.logEvent(0, "opt invalidated", target.toString(), properties);
        }
    }

    private static void addSourceInfo(Map<String, Object> properties, Object source) {
        if (source != null) {
            properties.put("SourceClass", source.getClass().getSimpleName());
            properties.put("Source", source);
        }
    }

    private static boolean isPermanentFailure(boolean bailout, boolean permanentBailout) {
        return !bailout || permanentBailout;
    }

    private static final class Times {
        final long timeCompilationStarted = System.nanoTime();
        long timePartialEvaluationFinished;
        long nodeCountPartialEval;

        private Times() {
        }
    }
}

