/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.runtime.JVMCI;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.SharedTruffleRuntimeOptions;
import org.graalvm.compiler.truffle.runtime.TruffleCallBoundary;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;
import org.graalvm.compiler.truffle.runtime.hotspot.HotSpotOptimizedCallTarget;
import sun.misc.Unsafe;

public abstract class AbstractHotSpotTruffleRuntime
extends GraalTruffleRuntime
implements HotSpotTruffleCompilerRuntime {
    private static final Unsafe UNSAFE = AbstractHotSpotTruffleRuntime.getUnsafe();
    private Boolean traceTransferToInterpreter;
    private volatile Lazy lazy;
    private volatile String lazyConfigurationName;
    private List<ResolvedJavaMethod> truffleCallBoundaryMethods;
    protected boolean reportedTruffleCompilerInitializationFailure;

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    public AbstractHotSpotTruffleRuntime() {
        super(Arrays.asList(HotSpotOptimizedCallTarget.class));
        AbstractHotSpotTruffleRuntime.setDontInlineCallBoundaryMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lazy lazy() {
        if (this.lazy == null) {
            AbstractHotSpotTruffleRuntime abstractHotSpotTruffleRuntime = this;
            synchronized (abstractHotSpotTruffleRuntime) {
                if (this.lazy == null) {
                    this.lazy = new Lazy(this);
                }
            }
        }
        return this.lazy;
    }

    @Override
    public synchronized Iterable<ResolvedJavaMethod> getTruffleCallBoundaryMethods() {
        if (this.truffleCallBoundaryMethods == null) {
            this.truffleCallBoundaryMethods = new ArrayList<ResolvedJavaMethod>();
            MetaAccessProvider metaAccess = AbstractHotSpotTruffleRuntime.getMetaAccess();
            ResolvedJavaType type = metaAccess.lookupJavaType(OptimizedCallTarget.class);
            for (ResolvedJavaMethod method : type.getDeclaredMethods()) {
                if (method.getAnnotation(TruffleCallBoundary.class) == null) continue;
                this.truffleCallBoundaryMethods.add(method);
            }
        }
        return this.truffleCallBoundaryMethods;
    }

    @Override
    protected StackIntrospection getStackIntrospection() {
        Lazy l = this.lazy();
        if (l.stackIntrospection == null) {
            l.stackIntrospection = HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getStackIntrospection();
        }
        return l.stackIntrospection;
    }

    @Override
    public HotSpotTruffleCompiler getTruffleCompiler() {
        if (this.truffleCompiler == null) {
            this.initializeTruffleCompiler();
        }
        return (HotSpotTruffleCompiler)this.truffleCompiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTruffleCompiler() {
        AbstractHotSpotTruffleRuntime abstractHotSpotTruffleRuntime = this;
        synchronized (abstractHotSpotTruffleRuntime) {
            block6: {
                if (this.truffleCompiler == null) {
                    try {
                        this.truffleCompiler = this.newTruffleCompiler();
                    }
                    catch (Throwable e) {
                        if (this.reportedTruffleCompilerInitializationFailure) break block6;
                        this.reportedTruffleCompilerInitializationFailure = true;
                        this.log(this.printStackTraceToString(e));
                    }
                }
            }
        }
    }

    @Override
    public OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget source, RootNode rootNode) {
        return new HotSpotOptimizedCallTarget(source, rootNode);
    }

    @Override
    public void onCodeInstallation(CompilableTruffleAST compilable, InstalledCode installedCode) {
        HotSpotOptimizedCallTarget callTarget = (HotSpotOptimizedCallTarget)compilable;
        callTarget.setInstalledCode(installedCode);
    }

    @Override
    public SpeculationLog createSpeculationLog() {
        return new HotSpotSpeculationLog();
    }

    public static void setDontInlineCallBoundaryMethod() {
        MetaAccessProvider metaAccess = AbstractHotSpotTruffleRuntime.getMetaAccess();
        ResolvedJavaType type = metaAccess.lookupJavaType(OptimizedCallTarget.class);
        for (ResolvedJavaMethod method : type.getDeclaredMethods()) {
            if (method.getAnnotation(TruffleCallBoundary.class) == null) continue;
            AbstractHotSpotTruffleRuntime.setNotInlinableOrCompilable(method);
        }
    }

    static MetaAccessProvider getMetaAccess() {
        return JVMCI.getRuntime().getHostJVMCIBackend().getMetaAccess();
    }

    private static void setNotInlinableOrCompilable(ResolvedJavaMethod method) {
        Method[] methods;
        for (Method m : methods = HotSpotResolvedJavaMethod.class.getMethods()) {
            if (!m.getName().equals("setNotInlineable") && !m.getName().equals("setNotInlinableOrCompilable") && !m.getName().equals("setNotInlineableOrCompileable")) continue;
            try {
                m.invoke((Object)method, new Object[0]);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new InternalError(e);
            }
        }
        throw new InternalError(String.format("Could not find setNotInlineable, setNotInlinableOrCompilable or setNotInlineableOrCompileable in %s", HotSpotResolvedJavaMethod.class));
    }

    @Override
    protected BackgroundCompileQueue getCompileQueue() {
        return this.lazy();
    }

    @Override
    protected String getCompilerConfigurationName() {
        TruffleCompiler compiler = this.truffleCompiler;
        String compilerConfig = compiler != null ? compiler.getCompilerConfigurationName() : this.getLazyCompilerConfigurationName();
        return compilerConfig;
    }

    private boolean verifyCompilerConfiguration(String name) {
        String lazyName = this.getLazyCompilerConfigurationName();
        if (!name.equals(lazyName)) {
            throw new AssertionError((Object)("Expected compiler configuration name " + name + " but was " + lazyName + "."));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLazyCompilerConfigurationName() {
        String compilerConfig = this.lazyConfigurationName;
        if (compilerConfig == null) {
            AbstractHotSpotTruffleRuntime abstractHotSpotTruffleRuntime = this;
            synchronized (abstractHotSpotTruffleRuntime) {
                compilerConfig = this.lazyConfigurationName;
                if (compilerConfig == null) {
                    this.lazyConfigurationName = compilerConfig = this.initLazyCompilerConfigurationName();
                }
            }
        }
        return compilerConfig;
    }

    protected abstract String initLazyCompilerConfigurationName();

    @Override
    public boolean cancelInstalledTask(OptimizedCallTarget optimizedCallTarget, Object source, CharSequence reason) {
        if (this.lazy == null) {
            return false;
        }
        return super.cancelInstalledTask(optimizedCallTarget, source, reason);
    }

    @Override
    public void bypassedInstalledCode() {
        this.getTruffleCompiler().installTruffleCallBoundaryMethods();
    }

    @Override
    protected GraalTruffleRuntime.CallMethods getCallMethods() {
        if (this.callMethods == null) {
            this.lookupCallMethods(AbstractHotSpotTruffleRuntime.getMetaAccess());
        }
        return this.callMethods;
    }

    public void notifyTransferToInterpreter() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.traceTransferToInterpreter == null) {
            this.traceTransferToInterpreter = TruffleRuntimeOptions.getValue(SharedTruffleRuntimeOptions.TraceTruffleTransferToInterpreter);
        }
        if (this.traceTransferToInterpreter.booleanValue()) {
            TraceTransferToInterpreterHelper.traceTransferToInterpreter(this, this.getTruffleCompiler());
        }
    }

    @Override
    protected JavaConstant forObject(Object object) {
        HotSpotConstantReflectionProvider constantReflection = (HotSpotConstantReflectionProvider)HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getConstantReflection();
        return constantReflection.forObject(object);
    }

    @Override
    protected <T> T asObject(Class<T> type, JavaConstant constant) {
        if (constant.isNull()) {
            return null;
        }
        HotSpotObjectConstant hsConstant = (HotSpotObjectConstant)constant;
        return (T)hsConstant.asObject(type);
    }

    private static class TraceTransferToInterpreterHelper {
        private static final long THREAD_EETOP_OFFSET;

        private TraceTransferToInterpreterHelper() {
        }

        static void traceTransferToInterpreter(AbstractHotSpotTruffleRuntime runtime, HotSpotTruffleCompiler compiler) {
            boolean deoptimized;
            long thread = UNSAFE.getLong(Thread.currentThread(), THREAD_EETOP_OFFSET);
            long pendingTransferToInterpreterAddress = thread + (long)compiler.pendingTransferToInterpreterOffset();
            boolean bl = deoptimized = UNSAFE.getByte(pendingTransferToInterpreterAddress) != 0;
            if (deoptimized) {
                TraceTransferToInterpreterHelper.logTransferToInterpreter(runtime);
                UNSAFE.putByte(pendingTransferToInterpreterAddress, (byte)0);
            }
        }

        private static String formatStackFrame(FrameInstance frameInstance, CallTarget target) {
            StringBuilder builder = new StringBuilder();
            if (target instanceof RootCallTarget) {
                RootNode root = ((RootCallTarget)target).getRootNode();
                String name = root.getName();
                if (name == null) {
                    builder.append("unnamed-root");
                } else {
                    builder.append(name);
                }
                Node callNode = frameInstance.getCallNode();
                SourceSection sourceSection = null;
                if (callNode != null) {
                    sourceSection = callNode.getEncapsulatingSourceSection();
                }
                if (sourceSection == null) {
                    sourceSection = root.getSourceSection();
                }
                if (sourceSection == null || sourceSection.getSource() == null) {
                    builder.append("(Unknown)");
                } else {
                    builder.append("(").append(TraceTransferToInterpreterHelper.formatPath(sourceSection)).append(":").append(sourceSection.getStartLine()).append(")");
                }
                if (target instanceof OptimizedCallTarget) {
                    OptimizedCallTarget callTarget = (OptimizedCallTarget)target;
                    if (callTarget.isValid()) {
                        builder.append(" <opt>");
                    }
                    if (callTarget.getSourceCallTarget() != null) {
                        builder.append(" <split-" + Integer.toHexString(callTarget.hashCode()) + ">");
                    }
                }
            } else {
                builder.append(target.toString());
            }
            return builder.toString();
        }

        private static String formatPath(SourceSection sourceSection) {
            if (sourceSection.getSource().getPath() != null) {
                Path path = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath();
                Path filePath = FileSystems.getDefault().getPath(sourceSection.getSource().getPath(), new String[0]).toAbsolutePath();
                try {
                    return path.relativize(filePath).toString();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return sourceSection.getSource().getName();
        }

        private static void logTransferToInterpreter(final AbstractHotSpotTruffleRuntime runtime) {
            OptimizedCallTarget callTarget = (OptimizedCallTarget)runtime.getCurrentFrame().getCallTarget();
            final int limit = callTarget.getOptionValue(PolyglotCompilerOptions.TraceStackTraceLimit);
            runtime.log("[truffle] transferToInterpreter at");
            runtime.iterateFrames(new FrameInstanceVisitor<Object>(){
                int frameIndex = 0;

                public Object visitFrame(FrameInstance frameInstance) {
                    CallTarget target = frameInstance.getCallTarget();
                    StringBuilder line = new StringBuilder("  ");
                    if (this.frameIndex > 0) {
                        line.append("  ");
                    }
                    line.append(TraceTransferToInterpreterHelper.formatStackFrame(frameInstance, target));
                    ++this.frameIndex;
                    runtime.log(line.toString());
                    if (this.frameIndex < limit) {
                        return null;
                    }
                    runtime.log("    ...");
                    return frameInstance;
                }
            });
            int skip = 3;
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            String suffix = stackTrace.length > 3 + limit ? "\n    ..." : "";
            runtime.log(Arrays.stream(stackTrace).skip(3L).limit(limit).map(StackTraceElement::toString).collect(Collectors.joining("\n    ", "  ", suffix)));
        }

        static {
            try {
                THREAD_EETOP_OFFSET = UNSAFE.objectFieldOffset(Thread.class.getDeclaredField("eetop"));
            }
            catch (Exception e) {
                throw new InternalError(e);
            }
        }
    }

    static class Lazy
    extends BackgroundCompileQueue {
        StackIntrospection stackIntrospection;

        Lazy(AbstractHotSpotTruffleRuntime runtime) {
            runtime.installDefaultListeners();
        }
    }
}

