/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleDebugJavaMethod;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.HotSpotToSVMCalls;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMHotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMObject;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMTruffleCompilation;
import org.graalvm.graphio.GraphOutput;
import org.graalvm.libgraal.LibGraalScope;
import org.graalvm.util.OptionsEncoder;

final class IgvSupport
extends SVMObject
implements TruffleDebugContext {
    private static final String SOURCE_PREFIX = "SOURCE=";
    private static volatile Map<Object, Object> versionProperties;
    private final SVMHotSpotTruffleCompiler owner;
    private final LibGraalScope scope;
    private GraphOutput<?, ?> parentOutput;
    private IgvDumpChannel sharedChannel;

    private IgvSupport(LibGraalScope scope, SVMHotSpotTruffleCompiler owner, long handle) {
        super(handle);
        Objects.requireNonNull(owner, "Owner must be non null.");
        this.owner = owner;
        this.scope = scope;
    }

    @Override
    public <G, N, M> GraphOutput<G, M> buildOutput(GraphOutput.Builder<G, N, M> builder) throws IOException {
        GraphOutput<?, ?> parent = this.parentOutput;
        if (parent != null) {
            return builder.build(parent);
        }
        if (this.sharedChannel == null) {
            this.sharedChannel = new IgvDumpChannel(HotSpotToSVMCalls.getDumpChannel(LibGraalScope.getIsolateThread(), this.handle));
        }
        GraphOutput<G, M> res = builder.embedded(true).build(this.sharedChannel);
        this.parentOutput = res;
        return res;
    }

    @Override
    public boolean isDumpEnabled() {
        return HotSpotToSVMCalls.isBasicDumpEnabled(LibGraalScope.getIsolateThread(), this.handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<Object, Object> getVersionProperties() {
        Map<Object, Object> res = versionProperties;
        if (res != null) return res;
        Class<IgvSupport> clazz = IgvSupport.class;
        synchronized (IgvSupport.class) {
            res = versionProperties;
            if (res != null) return res;
            res = new HashMap<Object, Object>();
            Path releaseFile = IgvSupport.findReleaseFile();
            if (releaseFile != null) {
                try {
                    for (String line : Files.readAllLines(releaseFile)) {
                        if (!line.startsWith(SOURCE_PREFIX)) continue;
                        for (String versionInfo : line.substring(SOURCE_PREFIX.length()).replace('\"', ' ').split(" ")) {
                            String[] idVersion = versionInfo.split(":");
                            if (idVersion == null || idVersion.length != 2) continue;
                            res.put("version." + idVersion[0], idVersion[1]);
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            versionProperties = res = Collections.unmodifiableMap(res);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return res;
        }
    }

    @Override
    public Closeable scope(String name) {
        return this.scope(name, null);
    }

    @Override
    public Closeable scope(String name, Object context) {
        CompilableTruffleAST compilable = context instanceof TruffleDebugJavaMethod ? ((TruffleDebugJavaMethod)context).getCompilable() : null;
        SVMTruffleCompilation compilation = compilable != null ? this.owner.findCompilation(compilable) : null;
        long compilationHandle = compilation != null ? compilation.handle : 0L;
        long scopeHandle = HotSpotToSVMCalls.openDebugContextScope(LibGraalScope.getIsolateThread(), this.handle, name, compilationHandle);
        return scopeHandle == 0L ? null : new Scope(scopeHandle);
    }

    @Override
    public void close() {
        try {
            HotSpotToSVMCalls.closeDebugContext(LibGraalScope.getIsolateThread(), this.handle);
        }
        finally {
            this.scope.close();
        }
    }

    @Override
    public void closeDebugChannels() {
    }

    private static Path findReleaseFile() {
        String home = (String)Services.getSavedProperties().get("java.home");
        if (home == null) {
            return null;
        }
        Path jreDir = Paths.get(home, new String[0]);
        if (jreDir == null) {
            return null;
        }
        Path releaseFile = jreDir.resolve("release");
        if (Files.exists(releaseFile, new LinkOption[0])) {
            return releaseFile;
        }
        Path jdkDir = jreDir.getParent();
        if (jdkDir == null) {
            return null;
        }
        releaseFile = jdkDir.resolve("release");
        return Files.exists(releaseFile, new LinkOption[0]) ? releaseFile : null;
    }

    static IgvSupport create(SVMHotSpotTruffleCompiler compiler, Map<String, Object> options, SVMTruffleCompilation compilation) {
        byte[] encodedOptions = OptionsEncoder.encode(options);
        LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());
        return new IgvSupport(scope, compiler, HotSpotToSVMCalls.openDebugContext(LibGraalScope.getIsolateThread(), compiler.handle, compilation == null ? 0L : compilation.handle, encodedOptions));
    }

    private static final class Scope
    extends SVMObject
    implements Closeable {
        Scope(long handle) {
            super(handle);
        }

        @Override
        public void close() {
            HotSpotToSVMCalls.closeDebugContextScope(LibGraalScope.getIsolateThread(), this.handle);
        }
    }

    private static final class IgvDumpChannel
    extends SVMObject
    implements WritableByteChannel {
        IgvDumpChannel(long handle) {
            super(handle);
        }

        static Buffer asBaseBuffer(Buffer obj) {
            return obj;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            if (src.hasArray()) {
                throw new IllegalArgumentException("Only direct ByteBuffer is supported.");
            }
            int capacity = src.capacity();
            int pos = src.position();
            int limit = src.limit();
            int written = HotSpotToSVMCalls.dumpChannelWrite(LibGraalScope.getIsolateThread(), this.handle, src, capacity, pos, limit);
            if (written > 0) {
                IgvDumpChannel.asBaseBuffer(src).position(pos + written);
            }
            return written;
        }

        @Override
        public boolean isOpen() {
            return HotSpotToSVMCalls.isDumpChannelOpen(LibGraalScope.getIsolateThread(), this.handle);
        }

        @Override
        public void close() throws IOException {
            HotSpotToSVMCalls.dumpChannelClose(LibGraalScope.getIsolateThread(), this.handle);
        }
    }
}

