/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.truffle.common.CallNodeProvider;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.SVMToHotSpot;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMCompilationResultInfo;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMGraphInfo;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMStringSupplier;
import org.graalvm.libgraal.LibGraal;

final class SVMToHotSpotEntryPoints {
    private static final Map<Integer, JavaKind> JAVA_KINDS;
    private static final HotSpotJVMCIRuntime jvmciRuntime;

    SVMToHotSpotEntryPoints() {
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.ConsumeOptimizedAssumptionDependency)
    static void consumeOptimizedAssumptionDependency(Consumer<OptimizedAssumptionDependency> consumer, OptimizedAssumptionDependency dep) {
        consumer.accept(dep);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCallTargetForCallNode)
    static long getCallTargetForCallNode(HotSpotTruffleCompilerRuntime truffleRuntime, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(jvmciRuntime, JavaConstant.class, callNodeHandle);
        JavaConstant callTarget = truffleRuntime.getCallTargetForCallNode(callNode);
        return LibGraal.translate(jvmciRuntime, callTarget);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.IsTruffleBoundary)
    static boolean isTruffleBoundary(HotSpotTruffleCompilerRuntime truffleRuntime, long methodHandle) {
        ResolvedJavaMethod method = LibGraal.unhand(jvmciRuntime, ResolvedJavaMethod.class, methodHandle);
        return truffleRuntime.isTruffleBoundary(method);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.IsValueType)
    static boolean isValueType(HotSpotTruffleCompilerRuntime truffleRuntime, long typeHandle) {
        ResolvedJavaType type = LibGraal.unhand(jvmciRuntime, ResolvedJavaType.class, typeHandle);
        return truffleRuntime.isValueType(type);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetInlineKind)
    static int getInlineKind(HotSpotTruffleCompilerRuntime truffleRuntime, long methodHandle, boolean duringPartialEvaluation) {
        ResolvedJavaMethod method = LibGraal.unhand(jvmciRuntime, ResolvedJavaMethod.class, methodHandle);
        TruffleCompilerRuntime.InlineKind inlineKind = truffleRuntime.getInlineKind(method, duringPartialEvaluation);
        return inlineKind.ordinal();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetLoopExplosionKind)
    static int getLoopExplosionKind(HotSpotTruffleCompilerRuntime truffleRuntime, long methodHandle) {
        ResolvedJavaMethod method = LibGraal.unhand(jvmciRuntime, ResolvedJavaMethod.class, methodHandle);
        TruffleCompilerRuntime.LoopExplosionKind loopExplosionKind = truffleRuntime.getLoopExplosionKind(method);
        return loopExplosionKind.ordinal();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetConstantFieldInfo)
    static int getConstantFieldInfo(HotSpotTruffleCompilerRuntime truffleRuntime, long typeHandle, boolean isStatic, int fieldIndex) {
        ResolvedJavaType enclosing = LibGraal.unhand(jvmciRuntime, ResolvedJavaType.class, typeHandle);
        ResolvedJavaField[] declaredFields = isStatic ? enclosing.getStaticFields() : enclosing.getInstanceFields(false);
        ResolvedJavaField field = declaredFields[fieldIndex];
        TruffleCompilerRuntime.ConstantFieldInfo constantFieldInfo = truffleRuntime.getConstantFieldInfo(field);
        if (constantFieldInfo == null) {
            return Integer.MIN_VALUE;
        }
        if (constantFieldInfo.isChildren()) {
            return -2;
        }
        if (constantFieldInfo.isChild()) {
            return -1;
        }
        return constantFieldInfo.getDimensions();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetJavaKindForFrameSlotKind)
    static int getJavaKindForFrameSlotKind(HotSpotTruffleCompilerRuntime truffleRuntime, int frameSlotKindTag) {
        JavaKind kind = truffleRuntime.getJavaKindForFrameSlotKind(frameSlotKindTag);
        return kind.getBasicType();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetFrameSlotKindTagsCount)
    static int getFrameSlotKindTagsCount(HotSpotTruffleCompilerRuntime truffleRuntime) {
        return truffleRuntime.getFrameSlotKindTagsCount();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetTruffleCallBoundaryMethods)
    static long[] getTruffleCallBoundaryMethods(HotSpotTruffleCompilerRuntime truffleRuntime) {
        ArrayList<ResolvedJavaMethod> source;
        Iterable<ResolvedJavaMethod> iterable = truffleRuntime.getTruffleCallBoundaryMethods();
        if (iterable instanceof Collection) {
            source = (ArrayList<ResolvedJavaMethod>)iterable;
        } else {
            source = new ArrayList<ResolvedJavaMethod>();
            for (ResolvedJavaMethod m : iterable) {
                source.add(m);
            }
        }
        long[] res = new long[source.size()];
        int i = 0;
        for (ResolvedJavaMethod m : source) {
            res[i++] = LibGraal.translate(jvmciRuntime, m);
        }
        return res;
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetFrameSlotKindTagForJavaKind)
    static int getFrameSlotKindTagForJavaKind(HotSpotTruffleCompilerRuntime truffleRuntime, int basicType) {
        JavaKind kind = SVMToHotSpotEntryPoints.getJavaKind(basicType);
        return truffleRuntime.getFrameSlotKindTagForJavaKind(kind);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.Log)
    static void log(HotSpotTruffleCompilerRuntime truffleRuntime, String message) {
        truffleRuntime.log(message);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.CreateInliningPlan)
    static TruffleInliningPlan createInliningPlan(HotSpotTruffleCompilerRuntime truffleRuntime, CompilableTruffleAST compilable, TruffleCompilationTask task) {
        return truffleRuntime.createInliningPlan(compilable, task);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.RegisterOptimizedAssumptionDependency)
    static Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(HotSpotTruffleCompilerRuntime truffleRuntime, long optimizedAssumptionHandle) {
        JavaConstant optimizedAssumption = LibGraal.unhand(jvmciRuntime, JavaConstant.class, optimizedAssumptionHandle);
        return truffleRuntime.registerOptimizedAssumptionDependency(optimizedAssumption);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.AsCompilableTruffleAST)
    static CompilableTruffleAST asCompilableTruffleAST(HotSpotTruffleCompilerRuntime truffleRuntime, long constantHandle) {
        JavaConstant constant = LibGraal.unhand(jvmciRuntime, JavaConstant.class, constantHandle);
        return truffleRuntime.asCompilableTruffleAST(constant);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.FindDecision)
    static TruffleInliningPlan.Decision findDecision(TruffleInliningPlan inliningPlan, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(jvmciRuntime, JavaConstant.class, callNodeHandle);
        return inliningPlan.findDecision(callNode);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetPosition)
    static TruffleSourceLanguagePosition getPosition(TruffleInliningPlan inliningPlan, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(jvmciRuntime, JavaConstant.class, callNodeHandle);
        return inliningPlan.getPosition(callNode);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetNodeRewritingAssumption)
    static long getNodeRewritingAssumption(TruffleInliningPlan.Decision decision) {
        JavaConstant assumption = decision.getNodeRewritingAssumption();
        return LibGraal.translate(jvmciRuntime, assumption);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetURI)
    static String getURI(TruffleSourceLanguagePosition position) {
        URI uri = position.getURI();
        return uri == null ? null : uri.toString();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.AsJavaConstant)
    static long asJavaConstant(CompilableTruffleAST compilable) {
        JavaConstant constant = compilable.asJavaConstant();
        return LibGraal.translate(jvmciRuntime, constant);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.OnCodeInstallation)
    static void onCodeInstallation(HotSpotTruffleCompilerRuntime truffleRuntime, CompilableTruffleAST compilable, long installedCodeHandle) {
        InstalledCode installedCode = LibGraal.unhand(jvmciRuntime, InstalledCode.class, installedCodeHandle);
        truffleRuntime.onCodeInstallation(compilable, installedCode);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetFailedSpeculationsAddress)
    static long getFailedSpeculationsAddress(CompilableTruffleAST compilable) {
        OptimizedCallTarget callTarget = (OptimizedCallTarget)compilable;
        HotSpotSpeculationLog log = (HotSpotSpeculationLog)callTarget.getSpeculationLog();
        return LibGraal.getFailedSpeculationsAddress(log);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.UpdateStackTrace)
    static Throwable updateStackTrace(Throwable target, String[] rawElements) {
        StackTraceElement[] elements = new StackTraceElement[rawElements.length];
        for (int i = 0; i < rawElements.length; ++i) {
            String[] parts = rawElements[i].split("\\|");
            String className = parts[0];
            String methodName = parts[1];
            String fileName = parts[2];
            int lineNumber = Integer.parseInt(parts[3]);
            elements[i] = new StackTraceElement(className, methodName, fileName.isEmpty() ? null : fileName, lineNumber);
        }
        target.setStackTrace(elements);
        return target;
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.CreateException)
    static Throwable createException(String message) {
        return new RuntimeException(message);
    }

    private static JavaKind getJavaKind(int basicType) {
        JavaKind javaKind = JAVA_KINDS.get(basicType);
        if (javaKind == null) {
            throw new IllegalArgumentException("Unknown JavaKind basic type: " + basicType);
        }
        return javaKind;
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.CreateStringSupplier)
    static Supplier<String> createStringSupplier(long handle) {
        return new SVMStringSupplier(handle);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetSuppliedString)
    static String getSuppliedString(Supplier<String> supplier) {
        return supplier.get();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.IsCancelled)
    static boolean isCancelled(TruffleCompilationTask task) {
        return task.isCancelled();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.IsLastTier)
    static boolean isLastTier(TruffleCompilationTask task) {
        return task.isLastTier();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.CompilableToString)
    static String compilableToString(CompilableTruffleAST compilable) {
        return compilable.toString();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCompilableName)
    static String getCompilableName(CompilableTruffleAST compilable) {
        return compilable.getName();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetDescription)
    static String getDescription(TruffleSourceLanguagePosition pos) {
        return pos.getDescription();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetLanguage)
    static String getLanguage(TruffleSourceLanguagePosition pos) {
        return pos.getLanguage();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetLineNumber)
    static int getLineNumber(TruffleSourceLanguagePosition pos) {
        return pos.getLineNumber();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetOffsetEnd)
    static int getOffsetEnd(TruffleSourceLanguagePosition pos) {
        return pos.getOffsetEnd();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetOffsetStart)
    static int getOffsetStart(TruffleSourceLanguagePosition pos) {
        return pos.getOffsetStart();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetStackTrace)
    static StackTraceElement[] getStackTrace(Throwable throwable) {
        return throwable.getStackTrace();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetStackTraceElementClassName)
    static String getStackTraceElementClassName(StackTraceElement element) {
        return element.getClassName();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetStackTraceElementFileName)
    static String getStackTraceElementFileName(StackTraceElement element) {
        return element.getFileName();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetStackTraceElementLineNumber)
    static int getStackTraceElementLineNumber(StackTraceElement element) {
        return element.getLineNumber();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetStackTraceElementMethodName)
    static String getStackTraceElementMethodName(StackTraceElement element) {
        return element.getMethodName();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetTargetName)
    static String getTargetName(TruffleInliningPlan.Decision decision) {
        return decision.getTargetName();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.IsTargetStable)
    static boolean isTargetStable(TruffleInliningPlan.Decision decision) {
        return decision.isTargetStable();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.OnCompilationFailed)
    static void onCompilationFailed(CompilableTruffleAST compilable, Supplier<String> reasonAndStackTrace, boolean bailout, boolean permanentBailout) {
        compilable.onCompilationFailed(reasonAndStackTrace, bailout, permanentBailout);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.OnSuccess)
    static void onSuccess(TruffleCompilerListener listener, CompilableTruffleAST compilable, TruffleInliningPlan plan, long graphInfoHandle, long compilationResultInfoHandle) {
        try (SVMGraphInfo graphInfo = new SVMGraphInfo(graphInfoHandle);
             SVMCompilationResultInfo compilationResultInfo = new SVMCompilationResultInfo(compilationResultInfoHandle);){
            listener.onSuccess(compilable, plan, graphInfo, compilationResultInfo);
        }
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.OnFailure)
    static void onFailure(TruffleCompilerListener listener, CompilableTruffleAST compilable, String reason, boolean bailout, boolean permanentBailout) {
        listener.onFailure(compilable, reason, bailout, permanentBailout);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.OnGraalTierFinished)
    static void onGraalTierFinished(TruffleCompilerListener listener, CompilableTruffleAST compilable, long graphInfoHandle) {
        try (SVMGraphInfo graphInfo = new SVMGraphInfo(graphInfoHandle);){
            listener.onGraalTierFinished(compilable, graphInfo);
        }
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.OnTruffleTierFinished)
    static void onTruffleTierFinished(TruffleCompilerListener listener, CompilableTruffleAST compilable, TruffleInliningPlan plan, long graphInfoHandle) {
        try (SVMGraphInfo graphInfo = new SVMGraphInfo(graphInfoHandle);){
            listener.onTruffleTierFinished(compilable, plan, graphInfo);
        }
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.ShouldInline)
    static boolean shouldInline(TruffleInliningPlan.Decision decision) {
        return decision.shouldInline();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetThrowableMessage)
    static String getThrowableMessage(Throwable t) {
        return t.getMessage();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.CancelInstalledTask)
    static void cancelInstalledTask(CompilableTruffleAST compilableTruffleAST) {
        compilableTruffleAST.cancelInstalledTask();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.FindCallNode)
    static TruffleCallNode findCallNode(CallNodeProvider provider, long callNodeHandle) {
        JavaConstant callNode = LibGraal.unhand(jvmciRuntime, JavaConstant.class, callNodeHandle);
        return provider.findCallNode(callNode);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCallCount)
    static int getCallCount(TruffleCallNode callNode) {
        return callNode.getCallCount();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCurrentCallTarget)
    static CompilableTruffleAST getCurrentCallTarget(TruffleCallNode truffleCallNode) {
        return truffleCallNode.getCurrentCallTarget();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.IsInliningForced)
    static boolean isInliningForced(TruffleCallNode truffleCallNode) {
        return truffleCallNode.isInliningForced();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.CallNodeHashCode)
    static int callNodeHashCode(TruffleCallNode truffleCallNode) {
        return truffleCallNode.hashCode();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCompilableCallCount)
    static int getCompilableCallCount(CompilableTruffleAST compilableTruffleAST) {
        return compilableTruffleAST.getCallCount();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCallNodes)
    static TruffleCallNode[] getCallNodes(CompilableTruffleAST compilableTruffleAST) {
        return compilableTruffleAST.getCallNodes();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetKnownCallSiteCount)
    static int getKnownCallSiteCount(CompilableTruffleAST compilableTruffleAST) {
        return compilableTruffleAST.getKnownCallSiteCount();
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.IsSameOrSplit)
    static boolean isSameOrSplit(CompilableTruffleAST compilableTruffleAST1, CompilableTruffleAST compilableTruffleAST2) {
        return compilableTruffleAST1.isSameOrSplit(compilableTruffleAST2);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetNonTrivialNodeCount)
    static int getNonTrivialNodeCount(CompilableTruffleAST compilableTruffleAST) {
        return compilableTruffleAST.getNonTrivialNodeCount();
    }

    private static boolean checkHotSpotCalls() {
        EnumSet<SVMToHotSpot.Id> unimplemented = EnumSet.allOf(SVMToHotSpot.Id.class);
        for (Method method : SVMToHotSpotEntryPoints.class.getDeclaredMethods()) {
            SVMToHotSpot a;
            if (!Modifier.isStatic(method.getModifiers()) || (a = method.getAnnotation(SVMToHotSpot.class)) == null) continue;
            SVMToHotSpot.Id id = a.value();
            unimplemented.remove((Object)id);
            SVMToHotSpotEntryPoints.check(id, id.getMethodName().equals(method.getName()), "Expected name \"%s\", got \"%s\"", id.getMethodName(), method.getName());
            SVMToHotSpotEntryPoints.check(id, id.getReturnType().equals(method.getReturnType()), "Expected return type %s, got %s", id.getReturnType().getName(), method.getReturnType().getName());
            SVMToHotSpotEntryPoints.checkParameters(id, method.getParameterTypes());
        }
        SVMToHotSpotEntryPoints.check(null, unimplemented.isEmpty(), "Missing implementations:%n%s", unimplemented.stream().map(SVMToHotSpotEntryPoints::missingImpl).sorted().collect(Collectors.joining(System.lineSeparator())));
        return true;
    }

    private static void checkParameters(SVMToHotSpot.Id id, Class<?>[] types) {
        Class<?>[] idTypes = id.getParameterTypes();
        SVMToHotSpotEntryPoints.check(id, idTypes.length == types.length, "Expected %d parameters, got %d", idTypes.length, types.length);
        for (int i = 0; i < types.length; ++i) {
            SVMToHotSpotEntryPoints.check(id, idTypes[i].equals(types[i]), "Parameter %d has wrong type, expected %s, got %s", i, idTypes[i].getName(), types[i].getName());
        }
    }

    private static String missingImpl(SVMToHotSpot.Id id) {
        Formatter buf = new Formatter();
        buf.format("    @%s(%s)%n", SVMToHotSpot.class.getSimpleName(), id.name());
        buf.format("    static %s %s(%s) {%n    }%n", id.getReturnType().getSimpleName(), id.getMethodName(), Stream.of(id.getParameterTypes()).map(c -> c.getSimpleName()).collect(Collectors.joining(", ")));
        return buf.toString();
    }

    private static void check(SVMToHotSpot.Id id, boolean condition, String format, Object ... args) {
        if (!condition) {
            String msg = String.format(format, args);
            if (id != null) {
                System.err.printf("ERROR: %s.%s: %s%n", new Object[]{SVMToHotSpotEntryPoints.class.getName(), id, msg});
            } else {
                System.err.printf("ERROR: %s: %s%n", SVMToHotSpotEntryPoints.class.getName(), msg);
            }
            System.exit(99);
        }
    }

    static {
        HashMap<Integer, JavaKind> m = new HashMap<Integer, JavaKind>();
        for (JavaKind jk : JavaKind.values()) {
            m.put(jk.getBasicType(), jk);
        }
        JAVA_KINDS = Collections.unmodifiableMap(m);
        assert (SVMToHotSpotEntryPoints.checkHotSpotCalls());
        jvmciRuntime = HotSpotJVMCIRuntime.runtime();
    }
}

