/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.graph.ReentrantBlockIterator;
import org.graalvm.compiler.virtual.phases.ea.EffectsBlockState;
import org.graalvm.compiler.virtual.phases.ea.EffectsPhase;
import org.graalvm.compiler.virtual.phases.ea.GraphEffectList;
import org.graalvm.compiler.virtual.phases.ea.VirtualUtil;
import org.graalvm.word.LocationIdentity;

public abstract class EffectsClosure<BlockT extends EffectsBlockState<BlockT>>
extends EffectsPhase.Closure<BlockT> {
    protected final ControlFlowGraph cfg;
    protected final StructuredGraph.ScheduleResult schedule;
    protected final NodeMap<ValueNode> aliases;
    private final NodeBitMap hasScalarReplacedInputs;
    protected final BlockMap<GraphEffectList> blockEffects;
    protected final EconomicMap<Loop<Block>, GraphEffectList> loopMergeEffects = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    private final EconomicMap<LoopBeginNode, BlockT> loopEntryStates = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    protected final EconomicMap<Loop<Block>, LoopKillCache> loopLocationKillCache = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    protected boolean changed;
    protected final DebugContext debug;

    public EffectsClosure(StructuredGraph.ScheduleResult schedule, ControlFlowGraph cfg) {
        this.schedule = schedule;
        this.cfg = cfg;
        this.aliases = cfg.graph.createNodeMap();
        this.hasScalarReplacedInputs = cfg.graph.createNodeBitMap();
        this.blockEffects = new BlockMap(cfg);
        this.debug = cfg.graph.getDebug();
        for (Block block : cfg.getBlocks()) {
            this.blockEffects.put(block, new GraphEffectList(this.debug));
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public boolean needsApplyEffects() {
        return true;
    }

    @Override
    public void applyEffects() {
        StructuredGraph graph = this.cfg.graph;
        ArrayList<Node> obsoleteNodes = new ArrayList<Node>(0);
        final ArrayList effectList = new ArrayList();
        ReentrantBlockIterator.BlockIteratorClosure<Void> closure = new ReentrantBlockIterator.BlockIteratorClosure<Void>(){

            @Override
            protected Void getInitialState() {
                return null;
            }

            private void apply(GraphEffectList effects) {
                if (effects != null && !effects.isEmpty()) {
                    effectList.add(effects);
                }
            }

            @Override
            protected Void processBlock(Block block, Void currentState) {
                this.apply(EffectsClosure.this.blockEffects.get(block));
                return currentState;
            }

            @Override
            protected Void merge(Block merge, List<Void> states) {
                return null;
            }

            @Override
            protected Void cloneState(Void oldState) {
                return oldState;
            }

            @Override
            protected List<Void> processLoop(Loop<Block> loop, Void initialState) {
                ReentrantBlockIterator.LoopInfo<Void> info = ReentrantBlockIterator.processLoop(this, loop, initialState);
                this.apply((GraphEffectList)EffectsClosure.this.loopMergeEffects.get(loop));
                return info.exitStates;
            }
        };
        ReentrantBlockIterator.apply(closure, this.cfg.getStartBlock());
        for (GraphEffectList effects : effectList) {
            effects.apply(graph, obsoleteNodes, false);
        }
        for (GraphEffectList effects : effectList) {
            effects.apply(graph, obsoleteNodes, true);
        }
        this.debug.dump(4, graph, "After applying effects");
        assert (VirtualUtil.assertNonReachable(graph, obsoleteNodes));
        for (Node node : obsoleteNodes) {
            if (!node.isAlive() || !node.hasNoUsages()) continue;
            if (node instanceof FixedWithNextNode) assert (((FixedWithNextNode)node).next() == null);
            node.replaceAtUsages(null);
            GraphUtil.killWithUnusedFloatingInputs(node);
        }
    }

    @Override
    protected BlockT processBlock(Block block, BlockT state) {
        if (!((EffectsBlockState)state).isDead()) {
            IfNode ifNode;
            LogicNode condition;
            ValueNode alias;
            GraphEffectList effects = this.blockEffects.get(block);
            if (block.getBeginNode().predecessor() instanceof IfNode && (alias = this.getScalarAlias(condition = (ifNode = (IfNode)block.getBeginNode().predecessor()).condition())) instanceof LogicConstantNode) {
                boolean isTrueSuccessor;
                LogicConstantNode constant = (LogicConstantNode)alias;
                boolean bl = isTrueSuccessor = block.getBeginNode() == ifNode.trueSuccessor();
                if (constant.getValue() != isTrueSuccessor) {
                    ((EffectsBlockState)state).markAsDead();
                    effects.killIfBranch(ifNode, constant.getValue());
                    return state;
                }
            }
            OptionValues options = block.getBeginNode().getOptions();
            VirtualUtil.trace(options, this.debug, "\nBlock: %s, preds: %s, succ: %s (", block, block.getPredecessors(), block.getSuccessors());
            FixedWithNextNode lastFixedNode = null;
            Iterable nodes = this.schedule != null ? (Iterable)this.schedule.getBlockToNodesMap().get(block) : block.getNodes();
            for (Node node : nodes) {
                this.aliases.set(node, null);
                if (node instanceof LoopExitNode) {
                    LoopExitNode loopExit = (LoopExitNode)node;
                    for (ProxyNode proxy : loopExit.proxies()) {
                        this.aliases.set(proxy, null);
                        this.changed |= this.processNode(proxy, state, effects, lastFixedNode) && EffectsClosure.isSignificantNode(node);
                    }
                    this.processLoopExit(loopExit, (EffectsBlockState)this.loopEntryStates.get((Object)loopExit.loopBegin()), state, this.blockEffects.get(block));
                }
                this.changed |= this.processNode(node, state, effects, lastFixedNode) && EffectsClosure.isSignificantNode(node);
                if (node instanceof FixedWithNextNode) {
                    lastFixedNode = (FixedWithNextNode)node;
                }
                if (!((EffectsBlockState)state).isDead()) continue;
                break;
            }
            VirtualUtil.trace(options, this.debug, ")\n    end state: %s\n", state);
        }
        return state;
    }

    private static boolean isSignificantNode(Node node) {
        return !(node instanceof CommitAllocationNode) && !(node instanceof AllocatedObjectNode) && !(node instanceof BoxNode);
    }

    protected abstract boolean processNode(Node var1, BlockT var2, GraphEffectList var3, FixedWithNextNode var4);

    @Override
    protected BlockT merge(Block merge, List<BlockT> states) {
        assert (this.blockEffects.get(merge).isEmpty());
        MergeProcessor processor = this.createMergeProcessor(merge);
        this.doMergeWithoutDead(processor, states);
        this.blockEffects.get(merge).addAll(processor.mergeEffects);
        this.blockEffects.get(merge).addAll(processor.afterMergeEffects);
        return processor.newState;
    }

    @Override
    protected final List<BlockT> processLoop(Loop<Block> loop, BlockT initialState) {
        EffectsBlockState initialStateRemovedKilledLocations;
        if (((EffectsBlockState)initialState).isDead()) {
            ArrayList<BlockT> states = new ArrayList<BlockT>();
            for (int i = 0; i < loop.getLoopExits().size(); ++i) {
                states.add(initialState);
            }
            return states;
        }
        EffectsBlockState loopEntryState = initialStateRemovedKilledLocations = this.stripKilledLoopLocations(loop, (EffectsBlockState)this.cloneState(initialState));
        EffectsBlockState<Object> lastMergedState = this.cloneState(initialStateRemovedKilledLocations);
        this.processInitialLoopState(loop, lastMergedState);
        MergeProcessor mergeProcessor = this.createMergeProcessor(loop.getHeader());
        for (int iteration = 0; iteration < 10; ++iteration) {
            try (Indent i = this.debug.logAndIndent("================== Process Loop Effects Closure: block:%s begin node:%s", (Object)loop.getHeader(), (Object)loop.getHeader().getBeginNode());){
                ReentrantBlockIterator.LoopInfo<EffectsBlockState> info = ReentrantBlockIterator.processLoop(this, loop, this.cloneState(lastMergedState));
                ArrayList<EffectsBlockState<Object>> states = new ArrayList<EffectsBlockState<Object>>();
                states.add(initialStateRemovedKilledLocations);
                states.addAll(info.endStates);
                this.doMergeWithoutDead(mergeProcessor, states);
                this.debug.log("MergeProcessor New State: %s", mergeProcessor.newState);
                this.debug.log("===== vs.");
                this.debug.log("Last Merged State: %s", lastMergedState);
                if (((EffectsBlockState)mergeProcessor.newState).equivalentTo((EffectsBlockState)lastMergedState)) {
                    this.blockEffects.get(loop.getHeader()).insertAll(mergeProcessor.mergeEffects, 0);
                    this.loopMergeEffects.put(loop, (Object)mergeProcessor.afterMergeEffects);
                    assert (info.exitStates.size() == loop.getLoopExits().size());
                    this.loopEntryStates.put((Object)((LoopBeginNode)loop.getHeader().getBeginNode()), (Object)loopEntryState);
                    assert (this.assertExitStatesNonEmpty(loop, info));
                    this.processKilledLoopLocations(loop, initialStateRemovedKilledLocations, mergeProcessor.newState);
                    List list = info.exitStates;
                    return list;
                }
                lastMergedState = mergeProcessor.newState;
                for (Block block : loop.getBlocks()) {
                    GraphEffectList loopEffects;
                    this.blockEffects.get(block).clear();
                    if (!block.isLoopHeader() || (loopEffects = (GraphEffectList)this.loopMergeEffects.get(block.getLoop())) == null) continue;
                    loopEffects.clear();
                }
                continue;
            }
        }
        throw new GraalError("too many iterations at %s", loop);
    }

    protected BlockT stripKilledLoopLocations(Loop<Block> loop, BlockT initialState) {
        return initialState;
    }

    protected void processKilledLoopLocations(Loop<Block> loop, BlockT initialState, BlockT mergedStates) {
    }

    protected void processInitialLoopState(Loop<Block> loop, BlockT initialState) {
    }

    private void doMergeWithoutDead(MergeProcessor mergeProcessor, List<BlockT> states) {
        int alive = 0;
        for (EffectsBlockState state : states) {
            if (state.isDead()) continue;
            ++alive;
        }
        if (alive == 0) {
            mergeProcessor.setNewState((EffectsBlockState)states.get(0));
        } else if (alive == states.size()) {
            int[] stateIndexes = new int[states.size()];
            for (int i = 0; i < stateIndexes.length; ++i) {
                stateIndexes[i] = i;
            }
            mergeProcessor.setStateIndexes(stateIndexes);
            mergeProcessor.setNewState((EffectsBlockState)this.getInitialState());
            mergeProcessor.merge(states);
        } else {
            ArrayList<BlockT> aliveStates = new ArrayList<BlockT>(alive);
            int[] stateIndexes = new int[alive];
            for (int i = 0; i < states.size(); ++i) {
                if (((EffectsBlockState)states.get(i)).isDead()) continue;
                stateIndexes[aliveStates.size()] = i;
                aliveStates.add(states.get(i));
            }
            mergeProcessor.setStateIndexes(stateIndexes);
            mergeProcessor.setNewState((EffectsBlockState)this.getInitialState());
            mergeProcessor.merge(aliveStates);
        }
    }

    private boolean assertExitStatesNonEmpty(Loop<Block> loop, ReentrantBlockIterator.LoopInfo<BlockT> info) {
        for (int i = 0; i < loop.getLoopExits().size(); ++i) {
            assert (info.exitStates.get(i) != null) : "no loop exit state at " + loop.getLoopExits().get(i) + " / " + loop.getHeader();
        }
        return true;
    }

    protected abstract void processLoopExit(LoopExitNode var1, BlockT var2, BlockT var3, GraphEffectList var4);

    protected abstract MergeProcessor createMergeProcessor(Block var1);

    public void addScalarAlias(ValueNode node, ValueNode alias) {
        assert (!(alias instanceof VirtualObjectNode));
        this.aliases.set(node, alias);
        for (Node usage : node.usages()) {
            if (this.hasScalarReplacedInputs.isNew(usage)) continue;
            this.hasScalarReplacedInputs.mark(usage);
        }
    }

    protected final boolean hasScalarReplacedInputs(Node node) {
        return this.hasScalarReplacedInputs.isMarked(node);
    }

    public ValueNode getScalarAlias(ValueNode node) {
        assert (!(node instanceof VirtualObjectNode));
        if (node == null || !node.isAlive() || this.aliases.isNew(node)) {
            return node;
        }
        ValueNode result = this.aliases.get(node);
        return result == null || result instanceof VirtualObjectNode ? node : result;
    }

    protected static final class LoopKillCache {
        private int visits;
        private LocationIdentity firstLocation;
        private EconomicSet<LocationIdentity> killedLocations;
        private boolean killsAll;

        protected LoopKillCache(int visits) {
            this.visits = visits;
        }

        protected void visited() {
            ++this.visits;
        }

        protected int visits() {
            return this.visits;
        }

        protected void setKillsAll() {
            this.killsAll = true;
            this.firstLocation = null;
            this.killedLocations = null;
        }

        protected boolean containsLocation(LocationIdentity locationIdentity) {
            if (this.killsAll) {
                return true;
            }
            if (this.firstLocation == null) {
                return false;
            }
            if (!this.firstLocation.equals(locationIdentity)) {
                return this.killedLocations != null ? this.killedLocations.contains((Object)locationIdentity) : false;
            }
            return true;
        }

        protected void rememberLoopKilledLocation(LocationIdentity locationIdentity) {
            if (this.killsAll) {
                return;
            }
            if (this.firstLocation == null || this.firstLocation.equals(locationIdentity)) {
                this.firstLocation = locationIdentity;
            } else {
                if (this.killedLocations == null) {
                    this.killedLocations = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
                }
                this.killedLocations.add((Object)locationIdentity);
            }
        }

        protected boolean loopKillsLocations() {
            if (this.killsAll) {
                return true;
            }
            return this.firstLocation != null;
        }
    }

    protected abstract class MergeProcessor {
        private final Block mergeBlock;
        protected final AbstractMergeNode merge;
        protected final GraphEffectList mergeEffects;
        protected final GraphEffectList afterMergeEffects;
        private int[] stateIndexes;
        protected BlockT newState;

        public MergeProcessor(Block mergeBlock) {
            this.mergeBlock = mergeBlock;
            this.merge = (AbstractMergeNode)mergeBlock.getBeginNode();
            this.mergeEffects = new GraphEffectList(EffectsClosure.this.debug);
            this.afterMergeEffects = new GraphEffectList(EffectsClosure.this.debug);
        }

        protected abstract void merge(List<BlockT> var1);

        private void setNewState(BlockT state) {
            this.newState = state;
            this.mergeEffects.clear();
            this.afterMergeEffects.clear();
        }

        private void setStateIndexes(int[] stateIndexes) {
            this.stateIndexes = stateIndexes;
        }

        protected final Block getPredecessor(int index) {
            return ((Block[])this.mergeBlock.getPredecessors())[this.stateIndexes[index]];
        }

        protected final NodeIterable<PhiNode> getPhis() {
            return this.merge.phis();
        }

        protected final ValueNode getPhiValueAt(PhiNode phi, int index) {
            return phi.valueAt(this.stateIndexes[index]);
        }

        protected final ValuePhiNode createValuePhi(Stamp stamp) {
            return new ValuePhiNode(stamp, this.merge, new ValueNode[this.mergeBlock.getPredecessorCount()]);
        }

        protected final void setPhiInput(PhiNode phi, int index, ValueNode value) {
            this.afterMergeEffects.initializePhiInput(phi, this.stateIndexes[index], value);
        }

        protected final StructuredGraph graph() {
            return this.merge.graph();
        }

        public String toString() {
            return "MergeProcessor@" + this.merge;
        }
    }
}

