/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.UnpackEndianHalfNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.virtual.phases.ea.GraphEffectList;
import org.graalvm.compiler.virtual.phases.ea.ObjectState;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapeBlockState;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapeClosure;
import org.graalvm.compiler.virtual.phases.ea.VirtualUtil;

class VirtualizerToolImpl
implements VirtualizerTool,
CanonicalizerTool {
    private final MetaAccessProvider metaAccess;
    private final ConstantReflectionProvider constantReflection;
    private final ConstantFieldProvider constantFieldProvider;
    private final PartialEscapeClosure<?> closure;
    private final Assumptions assumptions;
    private final OptionValues options;
    private final DebugContext debug;
    private final LoweringProvider loweringProvider;
    private ConstantNode illegalConstant;
    private boolean deleted;
    private PartialEscapeBlockState<?> state;
    private ValueNode current;
    private FixedNode position;
    private GraphEffectList effects;

    VirtualizerToolImpl(MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, ConstantFieldProvider constantFieldProvider, PartialEscapeClosure<?> closure, Assumptions assumptions, OptionValues options, DebugContext debug, LoweringProvider loweringProvider) {
        this.metaAccess = metaAccess;
        this.constantReflection = constantReflection;
        this.constantFieldProvider = constantFieldProvider;
        this.closure = closure;
        this.assumptions = assumptions;
        this.options = options;
        this.debug = debug;
        this.loweringProvider = loweringProvider;
    }

    @Override
    public OptionValues getOptions() {
        return this.options;
    }

    @Override
    public DebugContext getDebug() {
        return this.debug;
    }

    @Override
    public ConstantFieldProvider getConstantFieldProvider() {
        return this.constantFieldProvider;
    }

    public void reset(PartialEscapeBlockState<?> newState, ValueNode newCurrent, FixedNode newPosition, GraphEffectList newEffects) {
        this.deleted = false;
        this.state = newState;
        this.current = newCurrent;
        this.position = newPosition;
        this.effects = newEffects;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public ValueNode getAlias(ValueNode value) {
        return this.closure.getAliasAndResolve(this.state, value);
    }

    @Override
    public ValueNode getEntry(VirtualObjectNode virtualObject, int index) {
        return this.state.getObjectState(virtualObject).getEntry(index);
    }

    @Override
    public boolean setVirtualEntry(VirtualObjectNode virtual, int index, ValueNode value, JavaKind theAccessKind, long offset) {
        boolean canVirtualize;
        ObjectState obj = this.state.getObjectState(virtual);
        assert (obj.isVirtual()) : "not virtual: " + obj;
        JavaKind entryKind = virtual.entryKind(index);
        JavaKind accessKind = theAccessKind != null ? theAccessKind : entryKind;
        ValueNode newValue = this.closure.getAliasAndResolve(this.state, value);
        this.getDebug().log(4, "Setting entry %d in virtual object %s %s results in %s", (Object)index, (Object)virtual.getObjectId(), (Object)virtual, (Object)this.state.getObjectState(virtual.getObjectId()));
        ValueNode oldValue = this.getEntry(virtual, index);
        boolean bl = canVirtualize = entryKind == accessKind || entryKind == accessKind.getStackKind() && virtual instanceof VirtualInstanceNode;
        if (!canVirtualize) {
            int nextIndex;
            assert (entryKind != JavaKind.Long || newValue != null);
            if (entryKind == JavaKind.Long && oldValue.getStackKind() == newValue.getStackKind() && oldValue.getStackKind().isPrimitive()) {
                this.getDebug().log(4, "virtualizing %s with primitive of kind %s in long entry ", (Object)this.current, (Object)oldValue.getStackKind());
                canVirtualize = true;
            } else if (entryKind == JavaKind.Int && (accessKind == JavaKind.Long || accessKind == JavaKind.Double) && offset % 8L == 0L && (nextIndex = virtual.entryIndexForOffset(this.getMetaAccess(), offset + 4L, JavaKind.Int)) != -1) {
                canVirtualize = true;
                assert (nextIndex == index + 1) : "expected to be sequential";
                this.getDebug().log(4, "virtualizing %s for double word stored in two ints", (Object)this.current);
            }
        }
        if (canVirtualize) {
            this.getDebug().log(4, "virtualizing %s for entryKind %s and access kind %s", (Object)this.current, (Object)entryKind, (Object)accessKind);
            this.state.setEntry(virtual.getObjectId(), index, newValue);
            if (entryKind == JavaKind.Int) {
                if (accessKind.needsTwoSlots()) {
                    assert (virtual.entryKind(index + 1) == JavaKind.Int);
                    this.state.setEntry(virtual.getObjectId(), index + 1, this.getIllegalConstant());
                } else if (oldValue.getStackKind() == JavaKind.Double || oldValue.getStackKind() == JavaKind.Long) {
                    this.getDebug().log(4, "virtualizing %s producing second half of double word value %s", (Object)this.current, (Object)oldValue);
                    ValueNode secondHalf = UnpackEndianHalfNode.create(oldValue, false, NodeView.DEFAULT);
                    this.addNode(secondHalf);
                    this.state.setEntry(virtual.getObjectId(), index + 1, secondHalf);
                }
            }
            if (oldValue.isConstant() && oldValue.asConstant().equals(JavaConstant.forIllegal())) {
                ValueNode previous = this.getEntry(virtual, index - 1);
                this.getDebug().log(4, "virtualizing %s producing first half of double word value %s", (Object)this.current, (Object)previous);
                ValueNode firstHalf = UnpackEndianHalfNode.create(previous, true, NodeView.DEFAULT);
                this.addNode(firstHalf);
                this.state.setEntry(virtual.getObjectId(), index - 1, firstHalf);
            }
            return true;
        }
        assert (entryKind != accessKind);
        return false;
    }

    private ValueNode getIllegalConstant() {
        if (this.illegalConstant == null) {
            this.illegalConstant = ConstantNode.forConstant((JavaConstant)JavaConstant.forIllegal(), this.getMetaAccess());
            this.addNode(this.illegalConstant);
        }
        return this.illegalConstant;
    }

    @Override
    public void setEnsureVirtualized(VirtualObjectNode virtualObject, boolean ensureVirtualized) {
        int id = virtualObject.getObjectId();
        this.state.setEnsureVirtualized(id, ensureVirtualized);
    }

    @Override
    public boolean getEnsureVirtualized(VirtualObjectNode virtualObject) {
        return this.state.getObjectState(virtualObject).getEnsureVirtualized();
    }

    @Override
    public void replaceWithVirtual(VirtualObjectNode virtual) {
        this.closure.addVirtualAlias(virtual, this.current);
        this.effects.deleteNode(this.current);
        this.deleted = true;
    }

    @Override
    public void replaceWithValue(ValueNode replacement) {
        this.effects.replaceAtUsages(this.current, this.closure.getScalarAlias(replacement), this.position);
        this.closure.addScalarAlias(this.current, replacement);
        this.deleted = true;
    }

    @Override
    public void delete() {
        this.effects.deleteNode(this.current);
        this.deleted = true;
    }

    @Override
    public void replaceFirstInput(Node oldInput, Node replacement) {
        this.effects.replaceFirstInput(this.current, oldInput, replacement);
    }

    @Override
    public void addNode(ValueNode node) {
        if (node instanceof FloatingNode) {
            this.effects.addFloatingNode(node, "VirtualizerTool");
        } else {
            this.effects.addFixedNodeBefore((FixedWithNextNode)node, this.position);
        }
    }

    @Override
    public void createVirtualObject(VirtualObjectNode virtualObject, ValueNode[] entryState, List<MonitorIdNode> locks, boolean ensureVirtualized) {
        VirtualUtil.trace(this.options, this.debug, "{{%s}} ", this.current);
        if (!virtualObject.isAlive()) {
            this.effects.addFloatingNode(virtualObject, "newVirtualObject");
        }
        for (int i = 0; i < entryState.length; ++i) {
            ValueNode entry = entryState[i];
            entryState[i] = entry instanceof VirtualObjectNode ? entry : this.closure.getAliasAndResolve(this.state, entry);
        }
        int id = virtualObject.getObjectId();
        if (id == -1) {
            id = this.closure.virtualObjects.size();
            this.closure.virtualObjects.add(virtualObject);
            virtualObject.setObjectId(id);
        }
        this.state.addObject(id, new ObjectState(entryState, locks, ensureVirtualized));
        this.closure.addVirtualAlias(virtualObject, virtualObject);
        PartialEscapeClosure.COUNTER_ALLOCATION_REMOVED.increment(this.debug);
        this.effects.addVirtualizationDelta(1);
    }

    @Override
    public int getMaximumEntryCount() {
        return GraalOptions.MaximumEscapeAnalysisArrayLength.getValue(this.current.getOptions());
    }

    @Override
    public void replaceWith(ValueNode node) {
        if (node instanceof VirtualObjectNode) {
            this.replaceWithVirtual((VirtualObjectNode)node);
        } else {
            this.replaceWithValue(node);
        }
    }

    @Override
    public boolean ensureMaterialized(VirtualObjectNode virtualObject) {
        return this.closure.ensureMaterialized(this.state, virtualObject.getObjectId(), this.position, this.effects, PartialEscapeClosure.COUNTER_MATERIALIZATIONS_UNHANDLED);
    }

    @Override
    public void addLock(VirtualObjectNode virtualObject, MonitorIdNode monitorId) {
        int id = virtualObject.getObjectId();
        this.state.addLock(id, monitorId);
    }

    @Override
    public MonitorIdNode removeLock(VirtualObjectNode virtualObject) {
        int id = virtualObject.getObjectId();
        return this.state.removeLock(id);
    }

    @Override
    public MetaAccessProvider getMetaAccess() {
        return this.metaAccess;
    }

    @Override
    public ConstantReflectionProvider getConstantReflection() {
        return this.constantReflection;
    }

    @Override
    public boolean canonicalizeReads() {
        return false;
    }

    @Override
    public boolean allUsagesAvailable() {
        return true;
    }

    @Override
    public Assumptions getAssumptions() {
        return this.assumptions;
    }

    @Override
    public Integer smallestCompareWidth() {
        if (this.loweringProvider != null) {
            return this.loweringProvider.smallestCompareWidth();
        }
        return null;
    }
}

