/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.word;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class WordTypes {
    private final ResolvedJavaType wordBaseType;
    private final ResolvedJavaType wordImplType;
    private final ResolvedJavaType wordFactoryType;
    private final ResolvedJavaType objectAccessType;
    private final ResolvedJavaType barrieredAccessType;
    private final JavaKind wordKind;

    public WordTypes(MetaAccessProvider metaAccess, JavaKind wordKind) {
        this.wordKind = wordKind;
        this.wordBaseType = metaAccess.lookupJavaType(WordBase.class);
        this.wordImplType = metaAccess.lookupJavaType(Word.class);
        this.wordFactoryType = metaAccess.lookupJavaType(WordFactory.class);
        this.objectAccessType = metaAccess.lookupJavaType(ObjectAccess.class);
        this.barrieredAccessType = metaAccess.lookupJavaType(BarrieredAccess.class);
        if (!Services.IS_BUILDING_NATIVE_IMAGE) {
            Word.ensureInitialized();
        }
        this.wordImplType.initialize();
    }

    public boolean isWordOperation(ResolvedJavaMethod targetMethod) {
        boolean isWordFactory = this.wordFactoryType.equals(targetMethod.getDeclaringClass());
        if (isWordFactory) {
            return !targetMethod.isConstructor();
        }
        boolean isObjectAccess = this.objectAccessType.equals(targetMethod.getDeclaringClass());
        boolean isBarrieredAccess = this.barrieredAccessType.equals(targetMethod.getDeclaringClass());
        if (isObjectAccess || isBarrieredAccess) {
            assert (targetMethod.getAnnotation(Word.Operation.class) != null) : targetMethod + " should be annotated with @" + Word.Operation.class.getSimpleName();
            return true;
        }
        return this.isWord((JavaType)targetMethod.getDeclaringClass());
    }

    public ResolvedJavaMethod getWordOperation(ResolvedJavaMethod targetMethod, ResolvedJavaType callingContextType) {
        boolean isWordBase = this.wordBaseType.isAssignableFrom(targetMethod.getDeclaringClass());
        ResolvedJavaMethod wordMethod = targetMethod;
        if (isWordBase && !targetMethod.isStatic()) {
            assert (this.wordImplType.isLinked());
            wordMethod = this.wordImplType.resolveConcreteMethod(targetMethod, callingContextType);
        }
        assert (wordMethod != null) : targetMethod;
        return wordMethod;
    }

    public boolean isWord(ValueNode node) {
        return this.isWord((JavaType)StampTool.typeOrNull(node));
    }

    public boolean isWord(JavaType type) {
        return type instanceof ResolvedJavaType && this.wordBaseType.isAssignableFrom((ResolvedJavaType)type);
    }

    public JavaKind asKind(JavaType type) {
        if (this.isWord(type)) {
            return this.wordKind;
        }
        return type.getJavaKind();
    }

    public JavaKind getWordKind() {
        return this.wordKind;
    }

    public Stamp getWordStamp(ResolvedJavaType type) {
        assert (this.isWord((JavaType)type));
        return StampFactory.forKind(this.wordKind);
    }

    public ResolvedJavaType getWordImplType() {
        return this.wordImplType;
    }
}

