/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal;

import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.libgraal.LibGraalScope;

public class LibGraal {
    static final long isolate = Services.IS_BUILDING_NATIVE_IMAGE ? 0L : LibGraal.initializeLibgraal();

    public static boolean isAvailable() {
        return LibGraal.inLibGraal() || isolate != 0L;
    }

    public static boolean isSupported() {
        return true;
    }

    public static boolean inLibGraal() {
        return Services.IS_IN_NATIVE_IMAGE;
    }

    public static void registerNativeMethods(HotSpotJVMCIRuntime runtime, Class<?> clazz) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        if (LibGraal.inLibGraal() || !LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        runtime.registerNativeMethods(clazz);
    }

    public static long translate(HotSpotJVMCIRuntime runtime, Object obj) {
        if (!LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        if (!LibGraal.inLibGraal() && LibGraalScope.currentScope.get() == null) {
            throw new IllegalStateException("Not within a " + LibGraalScope.class.getName());
        }
        return runtime.translate(obj);
    }

    public static <T> T unhand(HotSpotJVMCIRuntime runtime, Class<T> type, long handle) {
        if (!LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        if (!LibGraal.inLibGraal() && LibGraalScope.currentScope.get() == null) {
            throw new IllegalStateException("Not within a " + LibGraalScope.class.getName());
        }
        return (T)runtime.unhand(type, handle);
    }

    private static long initializeLibgraal() {
        try {
            HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
            long[] nativeInterface = runtime.registerNativeMethods(LibGraal.class);
            return nativeInterface[1];
        }
        catch (UnsupportedOperationException e) {
            return 0L;
        }
    }

    static boolean isCurrentThreadAttached(HotSpotJVMCIRuntime runtime) {
        return runtime.isCurrentThreadAttached();
    }

    public static boolean attachCurrentThread(HotSpotJVMCIRuntime runtime, boolean isDaemon) {
        return runtime.attachCurrentThread(isDaemon);
    }

    public static void detachCurrentThread(HotSpotJVMCIRuntime runtime) {
        runtime.detachCurrentThread();
    }

    static native long getCurrentIsolateThread(long var0);

    public static long getFailedSpeculationsAddress(HotSpotSpeculationLog log) {
        return log.getFailedSpeculationsAddress();
    }
}

