/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

public final class GuardedAnnotationAccess {
    public static boolean isAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> annotationClass) {
        return GuardedAnnotationAccess.getAnnotation(element, annotationClass) != null;
    }

    public static <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> annotationType) {
        try {
            return element.getAnnotation(annotationType);
        }
        catch (ArrayStoreException | NoClassDefFoundError e) {
            return null;
        }
    }

    public static Annotation[] getAnnotations(AnnotatedElement element) {
        try {
            return element.getAnnotations();
        }
        catch (ArrayStoreException | NoClassDefFoundError e) {
            return new Annotation[0];
        }
    }

    public static <T extends Annotation> T getDeclaredAnnotation(AnnotatedElement element, Class<T> annotationType) {
        try {
            return element.getDeclaredAnnotation(annotationType);
        }
        catch (ArrayStoreException | NoClassDefFoundError e) {
            return null;
        }
    }

    public static Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
        try {
            return element.getDeclaredAnnotations();
        }
        catch (ArrayStoreException | NoClassDefFoundError e) {
            return new Annotation[0];
        }
    }
}

