/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.instruments.trace;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.llvm.instruments.trace.LLVMTraceNodeFactory;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Locale;

public final class LLVMTracerInstrument {
    private PrintStream targetStream = null;
    private String targetOptionString = null;
    private static final String FILE_TARGET_PREFIX = "file://";

    @CompilerDirectives.TruffleBoundary
    public void initialize(TruffleLanguage.Env env, String optionString) {
        env.registerService((Object)this);
        SourceSectionFilter.Builder builder = SourceSectionFilter.newBuilder();
        builder.mimeTypeIs(new String[]{"text/x-llvmir"});
        builder.tagIs(new Class[]{StandardTags.StatementTag.class, StandardTags.RootTag.class});
        SourceSectionFilter filter = builder.build();
        Instrumenter instrumenter = (Instrumenter)env.lookup(Instrumenter.class);
        if (instrumenter == null) {
            throw new IllegalStateException("Could not find Instrumenter");
        }
        this.targetOptionString = optionString;
        this.targetStream = LLVMTracerInstrument.createTargetStream(env, optionString);
        instrumenter.attachExecutionEventFactory(filter, (ExecutionEventNodeFactory)new LLVMTraceNodeFactory(this.targetStream));
    }

    @CompilerDirectives.TruffleBoundary
    public void dispose() {
        this.targetStream.flush();
        String target = this.targetOptionString;
        assert (target != null) : "Invalid modification of tracing target!";
        switch (target.toLowerCase(Locale.ROOT)) {
            case "true": 
            case "out": 
            case "stdout": 
            case "err": 
            case "stderr": {
                break;
            }
            default: {
                this.targetStream.close();
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static PrintStream createTargetStream(TruffleLanguage.Env env, String target) {
        OutputStream targetStream;
        if (target == null) {
            throw new IllegalArgumentException("Target for trace unspecified!");
        }
        switch (target.toLowerCase(Locale.ROOT)) {
            case "true": 
            case "out": 
            case "stdout": {
                targetStream = env.out();
                break;
            }
            case "err": 
            case "stderr": {
                targetStream = env.err();
                break;
            }
            default: {
                if (target.startsWith(FILE_TARGET_PREFIX)) {
                    String fileName = target.substring(FILE_TARGET_PREFIX.length());
                    try {
                        TruffleFile file = env.getPublicTruffleFile(fileName);
                        targetStream = new BufferedOutputStream(file.newOutputStream(new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND}));
                        break;
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Invalid file: " + fileName, e);
                    }
                }
                throw new IllegalArgumentException("Invalid target for tracing: " + target);
            }
        }
        return new PrintStream(targetStream);
    }
}

