/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.llvm.parser.LLVMPhiManager;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.ValueSymbol;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionParameter;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.AllocateInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.BinaryOperationInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.BranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CallInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CastInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CompareExchangeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CompareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ConditionalBranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgDeclareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ExtractElementInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ExtractValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.FenceInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.GetElementPointerInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.IndirectBranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InsertElementInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InsertValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InvokeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.LandingpadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.LoadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.PhiInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ReadModifyWriteInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ResumeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ReturnInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SelectInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ShuffleVectorInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.StoreInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SwitchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SwitchOldInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.UnreachableInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidCallInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInvokeInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graalvm.collections.EconomicMap;

public final class LLVMLivenessAnalysis {
    private final FunctionDefinition functionDefinition;
    private final FrameSlot[] frameSlots;
    private final EconomicMap<Object, Integer> frameSlotIdToIndex;
    private static final FrameSlot[] NO_SLOTS = new FrameSlot[0];

    private LLVMLivenessAnalysis(FunctionDefinition functionDefinition, FrameDescriptor frame) {
        this.functionDefinition = functionDefinition;
        this.frameSlots = frame.getSlots().toArray(NO_SLOTS);
        this.frameSlotIdToIndex = EconomicMap.create();
        for (int i = 0; i < this.frameSlots.length; ++i) {
            this.frameSlotIdToIndex.put(this.frameSlots[i].getIdentifier(), (Object)i);
        }
    }

    private int getFrameSlotIndex(Object identifier) {
        return (Integer)this.frameSlotIdToIndex.get(identifier);
    }

    public static LLVMLivenessAnalysisResult computeLiveness(FrameDescriptor frame, Map<InstructionBlock, List<LLVMPhiManager.Phi>> phis, FunctionDefinition functionDefinition, PrintStream logLivenessStream) {
        LLVMLivenessAnalysis analysis = new LLVMLivenessAnalysis(functionDefinition, frame);
        List<InstructionBlock> blocks = functionDefinition.getBlocks();
        BlockInfo[] blockInfos = analysis.initializeGenKill(phis, blocks);
        ArrayList<InstructionBlock>[] predecessors = LLVMLivenessAnalysis.computePredecessors(blocks);
        int processedBlocks = LLVMLivenessAnalysis.iterateToFixedPoint(blocks, frame, blockInfos, predecessors);
        if (logLivenessStream != null) {
            analysis.printIntermediateResult(logLivenessStream, blocks, blockInfos, processedBlocks);
        }
        LLVMLivenessAnalysisResult result = analysis.computeLivenessAnalysisResult(blocks, blockInfos, predecessors);
        if (logLivenessStream != null) {
            analysis.printResult(logLivenessStream, blocks, result);
        }
        return result;
    }

    private BlockInfo[] initializeGenKill(Map<InstructionBlock, List<LLVMPhiManager.Phi>> phis, List<InstructionBlock> blocks) {
        BlockInfo[] result = new BlockInfo[blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            InstructionBlock block = blocks.get(i);
            BlockInfo blockInfo = result[i] = new BlockInfo(this.frameSlots.length);
            if (i == 0) {
                for (FunctionParameter param : this.functionDefinition.getParameters()) {
                    LLVMLivenessAnalysis.processRead(blockInfo, this.getFrameSlotIndex(param.getName()));
                }
            }
            LLVMLivenessReadVisitor readVisitor = new LLVMLivenessReadVisitor(blockInfo);
            for (int j = 0; j < block.getInstructionCount(); ++j) {
                Instruction instruction = block.getInstruction(j);
                if (instruction instanceof PhiInstruction) {
                    this.processPhiWrite((PhiInstruction)instruction, blockInfo);
                    continue;
                }
                instruction.accept(readVisitor);
                int frameSlotIndex = this.resolve(instruction);
                if (frameSlotIndex < 0) continue;
                blockInfo.defs.set(frameSlotIndex);
                if (blockInfo.gen.get(frameSlotIndex)) continue;
                blockInfo.kill.set(frameSlotIndex);
            }
            List bbPhis = phis.getOrDefault(block, Collections.emptyList());
            for (LLVMPhiManager.Phi phi : bbPhis) {
                this.processValueUsedInPhi(phi.getValue(), blockInfo);
            }
        }
        return result;
    }

    private static int iterateToFixedPoint(List<InstructionBlock> blocks, FrameDescriptor frame, BlockInfo[] blockInfos, ArrayList<InstructionBlock>[] predecessors) {
        ArrayDeque<InstructionBlock> workList = new ArrayDeque<InstructionBlock>(blocks);
        BitSet blockOnWorkList = new BitSet(blocks.size());
        blockOnWorkList.set(0, blockOnWorkList.size());
        BitSet newPredecessorOut = new BitSet(frame.getSize());
        BitSet newIn = new BitSet(frame.getSize());
        int processedBlocks = 0;
        while (!workList.isEmpty()) {
            ++processedBlocks;
            InstructionBlock block = LLVMLivenessAnalysis.removeBlockFromWorkList(workList, blockOnWorkList);
            BlockInfo blockInfo = blockInfos[block.getBlockIndex()];
            newIn.clear();
            newIn.or(blockInfo.out);
            newIn.andNot(blockInfo.defs);
            newIn.or(blockInfo.gen);
            newIn.or(blockInfo.phiDefs);
            blockInfo.in.clear();
            blockInfo.in.or(newIn);
            for (InstructionBlock predecessor : predecessors[block.getBlockIndex()]) {
                BlockInfo predecessorBlockInfo = blockInfos[predecessor.getBlockIndex()];
                newPredecessorOut.clear();
                newPredecessorOut.or(blockInfo.in);
                newPredecessorOut.andNot(blockInfo.phiDefs);
                newPredecessorOut.or(predecessorBlockInfo.phiUses);
                boolean changed = LLVMLivenessAnalysis.or(predecessorBlockInfo.out, newPredecessorOut);
                if (!changed) continue;
                LLVMLivenessAnalysis.addBlockToWorkList(workList, blockOnWorkList, predecessor);
            }
        }
        return processedBlocks;
    }

    private LLVMLivenessAnalysisResult computeLivenessAnalysisResult(List<InstructionBlock> blocks, BlockInfo[] blockInfos, ArrayList<InstructionBlock>[] predecessors) {
        ArrayList[] nullableWithinBlock = new ArrayList[blocks.size()];
        BitSet[] nullableBeforeBlock = new BitSet[blocks.size()];
        BitSet[] nullableAfterBlock = new BitSet[blocks.size()];
        int[] lastInstructionIndexTouchingLocal = new int[this.frameSlots.length];
        LLVMNullerReadVisitor nullerReadVisitor = new LLVMNullerReadVisitor(lastInstructionIndexTouchingLocal);
        for (int i = 0; i < blocks.size(); ++i) {
            ArrayList<NullerInformation> blockNullers = new ArrayList<NullerInformation>();
            Arrays.fill(lastInstructionIndexTouchingLocal, -1);
            BlockInfo blockInfo = blockInfos[i];
            blockInfo.kill.clear();
            blockInfo.phiDefs.clear();
            if (i == 0) {
                for (FunctionParameter param : this.functionDefinition.getParameters()) {
                    int frameSlotIndex = this.getFrameSlotIndex(param.getName());
                    lastInstructionIndexTouchingLocal[frameSlotIndex] = 0;
                }
            }
            InstructionBlock block = blocks.get(i);
            for (int j = 0; j < block.getInstructionCount(); ++j) {
                Instruction instruction = block.getInstruction(j);
                if (!(instruction instanceof PhiInstruction)) {
                    nullerReadVisitor.setInstructionIndex(j);
                    instruction.accept(nullerReadVisitor);
                }
                int frameSlotIndex = this.resolve(instruction);
                if (frameSlotIndex < 0) continue;
                if (lastInstructionIndexTouchingLocal[frameSlotIndex] != -1 && lastInstructionIndexTouchingLocal[frameSlotIndex] != j) {
                    blockNullers.add(new NullerInformation(this.frameSlots[frameSlotIndex], lastInstructionIndexTouchingLocal[frameSlotIndex]));
                }
                lastInstructionIndexTouchingLocal[frameSlotIndex] = j;
            }
            blockInfo.defs.or(blockInfo.in);
            blockInfo.defs.andNot(blockInfo.out);
            int terminatingInstructionIndex = block.getInstructionCount() - 1;
            BitSet valuesThatDieInBlock = blockInfo.defs;
            int bitIndex = -1;
            while ((bitIndex = valuesThatDieInBlock.nextSetBit(bitIndex + 1)) >= 0) {
                assert (lastInstructionIndexTouchingLocal[bitIndex] >= 0) : "must have a last usage, otherwise the value would not be alive in this block";
                if (blockInfo.phiUses.get(bitIndex) || lastInstructionIndexTouchingLocal[bitIndex] == terminatingInstructionIndex) {
                    blockInfo.phiDefs.set(bitIndex);
                    continue;
                }
                blockNullers.add(new NullerInformation(this.frameSlots[bitIndex], lastInstructionIndexTouchingLocal[bitIndex]));
            }
            for (InstructionBlock predecessor : predecessors[i]) {
                BlockInfo predInfo = blockInfos[predecessor.getBlockIndex()];
                blockInfo.kill.or(predInfo.out);
            }
            blockInfo.kill.andNot(blockInfo.in);
            Collections.sort(blockNullers);
            nullableWithinBlock[i] = blockNullers;
            nullableBeforeBlock[i] = blockInfo.kill;
            nullableAfterBlock[i] = blockInfo.phiDefs;
        }
        return new LLVMLivenessAnalysisResult(this.frameSlots, nullableWithinBlock, nullableBeforeBlock, nullableAfterBlock);
    }

    private static ArrayList<InstructionBlock>[] computePredecessors(List<InstructionBlock> blocks) {
        ArrayList[] result = new ArrayList[blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            result[i] = new ArrayList(2);
        }
        for (InstructionBlock block : blocks) {
            TerminatingInstruction terminatingInstruction = block.getTerminatingInstruction();
            for (int i = 0; i < terminatingInstruction.getSuccessorCount(); ++i) {
                result[terminatingInstruction.getSuccessor(i).getBlockIndex()].add(block);
            }
        }
        return result;
    }

    private static void addBlockToWorkList(ArrayDeque<InstructionBlock> workList, BitSet blockOnWorkList, InstructionBlock predecessorBlock) {
        boolean predecessorBlockIndex = blockOnWorkList.get(predecessorBlock.getBlockIndex());
        if (!predecessorBlockIndex) {
            workList.addLast(predecessorBlock);
            blockOnWorkList.set(predecessorBlock.getBlockIndex());
        }
    }

    private static InstructionBlock removeBlockFromWorkList(ArrayDeque<InstructionBlock> workList, BitSet blockOnWorkList) {
        InstructionBlock block = workList.removeLast();
        blockOnWorkList.clear(block.getBlockIndex());
        return block;
    }

    private static boolean or(BitSet dest, BitSet source) {
        assert (dest.size() == source.size());
        if (LLVMLivenessAnalysis.isChangeForOrNecessary(dest, source)) {
            dest.or(source);
            return true;
        }
        return false;
    }

    private static boolean isChangeForOrNecessary(BitSet dest, BitSet source) {
        int bitIndex = -1;
        while ((bitIndex = source.nextSetBit(bitIndex + 1)) >= 0) {
            if (dest.get(bitIndex)) continue;
            return true;
        }
        return false;
    }

    private void processRead(SymbolImpl symbol, BlockInfo blockInfo) {
        int frameSlotIndex = this.resolve(symbol);
        LLVMLivenessAnalysis.processRead(blockInfo, frameSlotIndex);
    }

    private static void processRead(BlockInfo blockInfo, int frameSlotIndex) {
        if (frameSlotIndex >= 0 && !blockInfo.kill.get(frameSlotIndex)) {
            blockInfo.gen.set(frameSlotIndex);
        }
    }

    private void processValueUsedInPhi(SymbolImpl symbol, BlockInfo blockInfo) {
        int frameSlotIndex = this.resolve(symbol);
        if (frameSlotIndex >= 0) {
            blockInfo.phiUses.set(frameSlotIndex);
        }
    }

    private void processPhiWrite(PhiInstruction phi, BlockInfo blockInfo) {
        int frameSlotIndex = this.resolve(phi);
        if (frameSlotIndex >= 0) {
            blockInfo.phiDefs.set(frameSlotIndex);
            blockInfo.defs.set(frameSlotIndex);
        }
    }

    private int resolve(SymbolImpl symbol) {
        if (symbol instanceof FunctionParameter || symbol instanceof ValueInstruction) {
            String name = ((ValueSymbol)symbol).getName();
            assert (name != null);
            return this.getFrameSlotIndex(name);
        }
        return -1;
    }

    private void printIntermediateResult(PrintStream logLivenessStream, List<InstructionBlock> blocks, BlockInfo[] blockInfos, int processedBlocks) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.functionDefinition.getName());
        builder.append(" (processed ");
        builder.append(processedBlocks);
        builder.append(" blocks - CFG has ");
        builder.append(blocks.size());
        builder.append(" blocks)\n");
        for (int i = 0; i < blockInfos.length; ++i) {
            BlockInfo blockInfo = blockInfos[i];
            builder.append("Basic block ");
            builder.append(i);
            builder.append(" (");
            builder.append(blocks.get(i).getName());
            builder.append(")\n");
            builder.append("  In:      ");
            builder.append(this.formatLocals(blockInfo.in));
            builder.append("\n");
            builder.append("  Gen:     ");
            builder.append(this.formatLocals(blockInfo.gen));
            builder.append("\n");
            builder.append("  Kill:    ");
            builder.append(this.formatLocals(blockInfo.kill));
            builder.append("\n");
            builder.append("  Def:     ");
            builder.append(this.formatLocals(blockInfo.defs));
            builder.append("\n");
            builder.append("  PhiDefs: ");
            builder.append(this.formatLocals(blockInfo.phiDefs));
            builder.append("\n");
            builder.append("  PhiUses: ");
            builder.append(this.formatLocals(blockInfo.phiUses));
            builder.append("\n");
            builder.append("  Out:     ");
            builder.append(this.formatLocals(blockInfo.out));
            builder.append("\n");
        }
        logLivenessStream.println(builder.toString());
    }

    private void printResult(PrintStream logLivenessStream, List<InstructionBlock> blocks, LLVMLivenessAnalysisResult result) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < blocks.size(); ++i) {
            builder.append("Basic block ");
            builder.append(i);
            builder.append(" (");
            builder.append(blocks.get(i).getName());
            builder.append(")\n");
            builder.append("  NullableBefore: ");
            builder.append(this.formatLocals(result.nullableBeforeBlock[i]));
            builder.append("\n");
            builder.append("  NullableWithin:  ");
            builder.append(LLVMLivenessAnalysis.formatLocalNullers(result.nullableWithinBlock[i]));
            builder.append("\n");
            builder.append("  NullableAfter:  ");
            builder.append(this.formatLocals(result.nullableAfterBlock[i]));
            builder.append("\n");
        }
        logLivenessStream.println(builder.toString());
    }

    private String formatLocals(BitSet bitSet) {
        StringBuilder result = new StringBuilder();
        int bitIndex = -1;
        while ((bitIndex = bitSet.nextSetBit(bitIndex + 1)) >= 0) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(this.frameSlots[bitIndex].getIdentifier());
        }
        return result.toString();
    }

    private static Object formatLocalNullers(ArrayList<NullerInformation> nullers) {
        StringBuilder result = new StringBuilder();
        for (NullerInformation nuller : nullers) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(nuller.frameSlot.getIdentifier());
        }
        return result.toString();
    }

    public static class LLVMLivenessAnalysisResult {
        private final FrameSlot[] frameSlots;
        private final ArrayList<NullerInformation>[] nullableWithinBlock;
        private final BitSet[] nullableBeforeBlock;
        private final BitSet[] nullableAfterBlock;

        public LLVMLivenessAnalysisResult(FrameSlot[] frameSlots, ArrayList<NullerInformation>[] nullableWithinBlock, BitSet[] nullableBeforeBlock, BitSet[] nullableAfterBlock) {
            this.frameSlots = frameSlots;
            this.nullableWithinBlock = nullableWithinBlock;
            this.nullableBeforeBlock = nullableBeforeBlock;
            this.nullableAfterBlock = nullableAfterBlock;
        }

        public FrameSlot[] getFrameSlots() {
            return this.frameSlots;
        }

        public ArrayList<NullerInformation>[] getNullableWithinBlock() {
            return this.nullableWithinBlock;
        }

        public BitSet[] getNullableBeforeBlock() {
            return this.nullableBeforeBlock;
        }

        public BitSet[] getNullableAfterBlock() {
            return this.nullableAfterBlock;
        }
    }

    private static class BlockInfo {
        public final BitSet in;
        public final BitSet out;
        public final BitSet gen;
        public final BitSet kill;
        public final BitSet defs;
        public final BitSet phiDefs;
        public final BitSet phiUses;

        BlockInfo(int frameSlots) {
            this.in = new BitSet(frameSlots);
            this.out = new BitSet(frameSlots);
            this.gen = new BitSet(frameSlots);
            this.kill = new BitSet(frameSlots);
            this.defs = new BitSet(frameSlots);
            this.phiDefs = new BitSet(frameSlots);
            this.phiUses = new BitSet(frameSlots);
        }
    }

    private static abstract class LLVMLocalReadVisitor
    implements SymbolVisitor {
        private LLVMLocalReadVisitor() {
        }

        @Override
        public void visit(AllocateInstruction allocate) {
            this.visitLocalRead(allocate.getCount());
        }

        @Override
        public void visit(BinaryOperationInstruction operation) {
            this.visitLocalRead(operation.getLHS());
            this.visitLocalRead(operation.getRHS());
        }

        @Override
        public void visit(BranchInstruction branch) {
        }

        @Override
        public void visit(InvokeInstruction call) {
            for (SymbolImpl arg : call.getArguments()) {
                this.visitLocalRead(arg);
            }
            this.visitLocalRead(call.getCallTarget());
        }

        @Override
        public void visit(CallInstruction call) {
            for (SymbolImpl arg : call.getArguments()) {
                this.visitLocalRead(arg);
            }
            this.visitLocalRead(call.getCallTarget());
        }

        @Override
        public void visit(CastInstruction cast) {
            this.visitLocalRead(cast.getValue());
        }

        @Override
        public void visit(LandingpadInstruction landingpadInstruction) {
            if (landingpadInstruction.getValue() != null) {
                this.visitLocalRead(landingpadInstruction.getValue());
            }
        }

        @Override
        public void visit(CompareInstruction operation) {
            this.visitLocalRead(operation.getLHS());
            this.visitLocalRead(operation.getRHS());
        }

        @Override
        public void visit(ConditionalBranchInstruction branch) {
            this.visitLocalRead(branch.getCondition());
        }

        @Override
        public void visit(ExtractElementInstruction extract) {
            this.visitLocalRead(extract.getIndex());
            this.visitLocalRead(extract.getVector());
        }

        @Override
        public void visit(ExtractValueInstruction extract) {
            this.visitLocalRead(extract.getAggregate());
        }

        @Override
        public void visit(GetElementPointerInstruction gep) {
            this.visitLocalRead(gep.getBasePointer());
            for (SymbolImpl symbol : gep.getIndices()) {
                this.visitLocalRead(symbol);
            }
        }

        @Override
        public void visit(IndirectBranchInstruction branch) {
            this.visitLocalRead(branch.getAddress());
        }

        @Override
        public void visit(InsertElementInstruction insert) {
            this.visitLocalRead(insert.getVector());
            this.visitLocalRead(insert.getIndex());
            this.visitLocalRead(insert.getValue());
        }

        @Override
        public void visit(InsertValueInstruction insert) {
            this.visitLocalRead(insert.getAggregate());
            this.visitLocalRead(insert.getValue());
        }

        @Override
        public void visit(LoadInstruction load) {
            this.visitLocalRead(load.getSource());
        }

        @Override
        public void visit(PhiInstruction phi) {
            assert (false) : "skipped as phis must be handled in a special way";
        }

        @Override
        public void visit(ReturnInstruction ret) {
            if (ret.getValue() != null) {
                this.visitLocalRead(ret.getValue());
            }
        }

        @Override
        public void visit(ResumeInstruction resume) {
            if (resume.getValue() != null) {
                this.visitLocalRead(resume.getValue());
            }
        }

        @Override
        public void visit(CompareExchangeInstruction cmpxchg) {
            this.visitLocalRead(cmpxchg.getPtr());
            this.visitLocalRead(cmpxchg.getCmp());
            this.visitLocalRead(cmpxchg.getReplace());
        }

        @Override
        public void visit(SelectInstruction select) {
            this.visitLocalRead(select.getCondition());
            this.visitLocalRead(select.getTrueValue());
            this.visitLocalRead(select.getFalseValue());
        }

        @Override
        public void visit(ShuffleVectorInstruction shuffle) {
            this.visitLocalRead(shuffle.getMask());
            this.visitLocalRead(shuffle.getVector1());
            this.visitLocalRead(shuffle.getVector2());
        }

        @Override
        public void visit(StoreInstruction store) {
            this.visitLocalRead(store.getDestination());
            this.visitLocalRead(store.getSource());
        }

        @Override
        public void visit(SwitchInstruction select) {
            this.visitLocalRead(select.getCondition());
        }

        @Override
        public void visit(SwitchOldInstruction select) {
            this.visitLocalRead(select.getCondition());
        }

        @Override
        public void visit(UnreachableInstruction unreachable) {
        }

        @Override
        public void visit(VoidCallInstruction call) {
            for (SymbolImpl arg : call.getArguments()) {
                this.visitLocalRead(arg);
            }
            this.visitLocalRead(call.getCallTarget());
        }

        @Override
        public void visit(VoidInvokeInstruction call) {
            for (SymbolImpl arg : call.getArguments()) {
                this.visitLocalRead(arg);
            }
            this.visitLocalRead(call.getCallTarget());
        }

        @Override
        public void visit(ReadModifyWriteInstruction rmw) {
            this.visitLocalRead(rmw.getPtr());
            this.visitLocalRead(rmw.getValue());
        }

        @Override
        public void visit(FenceInstruction fence) {
        }

        @Override
        public void visit(DbgDeclareInstruction inst) {
            this.visitLocalRead(inst.getValue());
        }

        @Override
        public void visit(DbgValueInstruction inst) {
            this.visitLocalRead(inst.getValue());
        }

        protected abstract void visitLocalRead(SymbolImpl var1);
    }

    private final class LLVMNullerReadVisitor
    extends LLVMLocalReadVisitor {
        private final int[] lastInstructionIndexTouchingLocal;
        private int instructionIndex;

        LLVMNullerReadVisitor(int[] lastInstructionIndexTouchingLocal) {
            this.lastInstructionIndexTouchingLocal = lastInstructionIndexTouchingLocal;
        }

        public void setInstructionIndex(int instructionIndex) {
            this.instructionIndex = instructionIndex;
        }

        @Override
        public void visitLocalRead(SymbolImpl symbol) {
            int frameSlotIndex = LLVMLivenessAnalysis.this.resolve(symbol);
            if (frameSlotIndex >= 0) {
                this.lastInstructionIndexTouchingLocal[frameSlotIndex] = this.instructionIndex;
            }
        }
    }

    private final class LLVMLivenessReadVisitor
    extends LLVMLocalReadVisitor {
        private final BlockInfo blockInfo;

        LLVMLivenessReadVisitor(BlockInfo blockInfo) {
            this.blockInfo = blockInfo;
        }

        @Override
        public void visitLocalRead(SymbolImpl symbol) {
            LLVMLivenessAnalysis.this.processRead(symbol, this.blockInfo);
        }
    }

    public static class NullerInformation
    implements Comparable<NullerInformation> {
        private final FrameSlot frameSlot;
        private final int instructionIndex;

        public NullerInformation(FrameSlot frameSlot, int instructionIndex) {
            this.frameSlot = frameSlot;
            this.instructionIndex = instructionIndex;
        }

        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        public int getInstructionIndex() {
            return this.instructionIndex;
        }

        @Override
        public int compareTo(NullerInformation o) {
            return o.instructionIndex - this.instructionIndex;
        }
    }
}

