/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.LazyToTruffleConverterImpl;
import com.oracle.truffle.llvm.parser.StackManager;
import com.oracle.truffle.llvm.parser.model.ModelModule;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDeclaration;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.constants.CastConstant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalAlias;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.LLVMSourceContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceSymbol;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObjectBuilder;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import java.util.ArrayList;
import java.util.List;

public final class LLVMParser {
    private final Source source;
    private final LLVMParserRuntime runtime;
    private final LLVMContext context;
    private final LLVMContext.ExternalLibrary library;

    public LLVMParser(Source source, LLVMParserRuntime runtime) {
        this.source = source;
        this.runtime = runtime;
        this.context = runtime.getContext();
        this.library = runtime.getLibrary();
    }

    public LLVMParserResult parse(ModelModule module, DataLayout targetDataLayout) {
        ArrayList<GlobalVariable> externalGlobals = new ArrayList<GlobalVariable>();
        ArrayList<GlobalVariable> definedGlobals = new ArrayList<GlobalVariable>();
        ArrayList<FunctionSymbol> externalFunctions = new ArrayList<FunctionSymbol>();
        ArrayList<String> importedSymbols = new ArrayList<String>();
        this.defineGlobals(module.getGlobalVariables(), definedGlobals, externalGlobals, importedSymbols);
        this.defineFunctions(module, externalFunctions, importedSymbols, targetDataLayout);
        this.defineAliases(module.getAliases(), importedSymbols);
        LLVMSymbolReadResolver symbolResolver = new LLVMSymbolReadResolver(this.runtime, StackManager.createRootFrame(), GetStackSpaceFactory.createAllocaFactory(), targetDataLayout);
        this.createDebugInfo(module, symbolResolver);
        return new LLVMParserResult(this.runtime, externalFunctions, definedGlobals, externalGlobals, importedSymbols, targetDataLayout);
    }

    private void defineGlobals(List<GlobalVariable> globals, List<GlobalVariable> definedGlobals, List<GlobalVariable> externalGlobals, List<String> importedSymbols) {
        for (GlobalVariable global : globals) {
            if (global.isExternal()) {
                externalGlobals.add(global);
                importedSymbols.add(global.getName());
                continue;
            }
            this.defineGlobal(global, importedSymbols);
            definedGlobals.add(global);
        }
    }

    private void defineFunctions(ModelModule model, List<FunctionSymbol> externalFunctions, List<String> importedSymbols, DataLayout dataLayout) {
        for (FunctionDefinition functionDefinition : model.getDefinedFunctions()) {
            if (functionDefinition.isExternal()) {
                externalFunctions.add(functionDefinition);
                importedSymbols.add(functionDefinition.getName());
                continue;
            }
            this.defineFunction(functionDefinition, model, importedSymbols, dataLayout);
        }
        for (FunctionDeclaration functionDeclaration : model.getDeclaredFunctions()) {
            assert (functionDeclaration.isExternal());
            externalFunctions.add(functionDeclaration);
            importedSymbols.add(functionDeclaration.getName());
        }
    }

    private void defineAliases(List<GlobalAlias> aliases, List<String> importedSymbols) {
        for (GlobalAlias alias : aliases) {
            this.defineAlias(alias, importedSymbols);
        }
    }

    private void defineGlobal(GlobalVariable global, List<String> importedSymbols) {
        assert (!global.isExternal());
        LLVMGlobal descriptor = LLVMGlobal.create(this.context, global.getName(), global.getType(), global.getSourceSymbol(), global.isReadOnly());
        descriptor.define(global.getType(), this.library);
        this.runtime.getFileScope().register(descriptor);
        if (global.isExported()) {
            LLVMSymbol exportedDescriptor = this.runtime.getGlobalScope().get(global.getName());
            if (exportedDescriptor == null) {
                this.runtime.getGlobalScope().register(descriptor);
            } else if (exportedDescriptor.isGlobalVariable()) {
                importedSymbols.add(global.getName());
            } else {
                assert (exportedDescriptor.isFunction());
                throw new LLVMLinkerException("The global variable " + global.getName() + " conflicts with a function that has the same name.");
            }
        }
    }

    private void defineFunction(FunctionSymbol functionSymbol, ModelModule model, List<String> importedSymbols, DataLayout dataLayout) {
        assert (!functionSymbol.isExternal());
        FunctionDefinition functionDefinition = (FunctionDefinition)functionSymbol;
        LazyToTruffleConverterImpl lazyConverter = new LazyToTruffleConverterImpl(this.runtime, functionDefinition, this.source, model.getFunctionParser(functionDefinition), model.getFunctionProcessor(), dataLayout);
        LLVMFunctionDescriptor.LazyLLVMIRFunction function = new LLVMFunctionDescriptor.LazyLLVMIRFunction(lazyConverter);
        LLVMFunctionDescriptor descriptor = this.context.createFunctionDescriptor(functionSymbol.getName(), functionSymbol.getType(), function, this.library);
        this.runtime.getFileScope().register(descriptor);
        if (functionSymbol.isExported()) {
            LLVMSymbol exportedDescriptor = this.runtime.getGlobalScope().get(functionSymbol.getName());
            if (exportedDescriptor == null) {
                this.runtime.getGlobalScope().register(descriptor);
            } else if (exportedDescriptor.isFunction()) {
                importedSymbols.add(functionSymbol.getName());
            } else {
                assert (exportedDescriptor.isGlobalVariable());
                throw new LLVMLinkerException("The function " + functionSymbol.getName() + " conflicts with a global variable that has the same name.");
            }
        }
    }

    private void defineAlias(GlobalAlias alias, List<String> importedSymbols) {
        LLVMSymbol alreadyRegisteredSymbol = this.runtime.getFileScope().get(alias.getName());
        if (alreadyRegisteredSymbol != null) {
            assert (alreadyRegisteredSymbol instanceof LLVMAlias);
            return;
        }
        this.defineAlias(alias.getName(), alias.isExported(), alias.getValue(), importedSymbols);
    }

    private void defineAlias(String aliasName, boolean isAliasExported, SymbolImpl value, List<String> importedSymbols) {
        if (value instanceof FunctionSymbol) {
            FunctionSymbol function = (FunctionSymbol)value;
            this.defineAlias(function.getName(), function.isExported(), aliasName, isAliasExported, importedSymbols);
        } else if (value instanceof GlobalVariable) {
            GlobalVariable global = (GlobalVariable)value;
            this.defineAlias(global.getName(), global.isExported(), aliasName, isAliasExported, importedSymbols);
        } else if (value instanceof GlobalAlias) {
            GlobalAlias target = (GlobalAlias)value;
            this.defineAlias(target, importedSymbols);
            this.defineAlias(target.getName(), target.isExported(), aliasName, isAliasExported, importedSymbols);
        } else if (value instanceof CastConstant) {
            CastConstant cast = (CastConstant)value;
            this.defineAlias(aliasName, isAliasExported, cast.getValue(), importedSymbols);
        } else {
            throw new LLVMLinkerException("Unknown alias type: " + value.getClass());
        }
    }

    private void defineAlias(String existingName, boolean existingExported, String newName, boolean newExported, List<String> importedSymbols) {
        LLVMSymbol aliasTarget = this.runtime.lookupSymbol(existingName, existingExported);
        LLVMAlias descriptor = new LLVMAlias(this.library, newName, aliasTarget);
        this.runtime.getFileScope().register(descriptor);
        if (existingExported && aliasTarget.getLibrary() != this.library) {
            importedSymbols.add(aliasTarget.getName());
        }
        if (newExported) {
            LLVMSymbol exportedDescriptor = this.runtime.getGlobalScope().get(newName);
            if (exportedDescriptor == null) {
                this.runtime.getGlobalScope().register(descriptor);
            } else if (descriptor.isFunction() && exportedDescriptor.isFunction() || descriptor.isGlobalVariable() && exportedDescriptor.isGlobalVariable()) {
                importedSymbols.add(newName);
            } else {
                throw new LLVMLinkerException("The alias " + newName + " conflicts with another symbol that has a different type but the same name.");
            }
        }
    }

    private void createDebugInfo(ModelModule model, LLVMSymbolReadResolver symbolResolver) {
        if (((Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.ENABLE_LVI)).booleanValue()) {
            LLVMSourceContext sourceContext = this.context.getSourceContext();
            model.getSourceGlobals().forEach((symbol, irValue) -> {
                LLVMExpressionNode node = symbolResolver.resolve((SymbolImpl)irValue);
                LLVMDebugObjectBuilder value = CommonNodeFactory.createDebugStaticValue(node, irValue instanceof GlobalVariable);
                sourceContext.registerStatic((LLVMSourceSymbol)symbol, value);
            });
            model.getSourceStaticMembers().forEach((type, symbol) -> {
                LLVMExpressionNode node = symbolResolver.resolve((SymbolImpl)symbol);
                LLVMDebugObjectBuilder value = CommonNodeFactory.createDebugStaticValue(node, symbol instanceof GlobalVariable);
                type.setValue(value);
            });
        }
    }
}

