/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.elf;

import com.oracle.truffle.llvm.parser.elf.ElfReader;
import com.oracle.truffle.llvm.parser.elf.ElfSectionHeaderTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.polyglot.io.ByteSequence;

public final class ElfDynamicSection {
    private static final int DT_NEEDED = 1;
    private static final int DT_STRTAB = 5;
    private static final int DT_STRSZ = 10;
    private static final int DT_RPATH = 15;
    private static final int DT_RUNPATH = 29;
    private final Entry[] entries;
    private final ByteSequence buffer;

    private ElfDynamicSection(ElfSectionHeaderTable sht, Entry[] entries, ElfReader buffer) {
        this.entries = entries;
        long strTabAddress = Arrays.stream(entries).filter(e -> e.getTag() == 5).map(e -> ElfDynamicSection.addressToOffset(sht, e.getValue())).findAny().orElse(0L);
        long strTabSize = Arrays.stream(entries).filter(e -> e.getTag() == 10).map(e -> e.getValue()).findAny().orElse(0L);
        this.buffer = buffer.getStringTable(strTabAddress, strTabSize);
    }

    public static ElfDynamicSection create(ElfSectionHeaderTable sht, ElfReader buffer) {
        ElfSectionHeaderTable.Entry dynamiSHEntry = ElfDynamicSection.getDynamiSHEntry(sht);
        if (dynamiSHEntry != null) {
            long offset = dynamiSHEntry.getOffset();
            long size = dynamiSHEntry.getSize();
            return new ElfDynamicSection(sht, ElfDynamicSection.readEntries(buffer, offset, size), buffer);
        }
        return null;
    }

    private static long addressToOffset(ElfSectionHeaderTable sht, long offset) {
        for (ElfSectionHeaderTable.Entry e : sht.getEntries()) {
            long lower = e.getShAddr();
            long upper = e.getShSize() + e.getShAddr();
            if (offset < lower || offset >= upper) continue;
            return offset - lower + e.getOffset();
        }
        return offset;
    }

    private static Entry[] readEntries(ElfReader buffer, long offset, long size) {
        if (size == 0L) {
            return new Entry[0];
        }
        buffer.setPosition((int)offset);
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (long cntr = 0L; cntr < size; cntr += buffer.is64Bit() ? 16L : 8L) {
            long tag = buffer.is64Bit() ? buffer.getLong() : (long)buffer.getInt();
            long unionValue = buffer.is64Bit() ? buffer.getLong() : (long)buffer.getInt();
            entries.add(new Entry(tag, unionValue));
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public List<String> getDTNeeded() {
        return this.getEntry(1);
    }

    private static Stream<String> splitPaths(String path) {
        return Arrays.asList(path.split(":")).stream();
    }

    public Stream<String> getDTRunPathStream() {
        return this.getEntryStream(29).flatMap(ElfDynamicSection::splitPaths);
    }

    public List<String> getDTRPath() {
        return this.getEntryStream(15).flatMap(ElfDynamicSection::splitPaths).collect(Collectors.toList());
    }

    private static ElfSectionHeaderTable.Entry getDynamiSHEntry(ElfSectionHeaderTable sht) {
        for (ElfSectionHeaderTable.Entry e : sht.getEntries()) {
            if (!".dynamic".equals(e.getName(sht))) continue;
            return e;
        }
        return null;
    }

    private List<String> getEntry(int tag) {
        return this.getEntryStream(tag).collect(Collectors.toList());
    }

    private Stream<String> getEntryStream(int tag) {
        return Arrays.stream(this.entries).filter(e -> e.getTag() == tag).map(e -> this.getString(e.getValue()));
    }

    private String getString(long offset) {
        if (this.buffer.length() == 0) {
            return "";
        }
        int pos = (int)offset;
        StringBuilder sb = new StringBuilder();
        byte b = this.buffer.byteAt(pos++);
        while (b != 0) {
            sb.append((char)b);
            b = this.buffer.byteAt(pos++);
        }
        return sb.toString();
    }

    private static final class Entry {
        private final long tag;
        private final long unionValue;

        private Entry(long tag, long value) {
            this.tag = tag;
            this.unionValue = value;
        }

        public int getTag() {
            return (int)this.tag;
        }

        public long getValue() {
            return this.unionValue;
        }
    }
}

