/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.filereader;

import org.graalvm.polyglot.io.ByteSequence;

public class ObjectFileReader {
    protected final ByteSequence byteSequence;
    private final boolean littleEndian;
    private int position;

    public ObjectFileReader(ByteSequence buffer, boolean littleEndian) {
        this.byteSequence = buffer;
        this.position = 0;
        this.littleEndian = littleEndian;
    }

    public final byte getByte() {
        return this.byteSequence.byteAt(this.position++);
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int newPosition) {
        this.position = newPosition;
    }

    public void skip(int bytes) {
        this.position += bytes;
    }

    public final short getShort() {
        int ret = this.getByte() & 0xFF;
        ret = ret << 8 | this.getByte() & 0xFF;
        if (this.littleEndian) {
            return Short.reverseBytes((short)ret);
        }
        return (short)ret;
    }

    public final int getInt() {
        int ret = this.getByte() & 0xFF;
        ret = ret << 8 | this.getByte() & 0xFF;
        ret = ret << 8 | this.getByte() & 0xFF;
        ret = ret << 8 | this.getByte() & 0xFF;
        if (this.littleEndian) {
            return Integer.reverseBytes(ret);
        }
        return ret;
    }

    public final long getLong() {
        long ret = this.getByte() & 0xFF;
        ret = ret << 8 | (long)(this.getByte() & 0xFF);
        ret = ret << 8 | (long)(this.getByte() & 0xFF);
        ret = ret << 8 | (long)(this.getByte() & 0xFF);
        ret = ret << 8 | (long)(this.getByte() & 0xFF);
        ret = ret << 8 | (long)(this.getByte() & 0xFF);
        ret = ret << 8 | (long)(this.getByte() & 0xFF);
        ret = ret << 8 | (long)(this.getByte() & 0xFF);
        if (this.littleEndian) {
            return Long.reverseBytes(ret);
        }
        return ret;
    }

    public final byte getByte(int pos) {
        return this.byteSequence.byteAt(pos);
    }

    public final int getInt(int pos) {
        int ret = this.getByte(pos) & 0xFF;
        ret = ret << 8 | this.getByte(pos + 1) & 0xFF;
        ret = ret << 8 | this.getByte(pos + 2) & 0xFF;
        ret = ret << 8 | this.getByte(pos + 3) & 0xFF;
        if (this.littleEndian) {
            return Integer.reverseBytes(ret);
        }
        return ret;
    }

    public final ByteSequence slice() {
        return this.byteSequence.subSequence(this.position, this.byteSequence.length());
    }

    public final void get(byte[] compressedData) {
        int length = compressedData.length;
        for (int writeIdx = 0; writeIdx < length; ++writeIdx) {
            compressedData[writeIdx] = this.getByte();
        }
    }
}

