/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.listeners;

import com.oracle.truffle.llvm.parser.listeners.ParserListener;
import com.oracle.truffle.llvm.parser.listeners.Types;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.model.symbols.constants.BinaryOperationConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.BlockAddressConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.CastConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.CompareConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.GetElementPointerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.InlineAsmConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.NullConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.SelectConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.StringConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.UndefinedConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.AggregateConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.FloatingPointConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.BigIntegerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.IntegerConstant;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.math.BigInteger;

public final class Constants
implements ParserListener {
    private static final int CONSTANT_SETTYPE = 1;
    private static final int CONSTANT_NULL = 2;
    private static final int CONSTANT_UNDEF = 3;
    private static final int CONSTANT_INTEGER = 4;
    private static final int CONSTANT_WIDE_INTEGER = 5;
    private static final int CONSTANT_FLOAT = 6;
    private static final int CONSTANT_AGGREGATE = 7;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_CSTRING = 9;
    private static final int CONSTANT_CE_BINOP = 10;
    private static final int CONSTANT_CE_CAST = 11;
    private static final int CONSTANT_CE_GEP = 12;
    private static final int CONSTANT_CE_SELECT = 13;
    private static final int CONSTANT_CE_CMP = 17;
    private static final int CONSTANT_CE_INBOUNDS_GEP = 20;
    private static final int CONSTANT_BLOCKADDRESS = 21;
    private static final int CONSTANT_DATA = 22;
    private static final int CONSTANT_INLINEASM = 23;
    private static final int CONSTANT_CE_GEP_WITH_INRANGE_INDEX = 24;
    private static final BigInteger WIDE_INTEGER_MASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    private final Types types;
    private final IRScope scope;
    private Type type;

    Constants(Types types, IRScope scope) {
        this.types = types;
        this.scope = scope;
    }

    @Override
    public void record(RecordBuffer buffer) {
        int opCode = buffer.getId();
        switch (opCode) {
            case 1: {
                this.type = this.types.get(buffer.read());
                return;
            }
            case 2: {
                if (Type.isIntegerType(this.type)) {
                    this.scope.addSymbol(new NullConstant(this.type), Type.createConstantForType(this.type, 0));
                } else {
                    this.scope.addSymbol(new NullConstant(this.type), this.type);
                }
                return;
            }
            case 3: {
                this.scope.addSymbol(new UndefinedConstant(this.type), this.type);
                return;
            }
            case 4: {
                long value = buffer.readSignedValue();
                this.scope.addSymbol(new IntegerConstant(this.type, value), Type.createConstantForType(this.type, value));
                return;
            }
            case 5: {
                BigInteger value = BigInteger.ZERO;
                for (int i = 0; i < buffer.size(); ++i) {
                    BigInteger temp = BigInteger.valueOf(buffer.readSignedValue());
                    temp = temp.and(WIDE_INTEGER_MASK);
                    temp = temp.shiftLeft(i * 64);
                    value = value.add(temp);
                }
                this.scope.addSymbol(new BigIntegerConstant(this.type, value), Type.createConstantForType(this.type, value));
                return;
            }
            case 6: {
                this.scope.addSymbol(FloatingPointConstant.create(this.type, buffer), this.type);
                return;
            }
            case 7: {
                this.scope.addSymbol(AggregateConstant.createFromValues(this.scope.getSymbols(), this.type, buffer), this.type);
                return;
            }
            case 8: {
                this.scope.addSymbol(new StringConstant((ArrayType)this.type, buffer.readString(), false), this.type);
                return;
            }
            case 9: {
                this.scope.addSymbol(new StringConstant((ArrayType)this.type, buffer.readString(), true), this.type);
                return;
            }
            case 10: {
                int op = buffer.readInt();
                int lhs = buffer.readInt();
                int rhs = buffer.readInt();
                this.scope.addSymbol(BinaryOperationConstant.fromSymbols(this.scope.getSymbols(), this.type, op, lhs, rhs), this.type);
                return;
            }
            case 11: {
                int op = buffer.readInt();
                buffer.skip();
                int value = buffer.readInt();
                this.scope.addSymbol(CastConstant.fromSymbols(this.scope.getSymbols(), this.type, op, value), this.type);
                return;
            }
            case 17: {
                buffer.skip();
                int lhs = buffer.readInt();
                int rhs = buffer.readInt();
                int opcode = buffer.readInt();
                this.scope.addSymbol(CompareConstant.fromSymbols(this.scope.getSymbols(), this.type, opcode, lhs, rhs), this.type);
                return;
            }
            case 21: {
                buffer.skip();
                int function = buffer.readInt();
                int block = buffer.readInt();
                this.scope.addSymbol(BlockAddressConstant.fromSymbols(this.scope.getSymbols(), this.type, function, block), this.type);
                return;
            }
            case 22: {
                this.scope.addSymbol(AggregateConstant.createFromData(this.type, buffer), this.type);
                return;
            }
            case 23: {
                this.scope.addSymbol(InlineAsmConstant.createFromData(this.type, buffer), this.type);
                return;
            }
            case 12: 
            case 20: 
            case 24: {
                this.createGetElementPointerExpression(buffer);
                return;
            }
            case 13: {
                int condition = buffer.readInt();
                int trueValue = buffer.readInt();
                int falseValue = buffer.readInt();
                this.scope.addSymbol(SelectConstant.fromSymbols(this.scope.getSymbols(), this.type, condition, trueValue, falseValue), this.type);
                break;
            }
            default: {
                throw new LLVMParserException("Unsupported opCode in constant block: " + opCode);
            }
        }
    }

    private void createGetElementPointerExpression(RecordBuffer buffer) {
        long op;
        int opCode = buffer.getId();
        if (opCode == 24 || buffer.size() % 2 != 0) {
            buffer.skip();
        }
        boolean isInbounds = opCode == 24 ? ((op = buffer.read()) & 1L) != 0L : opCode == 20;
        buffer.skip();
        int pointer = buffer.readInt();
        int[] indices = new int[buffer.remaining() >> 1];
        for (int j = 0; j < indices.length; ++j) {
            buffer.skip();
            indices[j] = buffer.readInt();
        }
        this.scope.addSymbol(GetElementPointerConstant.fromSymbols(this.scope.getSymbols(), this.type, pointer, indices, isInbounds), this.type);
    }
}

