/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.listeners;

import com.oracle.truffle.llvm.parser.listeners.ParserListener;
import com.oracle.truffle.llvm.parser.model.ValueSymbol;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import java.util.ArrayList;
import java.util.List;

final class StringTable
implements ParserListener {
    private static final long BYTE_MASK = 255L;
    private final List<NameRequest> requests = new ArrayList<NameRequest>();
    private String table = null;

    StringTable() {
    }

    @Override
    public void record(RecordBuffer buffer) {
        byte[] bytes = new byte[buffer.size() * 8];
        int curByte = 0;
        while (buffer.remaining() > 0) {
            long l = buffer.read();
            for (int j = 0; j < 8; ++j) {
                bytes[curByte++] = (byte)(l & 0xFFL);
                l >>>= 8;
            }
        }
        this.table = new String(bytes);
    }

    @Override
    public void exit() {
        for (NameRequest request : this.requests) {
            request.resolve();
        }
        this.requests.clear();
    }

    void requestName(int offset, int length, ValueSymbol target) {
        if (length <= 0 || offset < 0) {
            return;
        }
        if (this.table != null) {
            target.setName(this.get(offset, length));
        } else {
            this.requests.add(new NameRequest(offset, length, target));
        }
    }

    private String get(int offset, int size) {
        if (offset + size < this.table.length()) {
            return this.table.substring(offset, offset + size);
        }
        return "";
    }

    private final class NameRequest {
        private final int offset;
        private final int length;
        private final ValueSymbol target;

        private NameRequest(int offset, int length, ValueSymbol target) {
            this.offset = offset;
            this.length = length;
            this.target = target;
        }

        void resolve() {
            this.target.setName(StringTable.this.get(this.offset, this.length));
        }
    }
}

