/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.macho;

import com.oracle.truffle.llvm.parser.macho.MachODylibCommand;
import com.oracle.truffle.llvm.parser.macho.MachOHeader;
import com.oracle.truffle.llvm.parser.macho.MachOLoadCommand;
import com.oracle.truffle.llvm.parser.macho.MachORPathCommand;
import com.oracle.truffle.llvm.parser.macho.MachOReader;
import com.oracle.truffle.llvm.parser.macho.MachOSegmentCommand;
import java.util.ArrayList;

public final class MachOLoadCommandTable {
    private final MachOLoadCommand[] loadCommands;
    private final MachOSegmentCommand[] segmentCommands;

    private MachOLoadCommandTable(MachOLoadCommand[] loadCommands, MachOSegmentCommand[] segmentCommands) {
        this.loadCommands = loadCommands;
        this.segmentCommands = segmentCommands;
    }

    public MachOSegmentCommand getSegment(String name) {
        for (int i = 0; i < this.segmentCommands.length; ++i) {
            if (!this.segmentCommands[i].getSegName().equals(name)) continue;
            return this.segmentCommands[i];
        }
        return null;
    }

    public MachOLoadCommand[] getLoadCommands() {
        return this.loadCommands;
    }

    public static MachOLoadCommandTable create(MachOHeader header, MachOReader reader) {
        MachOLoadCommand[] loadCommands = new MachOLoadCommand[header.getNCmds()];
        ArrayList<MachOSegmentCommand> segmentCommands = new ArrayList<MachOSegmentCommand>();
        for (int i = 0; i < header.getNCmds(); ++i) {
            loadCommands[i] = MachOLoadCommandTable.parseLoadCommand(reader);
            if (!(loadCommands[i] instanceof MachOSegmentCommand)) continue;
            segmentCommands.add((MachOSegmentCommand)loadCommands[i]);
        }
        return new MachOLoadCommandTable(loadCommands, segmentCommands.toArray(new MachOSegmentCommand[segmentCommands.size()]));
    }

    private static MachOLoadCommand parseLoadCommand(MachOReader buffer) {
        MachOLoadCommand cmd = null;
        int cmdID = buffer.getInt(buffer.getPosition());
        switch (cmdID) {
            case 1: 
            case 25: {
                cmd = MachOSegmentCommand.create(buffer);
                break;
            }
            case 12: {
                cmd = MachODylibCommand.create(buffer);
                break;
            }
            case -2147483620: {
                cmd = MachORPathCommand.create(buffer);
                break;
            }
            default: {
                int cmdSize = buffer.getInt(buffer.getPosition() + 4);
                cmd = new MachOLoadCommand(cmdID, cmdSize);
                buffer.setPosition(buffer.getPosition() + cmdSize);
            }
        }
        return cmd;
    }
}

