/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDKind;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;

public final class MDAttachment
implements MDBaseNode {
    private final MDKind kind;
    private MDBaseNode value;

    public MDAttachment(MDKind kind) {
        this.kind = kind;
        this.value = MDVoidNode.INSTANCE;
    }

    public MDKind getKind() {
        return this.kind;
    }

    public MDBaseNode getValue() {
        return this.value;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        if (this.value == oldValue) {
            this.value = newValue;
        }
    }

    public String toString() {
        return String.format("Attachment !%s", this.kind);
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDAttachment create(MDKind kind, long value, MetadataValueList md) {
        MDAttachment attachment = new MDAttachment(kind);
        attachment.value = md.getNonNullable(value, attachment);
        return attachment;
    }

    public static MDAttachment create(MDKind kind, MDBaseNode value) {
        MDAttachment attachment = new MDAttachment(kind);
        attachment.value = value;
        return attachment;
    }
}

