/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import java.util.Arrays;

public final class MDExpression
implements MDBaseNode {
    public static final MDExpression EMPTY = new MDExpression(new long[0]);
    private final long[] operands;
    private static final int INDEX_OPERANDSTART = 1;
    private static final int INDEX_VERSION = 0;
    private static final int VERSION_VALUE_SHIFT = 1;
    private static final int CURRENT_VERSION = 3;
    private static final int V0_FRAGMENT_OFFSET = 3;
    private static final long DEFAULT_OPERAND = 0L;

    private MDExpression(long[] operands) {
        this.operands = operands;
    }

    public long getOperand(int i) {
        return this.operands[i];
    }

    public int getElementCount() {
        return this.operands.length;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDExpression create(long[] record) {
        int version = (int)(record[0] >> 1);
        long[] ops = Arrays.copyOfRange(record, 1, record.length);
        ops = MDExpression.upgrade(version, ops);
        return new MDExpression(ops);
    }

    private static long[] upgrade(int version, long[] originalOps) {
        int numOps = originalOps.length;
        if (numOps == 0 || version >= 3) {
            return originalOps;
        }
        long[] ops = originalOps;
        if (version >= 0 && numOps >= 3 && ops[numOps - 3] == 157L) {
            ops[numOps - 3] = 4096L;
        }
        if (version >= 1 && ops[0] == 6L) {
            System.arraycopy(ops, 1, ops, 0, numOps - 1);
            ops[numOps - 1] = 6L;
        }
        if (version >= 2) {
            LongList buffer = new LongList(numOps);
            int i = 0;
            block6: while (i < numOps) {
                long op = ops[i++];
                switch ((int)op) {
                    case 34: {
                        buffer.add(35L);
                        buffer.add(i < numOps ? ops[i++] : 0L);
                        continue block6;
                    }
                    case 28: {
                        buffer.add(16L);
                        buffer.add(i < numOps ? ops[i++] : 0L);
                        buffer.add(28L);
                        continue block6;
                    }
                    case 16: {
                        buffer.add(op);
                        buffer.add(i < numOps ? ops[i++] : 0L);
                        continue block6;
                    }
                    case 4096: {
                        buffer.add(op);
                        buffer.add(i < numOps ? ops[i++] : 0L);
                        buffer.add(i < numOps ? ops[i++] : 0L);
                        continue block6;
                    }
                }
                buffer.add(op);
            }
            return buffer.toArray();
        }
        return ops;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MDExpression that = (MDExpression)o;
        return Arrays.equals(this.operands, that.operands);
    }

    public int hashCode() {
        return Arrays.hashCode(this.operands);
    }

    private static final class LongList {
        private long[] array;
        private int size;

        LongList(int initialCapacity) {
            this.array = new long[initialCapacity];
        }

        void add(long value) {
            if (this.size >= this.array.length) {
                this.array = Arrays.copyOf(this.array, Math.max(8, this.array.length * 2));
            }
            this.array[this.size++] = value;
        }

        long[] toArray() {
            return this.array.length == this.size ? this.array : Arrays.copyOf(this.array, this.size);
        }
    }
}

