/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;

public final class MDLexicalBlockFile
implements MDBaseNode {
    private final long discriminator;
    private MDBaseNode scope;
    private MDBaseNode file;
    private static final int ARGINDEX_SCOPE = 1;
    private static final int ARGINDEX_FILE = 2;
    private static final int ARGINDEX_38_DISCRIMINATOR = 3;

    private MDLexicalBlockFile(long discriminator) {
        this.discriminator = discriminator;
        this.scope = MDVoidNode.INSTANCE;
        this.file = MDVoidNode.INSTANCE;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public MDBaseNode getFile() {
        return this.file;
    }

    public MDBaseNode getScope() {
        return this.scope;
    }

    public long getDiscriminator() {
        return this.discriminator;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        if (this.scope == oldValue) {
            this.scope = newValue;
        }
        if (this.file == oldValue) {
            this.file = newValue;
        }
    }

    public static MDLexicalBlockFile create38(long[] args, MetadataValueList md) {
        long discriminator = args[3];
        MDLexicalBlockFile file = new MDLexicalBlockFile(discriminator);
        file.scope = md.getNullable(args[1], file);
        file.file = md.getNullable(args[2], file);
        return file;
    }

    public static MDLexicalBlockFile create32(long[] args, Metadata md) {
        MDLexicalBlockFile file = new MDLexicalBlockFile(-1L);
        file.scope = ParseUtil.resolveReference(args, 1, file, md);
        file.file = ParseUtil.resolveReference(args, 2, file, md);
        return file;
    }
}

