/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDName;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;

public final class MDModule
extends MDName
implements MDBaseNode {
    private MDBaseNode scope = MDVoidNode.INSTANCE;
    private MDBaseNode configurationMacros = MDVoidNode.INSTANCE;
    private MDBaseNode includePath = MDVoidNode.INSTANCE;
    private MDBaseNode sysRoot = MDVoidNode.INSTANCE;
    private static final int ARGINDEX_SCOPE = 1;
    private static final int ARGINDEX_NAME = 2;
    private static final int ARGINDEX_CONFIGURATIONMACROS = 3;
    private static final int ARGINDEX_INCLUDEPATH = 4;
    private static final int ARGINDEX_SYSROOT = 5;

    private MDModule() {
    }

    public MDBaseNode getScope() {
        return this.scope;
    }

    public MDBaseNode getConfigurationMacros() {
        return this.configurationMacros;
    }

    public MDBaseNode getIncludePath() {
        return this.includePath;
    }

    public MDBaseNode getSysRoot() {
        return this.sysRoot;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.scope == oldValue) {
            this.scope = newValue;
        }
        if (this.configurationMacros == oldValue) {
            this.configurationMacros = newValue;
        }
        if (this.includePath == oldValue) {
            this.includePath = newValue;
        }
        if (this.sysRoot == oldValue) {
            this.sysRoot = newValue;
        }
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDModule create38(long[] args, MetadataValueList md) {
        MDModule module = new MDModule();
        module.scope = md.getNullable(args[1], module);
        module.configurationMacros = md.getNullable(args[3], module);
        module.includePath = md.getNullable(args[4], module);
        module.sysRoot = md.getNullable(args[5], module);
        module.setName(md.getNullable(args[2], module));
        return module;
    }
}

