/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDName;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;

public abstract class MDNamedLocation
extends MDName {
    private final long line;
    private MDBaseNode scope;
    private MDBaseNode file;

    MDNamedLocation(long line) {
        this.line = line;
        this.scope = MDVoidNode.INSTANCE;
        this.file = MDVoidNode.INSTANCE;
    }

    public long getLine() {
        return this.line;
    }

    public MDBaseNode getScope() {
        return this.scope;
    }

    public void setScope(MDBaseNode scope) {
        this.scope = scope;
    }

    public MDBaseNode getFile() {
        return this.file;
    }

    public void setFile(MDBaseNode file) {
        this.file = file;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.scope == oldValue) {
            this.scope = newValue;
        }
        if (this.file == oldValue) {
            this.file = newValue;
        }
    }
}

