/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata.debuginfo;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDBasicType;
import com.oracle.truffle.llvm.parser.metadata.MDCommonBlock;
import com.oracle.truffle.llvm.parser.metadata.MDCompositeType;
import com.oracle.truffle.llvm.parser.metadata.MDDerivedType;
import com.oracle.truffle.llvm.parser.metadata.MDEnumerator;
import com.oracle.truffle.llvm.parser.metadata.MDGlobalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDGlobalVariableExpression;
import com.oracle.truffle.llvm.parser.metadata.MDLabel;
import com.oracle.truffle.llvm.parser.metadata.MDLocalVariable;
import com.oracle.truffle.llvm.parser.metadata.MDModule;
import com.oracle.truffle.llvm.parser.metadata.MDNamedNode;
import com.oracle.truffle.llvm.parser.metadata.MDNamespace;
import com.oracle.truffle.llvm.parser.metadata.MDObjCProperty;
import com.oracle.truffle.llvm.parser.metadata.MDString;
import com.oracle.truffle.llvm.parser.metadata.MDSubprogram;
import com.oracle.truffle.llvm.parser.metadata.MDTemplateType;
import com.oracle.truffle.llvm.parser.metadata.MDTemplateTypeParameter;
import com.oracle.truffle.llvm.parser.metadata.MDTemplateValue;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;

final class MDNameExtractor
implements MetadataVisitor {
    private static final String DEFAULT_STRING = "<anonymous>";
    private String str = "<anonymous>";

    static String getName(MDBaseNode container) {
        if (container == null) {
            return DEFAULT_STRING;
        }
        MDNameExtractor visitor = new MDNameExtractor();
        container.accept(visitor);
        return visitor.str;
    }

    private MDNameExtractor() {
    }

    @Override
    public void visit(MDString md) {
        this.str = md.getString();
    }

    @Override
    public void visit(MDGlobalVariableExpression mdGVE) {
        mdGVE.getGlobalVariable().accept(this);
    }

    @Override
    public void visit(MDGlobalVariable mdGlobal) {
        mdGlobal.getName().accept(this);
    }

    @Override
    public void visit(MDLocalVariable mdLocal) {
        mdLocal.getName().accept(this);
    }

    @Override
    public void visit(MDEnumerator mdEnumElement) {
        mdEnumElement.getName().accept(this);
    }

    @Override
    public void visit(MDNamespace mdNamespace) {
        mdNamespace.getName().accept(this);
    }

    @Override
    public void visit(MDSubprogram md) {
        md.getName().accept(this);
        if (DEFAULT_STRING.equals(this.str)) {
            md.getDisplayName().accept(this);
        }
        if (DEFAULT_STRING.equals(this.str)) {
            md.getLinkageName().accept(this);
        }
    }

    @Override
    public void visit(MDBasicType md) {
        md.getName().accept(this);
    }

    @Override
    public void visit(MDCompositeType md) {
        md.getName().accept(this);
    }

    @Override
    public void visit(MDDerivedType md) {
        md.getName().accept(this);
    }

    @Override
    public void visit(MDModule md) {
        md.getName().accept(this);
    }

    @Override
    public void visit(MDNamedNode md) {
        this.str = md.getName();
    }

    @Override
    public void visit(MDObjCProperty md) {
        md.getName().accept(this);
    }

    @Override
    public void visit(MDTemplateType md) {
        md.getName().accept(this);
    }

    @Override
    public void visit(MDTemplateTypeParameter md) {
        md.getName().accept(this);
    }

    @Override
    public void visit(MDTemplateValue md) {
        md.getName().accept(this);
    }

    @Override
    public void visit(MDCommonBlock md) {
        md.getName().accept(this);
    }

    @Override
    public void visit(MDLabel md) {
        md.getName().accept(this);
    }
}

