/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.attributes;

import com.oracle.truffle.llvm.parser.model.attributes.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AttributesGroup {
    private final long groupId;
    private final long paramIdx;
    private final ArrayList<Attribute> attributes = new ArrayList();
    public static final long RETURN_VALUE_IDX = 0L;
    public static final long FUNCTION_ATTRIBUTE_IDX = 0xFFFFFFFFL;

    public AttributesGroup(long groupId, long paramIdx) {
        this.groupId = groupId;
        this.paramIdx = paramIdx;
    }

    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public void addAttribute(Attribute attr) {
        this.attributes.add(attr);
    }

    public long getGroupId() {
        return this.groupId;
    }

    public long getParamIdx() {
        return this.paramIdx;
    }

    public boolean isReturnValueAttribute() {
        return this.paramIdx == 0L;
    }

    public boolean isFunctionAttribute() {
        return this.paramIdx == 0xFFFFFFFFL;
    }

    public boolean isParameterAttribute() {
        return !this.isReturnValueAttribute() && !this.isFunctionAttribute();
    }

    public String toString() {
        return "AttributesGroup [groupId=" + this.groupId + ", paramIdx=" + this.paramIdx + ", attributes=" + this.attributes + "]";
    }
}

