/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.functions;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.llvm.parser.model.GlobalSymbol;
import com.oracle.truffle.llvm.parser.model.ValueSymbol;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesCodeEntry;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import com.oracle.truffle.llvm.parser.model.enums.Linkage;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

public abstract class FunctionSymbol
extends GlobalSymbol
implements ValueSymbol {
    private final FunctionType type;
    private final AttributesCodeEntry paramAttr;

    public FunctionSymbol(FunctionType type, String name, Linkage linkage, AttributesCodeEntry paramAttr) {
        super(name, linkage);
        this.type = type;
        this.paramAttr = paramAttr;
    }

    @Override
    public final FunctionType getType() {
        return this.type;
    }

    public final AttributesGroup getFunctionAttributesGroup() {
        CompilerAsserts.neverPartOfCompilation();
        return this.paramAttr.getFunctionAttributesGroup();
    }

    public final AttributesGroup getReturnAttributesGroup() {
        CompilerAsserts.neverPartOfCompilation();
        return this.paramAttr.getReturnAttributesGroup();
    }

    public final AttributesGroup getParameterAttributesGroup(int idx) {
        CompilerAsserts.neverPartOfCompilation();
        return this.paramAttr.getParameterAttributesGroup(idx);
    }
}

