/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.functions;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.listeners.Function;
import com.oracle.truffle.llvm.parser.listeners.ParameterAttributes;
import com.oracle.truffle.llvm.parser.listeners.Types;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoFunctionProcessor;
import com.oracle.truffle.llvm.parser.model.IRScope;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.scanner.LLVMScanner;
import com.oracle.truffle.llvm.parser.text.LLSourceBuilder;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;

public final class LazyFunctionParser {
    private final LLVMScanner.LazyScanner scanner;
    public final IRScope scope;
    private final Types types;
    private final FunctionDefinition function;
    private final int mode;
    private final ParameterAttributes paramAttributes;
    private final LLSourceBuilder llSource;
    private boolean isParsed;

    public LazyFunctionParser(LLVMScanner.LazyScanner scanner, IRScope scope, Types types, FunctionDefinition function, int mode, ParameterAttributes paramAttributes, LLSourceBuilder llSource) {
        this.scanner = scanner;
        this.scope = scope;
        this.types = types;
        this.function = function;
        this.mode = mode;
        this.paramAttributes = paramAttributes;
        this.llSource = llSource;
        this.isParsed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(DebugInfoFunctionProcessor diProcessor, Source bitcodeSource, LLVMParserRuntime runtime) {
        if (!this.isParsed) {
            IRScope iRScope = this.scope;
            synchronized (iRScope) {
                Function parser = new Function(this.scope, this.types, this.function, this.mode, this.paramAttributes);
                parser.setupScope();
                this.scanner.scanBlock(parser);
                diProcessor.process(parser.getFunction(), parser.getScope(), bitcodeSource, runtime.getContext());
                if (((Boolean)runtime.getContext().getEnv().getOptions().get(SulongEngineOption.LL_DEBUG)).booleanValue()) {
                    this.llSource.applySourceLocations(parser.getFunction(), runtime);
                }
                this.isParsed = true;
            }
        }
    }
}

