/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint;

import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.FloatingPointConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import java.util.Arrays;

public final class X86FP80Constant
extends FloatingPointConstant {
    private final byte[] value;
    private static final int HEX_MASK = 15;
    private static final int BYTE_MSB_SHIFT = 4;

    X86FP80Constant(byte[] value) {
        super(PrimitiveType.X86_FP80);
        this.value = value;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        return Arrays.toString(this.value);
    }

    @Override
    public String getStringValue() {
        StringBuilder builder = new StringBuilder("0xK");
        for (byte aValue : this.value) {
            builder.append(String.format("%x%x", aValue >>> 4 & 0xF, aValue & 0xF));
        }
        return builder.toString();
    }
}

