/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants.integer;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class IntegerConstant
extends AbstractConstant {
    private final long value;

    public IntegerConstant(Type type, long value) {
        super(type);
        this.value = value;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        if (this.getType().getBitSize() == 1) {
            return this.value == 0L ? "false" : "true";
        }
        return String.valueOf(this.value);
    }

    public static IntegerConstant createFromData(Type type, RecordBuffer buffer) {
        int bits = type.getBitSize();
        long d = buffer.read();
        if (bits > 1 && bits < 64) {
            d = IntegerConstant.extendSign(bits, d);
        }
        return new IntegerConstant(type, d);
    }

    private static long extendSign(int bits, long value) {
        long v = value;
        long mask = ((1L << bits) - 1L ^ 0xFFFFFFFFFFFFFFFFL) >> 1;
        if ((v & mask) != 0L) {
            v |= mask;
        }
        return v;
    }
}

