/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.CastOperator;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class CastInstruction
extends ValueInstruction {
    private final CastOperator operator;
    private SymbolImpl value;

    private CastInstruction(Type type, CastOperator operator) {
        super(type);
        this.operator = operator;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public CastOperator getOperator() {
        return this.operator;
    }

    public SymbolImpl getValue() {
        return this.value;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.value == original) {
            this.value = replacement;
        }
    }

    public static CastInstruction fromSymbols(SymbolTable symbols, Type type, int opcode, int value) {
        CastInstruction inst = new CastInstruction(type, CastOperator.decode(opcode));
        inst.value = symbols.getForwardReferenced(value, inst);
        return inst;
    }

    public String toString() {
        return String.format("(%s) %s", new Object[]{this.operator, this.value});
    }
}

