/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class InsertValueInstruction
extends ValueInstruction {
    private SymbolImpl aggregate;
    private SymbolImpl value;
    private final int index;

    private InsertValueInstruction(Type type, int index) {
        super(type);
        this.index = index;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getAggregate() {
        return this.aggregate;
    }

    public int getIndex() {
        return this.index;
    }

    public SymbolImpl getValue() {
        return this.value;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.aggregate == original) {
            this.aggregate = replacement;
        }
        if (this.value == original) {
            this.value = replacement;
        }
    }

    public static InsertValueInstruction fromSymbols(SymbolTable symbols, Type type, int aggregate, int index, int value) {
        InsertValueInstruction inst = new InsertValueInstruction(type, index);
        inst.aggregate = symbols.getForwardReferenced(aggregate, inst);
        inst.value = symbols.getForwardReferenced(value, inst);
        return inst;
    }
}

