/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.enums.AtomicOrdering;
import com.oracle.truffle.llvm.parser.model.enums.ReadModifyWriteOperator;
import com.oracle.truffle.llvm.parser.model.enums.SynchronizationScope;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class ReadModifyWriteInstruction
extends ValueInstruction {
    private final ReadModifyWriteOperator operator;
    private final AtomicOrdering atomicOrdering;
    private final boolean isVolatile;
    private final SynchronizationScope synchronizationScope;
    private SymbolImpl ptr;
    private SymbolImpl value;

    private ReadModifyWriteInstruction(Type type, ReadModifyWriteOperator operator, boolean isVolatile, AtomicOrdering atomicOrdering, SynchronizationScope synchronizationScope) {
        super(type);
        this.operator = operator;
        this.atomicOrdering = atomicOrdering;
        this.isVolatile = isVolatile;
        this.synchronizationScope = synchronizationScope;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getPtr() {
        return this.ptr;
    }

    public SymbolImpl getValue() {
        return this.value;
    }

    public ReadModifyWriteOperator getOperator() {
        return this.operator;
    }

    public AtomicOrdering getAtomicOrdering() {
        return this.atomicOrdering;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public SynchronizationScope getSynchronizationScope() {
        return this.synchronizationScope;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
        if (this.ptr == oldValue) {
            this.ptr = newValue;
        }
        if (this.value == oldValue) {
            this.value = newValue;
        }
    }

    public static ReadModifyWriteInstruction fromSymbols(SymbolTable symbols, Type type, int ptr, int value, int opcode, boolean isVolatile, long atomicOrdering, long synchronizationScope) {
        ReadModifyWriteOperator operator = ReadModifyWriteOperator.decode(opcode);
        ReadModifyWriteInstruction inst = new ReadModifyWriteInstruction(type, operator, isVolatile, AtomicOrdering.decode(atomicOrdering), SynchronizationScope.decode(synchronizationScope));
        inst.ptr = symbols.getForwardReferenced(ptr, inst);
        inst.value = symbols.getForwardReferenced(value, inst);
        return inst;
    }
}

