/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public final class ReturnInstruction
extends VoidInstruction
implements TerminatingInstruction {
    private SymbolImpl value;

    private ReturnInstruction() {
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getValue() {
        return this.value;
    }

    @Override
    public int getSuccessorCount() {
        return 0;
    }

    @Override
    public InstructionBlock getSuccessor(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.value == original) {
            this.value = replacement;
        }
    }

    public static ReturnInstruction generate(SymbolTable symbols, int value) {
        ReturnInstruction inst = new ReturnInstruction();
        inst.value = symbols.getForwardReferenced(value, inst);
        return inst;
    }

    public static ReturnInstruction generate() {
        return new ReturnInstruction();
    }
}

