/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.nodes;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.llvm.parser.LLVMLivenessAnalysis;
import com.oracle.truffle.llvm.parser.LLVMPhiManager;
import com.oracle.truffle.llvm.parser.metadata.MDExpression;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceVariable;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.attributes.Attribute;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import com.oracle.truffle.llvm.parser.model.enums.AsmDialect;
import com.oracle.truffle.llvm.parser.model.enums.ReadModifyWriteOperator;
import com.oracle.truffle.llvm.parser.model.symbols.constants.InlineAsmConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.NullConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.IntegerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.AllocateInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.BinaryOperationInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.BranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CallInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CastInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CompareExchangeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.CompareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ConditionalBranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgDeclareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DebugTrapInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ExtractElementInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ExtractValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.FenceInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.GetElementPointerInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.IndirectBranchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InsertElementInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InsertValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.InvokeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.LandingpadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.LoadInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.PhiInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ReadModifyWriteInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ResumeInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ReturnInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SelectInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ShuffleVectorInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.StoreInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SwitchInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.SwitchOldInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.UnreachableInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidCallInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInvokeInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.parser.nodes.LLVMRuntimeDebugInformation;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.parser.util.LLVMBitcodeTypeHelper;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMControlFlowNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMInstrumentableNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNodeSourceDescriptor;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMVoidStatementNodeGen;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class LLVMBitcodeInstructionVisitor
implements SymbolVisitor {
    public static final FrameSlot[] NO_SLOTS = new FrameSlot[0];
    private final LLVMContext context;
    private final NodeFactory nodeFactory;
    private final FrameDescriptor frame;
    private final List<LLVMPhiManager.Phi> blockPhis;
    private final int argCount;
    private final LLVMSymbolReadResolver symbols;
    private final LLVMContext.ExternalLibrary library;
    private final ArrayList<LLVMLivenessAnalysis.NullerInformation> nullerInfos;
    private final List<FrameSlot> notNullable;
    private final LLVMRuntimeDebugInformation dbgInfoHandler;
    private final LLVMStack.UniquesRegion uniquesRegion;
    private final DataLayout dataLayout;
    private final List<LLVMStatementNode> blockInstructions;
    private int instructionIndex;
    private LLVMControlFlowNode controlFlowNode;
    private LLVMSourceLocation lastLocation;

    public static LLVMBitcodeInstructionVisitor create(FrameDescriptor frame, LLVMStack.UniquesRegion uniquesRegion, List<LLVMPhiManager.Phi> blockPhis, int argCount, LLVMSymbolReadResolver symbols, LLVMContext context, LLVMContext.ExternalLibrary library, ArrayList<LLVMLivenessAnalysis.NullerInformation> nullerInfos, List<FrameSlot> notNullable, LLVMRuntimeDebugInformation dbgInfoHandler, DataLayout dataLayout, NodeFactory nodeFactory) {
        return new LLVMBitcodeInstructionVisitor(frame, uniquesRegion, blockPhis, argCount, symbols, context, library, nullerInfos, notNullable, dbgInfoHandler, dataLayout, nodeFactory);
    }

    private LLVMBitcodeInstructionVisitor(FrameDescriptor frame, LLVMStack.UniquesRegion uniquesRegion, List<LLVMPhiManager.Phi> blockPhis, int argCount, LLVMSymbolReadResolver symbols, LLVMContext context, LLVMContext.ExternalLibrary library, ArrayList<LLVMLivenessAnalysis.NullerInformation> nullerInfos, List<FrameSlot> notNullable, LLVMRuntimeDebugInformation dbgInfoHandler, DataLayout dataLayout, NodeFactory nodeFactory) {
        this.context = context;
        this.nodeFactory = nodeFactory;
        this.frame = frame;
        this.blockPhis = blockPhis;
        this.argCount = argCount;
        this.symbols = symbols;
        this.library = library;
        this.nullerInfos = nullerInfos;
        this.notNullable = notNullable;
        this.dbgInfoHandler = dbgInfoHandler;
        this.lastLocation = null;
        this.uniquesRegion = uniquesRegion;
        this.dataLayout = dataLayout;
        this.blockInstructions = new ArrayList<LLVMStatementNode>();
    }

    public LLVMStatementNode[] getInstructions() {
        return this.blockInstructions.toArray(LLVMStatementNode.NO_STATEMENTS);
    }

    public LLVMControlFlowNode getControlFlowNode() {
        return this.controlFlowNode;
    }

    public void setInstructionIndex(int instructionIndex) {
        this.instructionIndex = instructionIndex;
    }

    @Override
    public void defaultAction(SymbolImpl symbol) {
        throw new LLVMParserException("Instruction not implemented: " + symbol.getClass().getSimpleName());
    }

    @Override
    public void visit(AllocateInstruction allocate) {
        LLVMExpressionNode result;
        SymbolImpl count;
        Type type = allocate.getPointeeType();
        int alignment = allocate.getAlign() == 0 ? type.getAlignment(this.dataLayout) : 1 << allocate.getAlign() - 1;
        if (alignment == 0) {
            alignment = 1;
        }
        if ((count = allocate.getCount()) instanceof NullConstant) {
            result = this.nodeFactory.createAlloca(type, alignment);
        } else if (count instanceof IntegerConstant) {
            long numElements = (int)((IntegerConstant)count).getValue();
            if (numElements == 1L) {
                result = this.nodeFactory.createAlloca(type, alignment);
            } else {
                assert (numElements == (long)((int)numElements));
                ArrayType arrayType = new ArrayType(type, (int)numElements);
                result = this.nodeFactory.createAlloca(arrayType, alignment);
            }
        } else {
            LLVMExpressionNode num = this.symbols.resolve(count);
            result = this.nodeFactory.createAllocaArray(type, num, alignment);
        }
        SourceInstrumentationStrategy intention = (Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.LL_DEBUG) != false ? SourceInstrumentationStrategy.FORCED : SourceInstrumentationStrategy.DISABLED;
        this.createFrameWrite(result, allocate, intention);
    }

    @Override
    public void visit(BinaryOperationInstruction operation) {
        LLVMExpressionNode lhs = this.symbols.resolve(operation.getLHS());
        LLVMExpressionNode rhs = this.symbols.resolve(operation.getRHS());
        LLVMExpressionNode result = LLVMBitcodeTypeHelper.createArithmeticInstruction(this.nodeFactory, lhs, rhs, operation.getOperator(), operation.getType());
        this.createFrameWrite(result, operation);
    }

    @Override
    public void visit(BranchInstruction branch) {
        LLVMControlFlowNode unconditionalBranchNode = this.nodeFactory.createUnconditionalBranch(branch.getSuccessor().getBlockIndex(), this.getPhiWriteNodes(branch)[0]);
        this.setControlFlowNode(unconditionalBranchNode, branch);
    }

    private LLVMExpressionNode tryGenerateBuiltinNode(SymbolImpl target, LLVMExpressionNode[] argNodes, Type[] argTypes, Instruction callInstruction, SourceInstrumentationStrategy intention) {
        LLVMExpressionNode llvmBuiltin = this.nodeFactory.createLLVMBuiltin(target, argNodes, argTypes, this.argCount);
        if (llvmBuiltin != null) {
            this.assignSourceLocation(llvmBuiltin, callInstruction, intention);
        }
        return llvmBuiltin;
    }

    @Override
    public void visit(CallInstruction call) {
        Type targetType = call.getType();
        int argumentCount = LLVMBitcodeInstructionVisitor.getArgumentCount(call.getArgumentCount(), targetType);
        LLVMExpressionNode[] argNodes = new LLVMExpressionNode[argumentCount];
        Type[] argTypes = new Type[argumentCount];
        int argIndex = 0;
        argNodes[argIndex] = CommonNodeFactory.createFrameRead(PointerType.VOID, this.getStackSlot());
        argTypes[argIndex] = new PointerType(null);
        ++argIndex;
        if (targetType instanceof StructureType) {
            argTypes[argIndex] = new PointerType(targetType);
            argNodes[argIndex] = this.nodeFactory.createGetUniqueStackSpace(targetType, this.uniquesRegion);
            ++argIndex;
        }
        int i = 0;
        while (argIndex < argumentCount) {
            argNodes[argIndex] = this.symbols.resolve(call.getArgument(i));
            argTypes[argIndex] = call.getArgument(i).getType();
            AttributesGroup paramAttr = call.getParameterAttributesGroup(i);
            if (LLVMBitcodeInstructionVisitor.isByValue(paramAttr)) {
                argNodes[argIndex] = this.capsuleAddressByValue(argNodes[argIndex], argTypes[argIndex], paramAttr);
            }
            ++argIndex;
            ++i;
        }
        SymbolImpl target = call.getCallTarget();
        LLVMExpressionNode result = this.tryGenerateBuiltinNode(target, argNodes, argTypes, call, SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION);
        if (result == null) {
            if (target instanceof InlineAsmConstant) {
                InlineAsmConstant inlineAsmConstant = (InlineAsmConstant)target;
                result = this.createInlineAssemblerNode(inlineAsmConstant, argNodes, argTypes, targetType);
                this.assignSourceLocation(result, call);
            } else {
                LLVMExpressionNode function = this.symbols.resolve(target);
                result = CommonNodeFactory.createFunctionCall(function, argNodes, new FunctionType(targetType, argTypes, false));
                this.assignSourceLocation(result, call, SourceInstrumentationStrategy.FORCED);
            }
        }
        this.createFrameWrite(result, call, SourceInstrumentationStrategy.DISABLED);
    }

    @Override
    public void visit(LandingpadInstruction landingpadInstruction) {
        Type type = landingpadInstruction.getType();
        LLVMExpressionNode allocateLandingPadValue = this.nodeFactory.createGetUniqueStackSpace(type, this.uniquesRegion);
        LLVMExpressionNode[] entries = new LLVMExpressionNode[landingpadInstruction.getClauseSymbols().length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = this.symbols.resolve(landingpadInstruction.getClauseSymbols()[i]);
        }
        LLVMExpressionNode getStack = CommonNodeFactory.createFrameRead(PointerType.VOID, this.getStackSlot());
        LLVMExpressionNode landingPad = this.nodeFactory.createLandingPad(allocateLandingPadValue, this.getExceptionSlot(), landingpadInstruction.isCleanup(), landingpadInstruction.getClauseTypes(), entries, getStack);
        this.createFrameWrite(landingPad, landingpadInstruction);
    }

    @Override
    public void visit(ResumeInstruction resumeInstruction) {
        LLVMControlFlowNode resume = this.nodeFactory.createResumeInstruction(this.getExceptionSlot());
        this.setControlFlowNode(resume, resumeInstruction);
    }

    @Override
    public void visit(CompareExchangeInstruction cmpxchg) {
        LLVMExpressionNode ptrNode = this.symbols.resolve(cmpxchg.getPtr());
        LLVMExpressionNode cmpNode = this.symbols.resolve(cmpxchg.getCmp());
        LLVMExpressionNode newNode = this.symbols.resolve(cmpxchg.getReplace());
        Type elementType = cmpxchg.getCmp().getType();
        this.createFrameWrite(this.nodeFactory.createCompareExchangeInstruction(cmpxchg.getAggregateType(), elementType, ptrNode, cmpNode, newNode), cmpxchg);
    }

    private void visitDebugIntrinsic(SymbolImpl value, SourceVariable variable, MDExpression expression, long index, boolean isDeclaration) {
        LLVMStatementNode dbgIntrinsic = this.dbgInfoHandler.handleDebugIntrinsic(value, variable, expression, index, isDeclaration);
        if (dbgIntrinsic != null) {
            this.addInstructionUnchecked(dbgIntrinsic);
        }
        this.handleNullerInfo();
    }

    @Override
    public void visit(DbgDeclareInstruction inst) {
        this.visitDebugIntrinsic(inst.getValue(), inst.getVariable(), inst.getExpression(), 0L, true);
    }

    @Override
    public void visit(DbgValueInstruction inst) {
        this.visitDebugIntrinsic(inst.getValue(), inst.getVariable(), inst.getExpression(), inst.getIndex(), false);
    }

    @Override
    public void visit(DebugTrapInstruction inst) {
        LLVMStatementNode debugTrap = CommonNodeFactory.createDebugTrap();
        this.assignSourceLocation(debugTrap, inst, SourceInstrumentationStrategy.FORCED);
        this.addInstruction(debugTrap);
    }

    @Override
    public void visit(VoidCallInstruction call) {
        int argumentCount = call.getArgumentCount() + 1;
        LLVMExpressionNode[] args = new LLVMExpressionNode[argumentCount];
        Type[] argsType = new Type[argumentCount];
        int argIndex = 0;
        args[argIndex] = CommonNodeFactory.createFrameRead(PointerType.VOID, this.getStackSlot());
        argsType[argIndex] = new PointerType(null);
        ++argIndex;
        for (int i = 0; i < call.getArgumentCount(); ++i) {
            args[argIndex] = this.symbols.resolve(call.getArgument(i));
            argsType[argIndex] = call.getArgument(i).getType();
            AttributesGroup paramAttr = call.getParameterAttributesGroup(i);
            if (LLVMBitcodeInstructionVisitor.isByValue(paramAttr)) {
                args[argIndex] = this.capsuleAddressByValue(args[argIndex], argsType[argIndex], paramAttr);
            }
            ++argIndex;
        }
        SymbolImpl target = call.getCallTarget();
        LLVMExpressionNode node = this.tryGenerateBuiltinNode(target, args, argsType, call, SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION);
        if (node == null) {
            if (target instanceof InlineAsmConstant) {
                InlineAsmConstant inlineAsmConstant = (InlineAsmConstant)target;
                node = this.createInlineAssemblerNode(inlineAsmConstant, args, argsType, call.getType());
                this.assignSourceLocation(node, call);
            } else {
                LLVMExpressionNode function = this.symbols.resolve(target);
                FunctionType functionType = new FunctionType(call.getType(), argsType, false);
                node = CommonNodeFactory.createFunctionCall(function, args, functionType);
                this.assignSourceLocation(node, call, SourceInstrumentationStrategy.FORCED);
            }
        }
        this.addInstruction(LLVMVoidStatementNodeGen.create(node));
    }

    @Override
    public void visit(InvokeInstruction call) {
        Type targetType = call.getType();
        int argumentCount = LLVMBitcodeInstructionVisitor.getArgumentCount(call.getArgumentCount(), targetType);
        LLVMExpressionNode[] argNodes = new LLVMExpressionNode[argumentCount];
        Type[] argTypes = new Type[argumentCount];
        int argIndex = 0;
        argNodes[argIndex] = CommonNodeFactory.createFrameRead(PointerType.VOID, this.getStackSlot());
        argTypes[argIndex] = new PointerType(null);
        ++argIndex;
        if (targetType instanceof StructureType) {
            argTypes[argIndex] = new PointerType(targetType);
            argNodes[argIndex] = this.nodeFactory.createGetUniqueStackSpace(targetType, this.uniquesRegion);
            ++argIndex;
        }
        int i = 0;
        while (argIndex < argumentCount) {
            argNodes[argIndex] = this.symbols.resolve(call.getArgument(i));
            argTypes[argIndex] = call.getArgument(i).getType();
            AttributesGroup paramAttr = call.getParameterAttributesGroup(i);
            if (LLVMBitcodeInstructionVisitor.isByValue(paramAttr)) {
                argNodes[argIndex] = this.capsuleAddressByValue(argNodes[argIndex], argTypes[argIndex], paramAttr);
            }
            ++i;
            ++argIndex;
        }
        SymbolImpl target = call.getCallTarget();
        int regularIndex = call.normalSuccessor().getBlockIndex();
        int unwindIndex = call.unwindSuccessor().getBlockIndex();
        ArrayList<FrameSlot> normalTo = new ArrayList<FrameSlot>();
        ArrayList<FrameSlot> unwindTo = new ArrayList<FrameSlot>();
        ArrayList<Type> normalType = new ArrayList<Type>();
        ArrayList<Type> unwindType = new ArrayList<Type>();
        ArrayList<LLVMExpressionNode> normalValue = new ArrayList<LLVMExpressionNode>();
        ArrayList<LLVMExpressionNode> unwindValue = new ArrayList<LLVMExpressionNode>();
        if (this.blockPhis != null) {
            for (LLVMPhiManager.Phi phi : this.blockPhis) {
                FrameSlot slot = this.getSlot(phi.getPhiValue());
                LLVMExpressionNode value = this.symbols.resolve(phi.getValue());
                if (call.normalSuccessor() == phi.getBlock()) {
                    normalTo.add(slot);
                    normalType.add(phi.getValue().getType());
                    normalValue.add(value);
                    continue;
                }
                unwindTo.add(slot);
                unwindType.add(phi.getValue().getType());
                unwindValue.add(value);
            }
        }
        LLVMStatementNode normalPhi = this.nodeFactory.createPhi(normalValue.toArray(LLVMExpressionNode.NO_EXPRESSIONS), normalTo.toArray(NO_SLOTS), normalType.toArray(Type.EMPTY_ARRAY));
        LLVMStatementNode unwindPhi = this.nodeFactory.createPhi(unwindValue.toArray(LLVMExpressionNode.NO_EXPRESSIONS), unwindTo.toArray(NO_SLOTS), unwindType.toArray(Type.EMPTY_ARRAY));
        LLVMExpressionNode function = this.symbols.resolve(target);
        LLVMControlFlowNode result = this.nodeFactory.createFunctionInvoke(this.getSlot(call), function, argNodes, new FunctionType(targetType, argTypes, false), regularIndex, unwindIndex, normalPhi, unwindPhi);
        this.setControlFlowNode(result, call, SourceInstrumentationStrategy.FORCED);
    }

    @Override
    public void visit(VoidInvokeInstruction call) {
        SymbolImpl target = call.getCallTarget();
        int argumentCount = call.getArgumentCount() + 1;
        LLVMExpressionNode[] args = new LLVMExpressionNode[argumentCount];
        Type[] argsType = new Type[argumentCount];
        int argIndex = 0;
        args[argIndex] = CommonNodeFactory.createFrameRead(PointerType.VOID, this.getStackSlot());
        argsType[argIndex] = new PointerType(null);
        ++argIndex;
        for (int i = 0; i < call.getArgumentCount(); ++i) {
            args[argIndex] = this.symbols.resolve(call.getArgument(i));
            argsType[argIndex] = call.getArgument(i).getType();
            AttributesGroup paramAttr = call.getParameterAttributesGroup(i);
            if (LLVMBitcodeInstructionVisitor.isByValue(paramAttr)) {
                args[argIndex] = this.capsuleAddressByValue(args[argIndex], argsType[argIndex], paramAttr);
            }
            ++argIndex;
        }
        int regularIndex = call.normalSuccessor().getBlockIndex();
        int unwindIndex = call.unwindSuccessor().getBlockIndex();
        ArrayList<FrameSlot> normalTo = new ArrayList<FrameSlot>();
        ArrayList<FrameSlot> unwindTo = new ArrayList<FrameSlot>();
        ArrayList<Type> normalType = new ArrayList<Type>();
        ArrayList<Type> unwindType = new ArrayList<Type>();
        ArrayList<LLVMExpressionNode> normalValue = new ArrayList<LLVMExpressionNode>();
        ArrayList<LLVMExpressionNode> unwindValue = new ArrayList<LLVMExpressionNode>();
        if (this.blockPhis != null) {
            for (LLVMPhiManager.Phi phi : this.blockPhis) {
                FrameSlot slot = this.getSlot(phi.getPhiValue());
                LLVMExpressionNode value = this.symbols.resolve(phi.getValue());
                if (call.normalSuccessor() == phi.getBlock()) {
                    normalTo.add(slot);
                    normalType.add(phi.getValue().getType());
                    normalValue.add(value);
                    continue;
                }
                unwindTo.add(slot);
                unwindType.add(phi.getValue().getType());
                unwindValue.add(value);
            }
        }
        LLVMStatementNode normalPhi = this.nodeFactory.createPhi(normalValue.toArray(LLVMExpressionNode.NO_EXPRESSIONS), normalTo.toArray(NO_SLOTS), normalType.toArray(Type.EMPTY_ARRAY));
        LLVMStatementNode unwindPhi = this.nodeFactory.createPhi(unwindValue.toArray(LLVMExpressionNode.NO_EXPRESSIONS), unwindTo.toArray(NO_SLOTS), unwindType.toArray(Type.EMPTY_ARRAY));
        LLVMExpressionNode function = this.symbols.resolve(target);
        LLVMControlFlowNode result = this.nodeFactory.createFunctionInvoke(null, function, args, new FunctionType(call.getType(), argsType, false), regularIndex, unwindIndex, normalPhi, unwindPhi);
        this.setControlFlowNode(result, call, SourceInstrumentationStrategy.FORCED);
    }

    private static int getArgumentCount(int argumentCount, Type targetType) {
        int count = argumentCount;
        if (targetType instanceof StructureType) {
            ++count;
        }
        return ++count;
    }

    @Override
    public void visit(CastInstruction cast) {
        LLVMExpressionNode fromNode = this.symbols.resolve(cast.getValue());
        Type from = cast.getValue().getType();
        Type to = cast.getType();
        LLVMExpressionNode result = LLVMBitcodeTypeHelper.createCast(this.nodeFactory, fromNode, to, from, cast.getOperator());
        this.createFrameWrite(result, cast);
    }

    @Override
    public void visit(CompareInstruction compare) {
        LLVMExpressionNode result = this.nodeFactory.createComparison(compare.getOperator(), compare.getLHS().getType(), this.symbols.resolve(compare.getLHS()), this.symbols.resolve(compare.getRHS()));
        this.createFrameWrite(result, compare);
    }

    @Override
    public void visit(ConditionalBranchInstruction branch) {
        LLVMExpressionNode conditionNode = this.symbols.resolve(branch.getCondition());
        int trueIndex = branch.getTrueSuccessor().getBlockIndex();
        int falseIndex = branch.getFalseSuccessor().getBlockIndex();
        LLVMStatementNode[] phiWriteNodes = this.getPhiWriteNodes(branch);
        LLVMControlFlowNode node = this.nodeFactory.createConditionalBranch(trueIndex, falseIndex, conditionNode, phiWriteNodes[0], phiWriteNodes[1]);
        this.setControlFlowNode(node, branch);
    }

    @Override
    public void visit(ExtractElementInstruction extract) {
        LLVMExpressionNode vector = this.symbols.resolve(extract.getVector());
        LLVMExpressionNode index = this.symbols.resolve(extract.getIndex());
        Type resultType = extract.getType();
        LLVMExpressionNode result = this.nodeFactory.createExtractElement(resultType, vector, index);
        this.createFrameWrite(result, extract);
    }

    @Override
    public void visit(ExtractValueInstruction extract) {
        if (!(extract.getAggregate().getType() instanceof ArrayType || extract.getAggregate().getType() instanceof StructureType || extract.getAggregate().getType() instanceof PointerType)) {
            throw new LLVMParserException("'extractvalue' can only extract elements of arrays and structs!");
        }
        LLVMExpressionNode baseAddress = this.symbols.resolve(extract.getAggregate());
        Type baseType = extract.getAggregate().getType();
        int targetIndex = extract.getIndex();
        Type resultType = extract.getType();
        LLVMExpressionNode targetAddress = baseAddress;
        AggregateType aggregateType = (AggregateType)baseType;
        long offset = aggregateType.getOffsetOf(targetIndex, this.dataLayout);
        Type targetType = aggregateType.getElementType(targetIndex);
        if (!(targetType == null || targetType instanceof StructureType && ((StructureType)targetType).isPacked())) {
            offset += (long)Type.getPadding(offset, targetType, this.dataLayout);
        }
        if (offset != 0L) {
            LLVMExpressionNode oneLiteralNode = this.nodeFactory.createLiteral(1, PrimitiveType.I32);
            targetAddress = this.nodeFactory.createTypedElementPointer(targetAddress, oneLiteralNode, offset, extract.getType());
        }
        LLVMExpressionNode result = this.nodeFactory.createExtractValue(resultType, targetAddress);
        this.createFrameWrite(result, extract);
    }

    @Override
    public void visit(GetElementPointerInstruction gep) {
        LLVMExpressionNode targetAddress = this.symbols.resolveElementPointer(gep.getBasePointer(), gep.getIndices());
        this.createFrameWrite(targetAddress, gep);
    }

    @Override
    public void visit(IndirectBranchInstruction branch) {
        if (branch.getSuccessorCount() > 1) {
            int[] labelTargets = new int[branch.getSuccessorCount()];
            for (int i = 0; i < labelTargets.length; ++i) {
                labelTargets[i] = branch.getSuccessor(i).getBlockIndex();
            }
            LLVMExpressionNode value = this.symbols.resolve(branch.getAddress());
            LLVMControlFlowNode node = this.nodeFactory.createIndirectBranch(value, labelTargets, this.getPhiWriteNodes(branch));
            this.setControlFlowNode(node, branch);
        } else {
            assert (branch.getSuccessorCount() == 1);
            LLVMControlFlowNode node = this.nodeFactory.createUnconditionalBranch(branch.getSuccessor(0).getBlockIndex(), this.getPhiWriteNodes(branch)[0]);
            this.setControlFlowNode(node, branch);
        }
    }

    @Override
    public void visit(InsertElementInstruction insert) {
        LLVMExpressionNode vector = this.symbols.resolve(insert.getVector());
        LLVMExpressionNode index = this.symbols.resolve(insert.getIndex());
        LLVMExpressionNode element = this.symbols.resolve(insert.getValue());
        Type type = insert.getType();
        LLVMExpressionNode result = this.nodeFactory.createInsertElement(type, vector, element, index);
        this.createFrameWrite(result, insert);
    }

    @Override
    public void visit(InsertValueInstruction insert) {
        if (!(insert.getAggregate().getType() instanceof StructureType) && !(insert.getAggregate().getType() instanceof ArrayType)) {
            throw new LLVMParserException("'insertvalue' can only insert values into arrays and structs!");
        }
        AggregateType sourceType = (AggregateType)insert.getAggregate().getType();
        LLVMExpressionNode sourceAggregate = this.symbols.resolve(insert.getAggregate());
        LLVMExpressionNode valueToInsert = this.symbols.resolve(insert.getValue());
        Type valueType = insert.getValue().getType();
        int targetIndex = insert.getIndex();
        LLVMExpressionNode resultAggregate = this.nodeFactory.createGetUniqueStackSpace(sourceType, this.uniquesRegion);
        long offset = sourceType.getOffsetOf(targetIndex, this.dataLayout);
        LLVMExpressionNode result = this.nodeFactory.createInsertValue(resultAggregate, sourceAggregate, sourceType.getSize(this.dataLayout), offset, valueToInsert, valueType);
        this.createFrameWrite(result, insert);
    }

    @Override
    public void visit(LoadInstruction load) {
        LLVMExpressionNode source = this.symbols.resolve(load.getSource());
        LLVMLoadNode result = CommonNodeFactory.createLoad(load.getType(), source);
        this.createFrameWrite(result, load);
    }

    @Override
    public void visit(PhiInstruction phi) {
        this.handleNullerInfo();
    }

    @Override
    public void visit(ReturnInstruction ret) {
        LLVMControlFlowNode node;
        if (ret.getValue() == null) {
            node = this.nodeFactory.createRetVoid();
        } else {
            Type type = ret.getValue().getType();
            LLVMExpressionNode value = this.symbols.resolve(ret.getValue());
            node = this.nodeFactory.createNonVoidRet(value, type);
        }
        this.setControlFlowNode(node, ret);
    }

    @Override
    public void visit(SelectInstruction select) {
        LLVMExpressionNode condition = this.symbols.resolve(select.getCondition());
        LLVMExpressionNode trueValue = this.symbols.resolve(select.getTrueValue());
        LLVMExpressionNode falseValue = this.symbols.resolve(select.getFalseValue());
        Type type = select.getType();
        LLVMExpressionNode result = this.nodeFactory.createSelect(type, condition, trueValue, falseValue);
        this.createFrameWrite(result, select);
    }

    @Override
    public void visit(ShuffleVectorInstruction shuffle) {
        LLVMExpressionNode vector1 = this.symbols.resolve(shuffle.getVector1());
        LLVMExpressionNode vector2 = this.symbols.resolve(shuffle.getVector2());
        LLVMExpressionNode mask = this.symbols.resolve(shuffle.getMask());
        Type type = shuffle.getType();
        LLVMExpressionNode result = this.nodeFactory.createShuffleVector(type, vector1, vector2, mask);
        this.createFrameWrite(result, shuffle);
    }

    @Override
    public void visit(StoreInstruction store) {
        LLVMExpressionNode pointerNode = this.symbols.resolve(store.getDestination());
        LLVMExpressionNode valueNode = this.symbols.resolve(store.getSource());
        Type type = store.getSource().getType();
        SourceInstrumentationStrategy intention = SourceInstrumentationStrategy.DISABLED;
        if (!(store.getSource() instanceof CallInstruction) && !(store.getSource() instanceof InvokeInstruction) || ((Boolean)this.context.getEnv().getOptions().get(SulongEngineOption.LL_DEBUG)).booleanValue()) {
            intention = SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION;
        }
        LLVMStatementNode node = this.nodeFactory.createStore(pointerNode, valueNode, type);
        this.assignSourceLocation(node, store, intention);
        this.addInstruction(node);
    }

    @Override
    public void visit(ReadModifyWriteInstruction rmw) {
        LLVMExpressionNode pointerNode = this.symbols.resolve(rmw.getPtr());
        LLVMExpressionNode valueNode = this.symbols.resolve(rmw.getValue());
        Type type = rmw.getValue().getType();
        LLVMExpressionNode result = this.createReadModifyWrite(rmw.getOperator(), pointerNode, valueNode, type);
        this.createFrameWrite(result, rmw);
    }

    private LLVMExpressionNode createReadModifyWrite(ReadModifyWriteOperator op, LLVMExpressionNode pointerNode, LLVMExpressionNode valueNode, Type type) {
        switch (op) {
            case SUB: {
                return this.nodeFactory.createRMWSub(pointerNode, valueNode, type);
            }
            case XCHG: {
                return this.nodeFactory.createRMWXchg(pointerNode, valueNode, type);
            }
            case ADD: {
                return this.nodeFactory.createRMWAdd(pointerNode, valueNode, type);
            }
            case AND: {
                return this.nodeFactory.createRMWAnd(pointerNode, valueNode, type);
            }
            case NAND: {
                return this.nodeFactory.createRMWNand(pointerNode, valueNode, type);
            }
            case OR: {
                return this.nodeFactory.createRMWOr(pointerNode, valueNode, type);
            }
            case XOR: {
                return this.nodeFactory.createRMWXor(pointerNode, valueNode, type);
            }
        }
        throw new LLVMParserException("Unsupported read-modify-write operation: " + (Object)((Object)op));
    }

    @Override
    public void visit(FenceInstruction fence) {
        LLVMStatementNode node = this.nodeFactory.createFence();
        this.assignSourceLocation(node, fence);
        this.addInstruction(node);
    }

    @Override
    public void visit(SwitchInstruction zwitch) {
        LLVMExpressionNode cond = this.symbols.resolve(zwitch.getCondition());
        int[] successors = new int[zwitch.getCaseCount() + 1];
        for (int i = 0; i < successors.length - 1; ++i) {
            successors[i] = zwitch.getCaseBlock(i).getBlockIndex();
        }
        successors[successors.length - 1] = zwitch.getDefaultBlock().getBlockIndex();
        Type llvmType = zwitch.getCondition().getType();
        LLVMExpressionNode[] cases = new LLVMExpressionNode[zwitch.getCaseCount()];
        for (int i = 0; i < cases.length; ++i) {
            cases[i] = this.symbols.resolve(zwitch.getCaseValue(i));
        }
        LLVMControlFlowNode node = this.nodeFactory.createSwitch(cond, successors, cases, llvmType, this.getPhiWriteNodes(zwitch));
        this.setControlFlowNode(node, zwitch);
    }

    private LLVMStatementNode[] getPhiWriteNodes(TerminatingInstruction terminatingInstruction) {
        if (this.blockPhis != null) {
            ArrayList<LLVMPhiManager.Phi>[] phisPerSuccessor = LLVMPhiManager.getPhisForSuccessors(terminatingInstruction, this.blockPhis);
            return this.convertToPhiWriteNodes(phisPerSuccessor);
        }
        return new LLVMStatementNode[terminatingInstruction.getSuccessorCount()];
    }

    private LLVMStatementNode createAggregatePhi(LLVMExpressionNode[] from, FrameSlot[] to, Type[] types) {
        return this.nodeFactory.createPhi(from, to, types);
    }

    private LLVMStatementNode[] convertToPhiWriteNodes(ArrayList<LLVMPhiManager.Phi>[] phisPerSuccessor) {
        if (phisPerSuccessor.length == 0) {
            return LLVMStatementNode.NO_STATEMENTS;
        }
        LLVMStatementNode[] result = new LLVMStatementNode[phisPerSuccessor.length];
        for (int i = 0; i < result.length; ++i) {
            LLVMExpressionNode[] from = new LLVMExpressionNode[phisPerSuccessor[i].size()];
            FrameSlot[] to = new FrameSlot[phisPerSuccessor[i].size()];
            Type[] types = new Type[phisPerSuccessor[i].size()];
            for (int j = 0; j < phisPerSuccessor[i].size(); ++j) {
                LLVMPhiManager.Phi phi = phisPerSuccessor[i].get(j);
                to[j] = this.getSlot(phi.getPhiValue());
                from[j] = this.symbols.resolve(phi.getValue());
                types[j] = phi.getValue().getType();
            }
            result[i] = this.createAggregatePhi(from, to, types);
        }
        return result;
    }

    @Override
    public void visit(SwitchOldInstruction zwitch) {
        LLVMExpressionNode cond = this.symbols.resolve(zwitch.getCondition());
        int[] successors = new int[zwitch.getCaseCount() + 1];
        for (int i = 0; i < successors.length - 1; ++i) {
            successors[i] = zwitch.getCaseBlock(i).getBlockIndex();
        }
        successors[successors.length - 1] = zwitch.getDefaultBlock().getBlockIndex();
        PrimitiveType llvmType = (PrimitiveType)zwitch.getCondition().getType();
        LLVMExpressionNode[] cases = new LLVMExpressionNode[zwitch.getCaseCount()];
        block6: for (int i = 0; i < cases.length; ++i) {
            switch (llvmType.getPrimitiveKind()) {
                case I8: {
                    cases[i] = this.nodeFactory.createLiteral((byte)zwitch.getCaseValue(i), llvmType);
                    continue block6;
                }
                case I16: {
                    cases[i] = this.nodeFactory.createLiteral((short)zwitch.getCaseValue(i), llvmType);
                    continue block6;
                }
                case I32: {
                    cases[i] = this.nodeFactory.createLiteral((int)zwitch.getCaseValue(i), llvmType);
                    continue block6;
                }
                default: {
                    cases[i] = this.nodeFactory.createLiteral(zwitch.getCaseValue(i), llvmType);
                }
            }
        }
        LLVMControlFlowNode node = this.nodeFactory.createSwitch(cond, successors, cases, llvmType, this.getPhiWriteNodes(zwitch));
        this.setControlFlowNode(node, zwitch);
    }

    @Override
    public void visit(UnreachableInstruction ui) {
        LLVMControlFlowNode node = this.nodeFactory.createUnreachableNode();
        this.setControlFlowNode(node, ui);
    }

    private void createFrameWrite(LLVMExpressionNode result, ValueInstruction source) {
        this.createFrameWrite(result, source, SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION);
    }

    private void createFrameWrite(LLVMExpressionNode valueNode, ValueInstruction sourceInstruction, SourceInstrumentationStrategy intention) {
        LLVMStatementNode writeNode = this.nodeFactory.createFrameWrite(sourceInstruction.getType(), valueNode, this.getSlot(sourceInstruction));
        this.assignSourceLocation(writeNode, sourceInstruction, intention);
        this.addInstruction(writeNode);
    }

    private LLVMExpressionNode createInlineAssemblerNode(InlineAsmConstant inlineAsmConstant, LLVMExpressionNode[] argNodes, Type[] argsType, Type retType) {
        if (inlineAsmConstant.needsAlignedStack()) {
            throw new LLVMParserException("Assembly Expressions that require an aligned Stack are not supported yet!");
        }
        if (inlineAsmConstant.getDialect() != AsmDialect.AT_T) {
            throw new LLVMParserException("Unsupported Assembly Dialect: " + (Object)((Object)inlineAsmConstant.getDialect()));
        }
        return this.nodeFactory.createInlineAssemblerExpression(this.library, inlineAsmConstant.getAsmExpression(), inlineAsmConstant.getAsmFlags(), argNodes, argsType, retType);
    }

    private FrameSlot getSlot(ValueInstruction instruction) {
        return this.frame.findFrameSlot((Object)instruction.getName());
    }

    private FrameSlot getExceptionSlot() {
        return this.frame.findFrameSlot((Object)"<function exception value>");
    }

    private FrameSlot getStackSlot() {
        return this.frame.findFrameSlot((Object)"<stackpointer>");
    }

    private void addInstruction(LLVMStatementNode node) {
        this.blockInstructions.add(node);
        this.handleNullerInfo();
    }

    public void addInstructionUnchecked(LLVMStatementNode instruction) {
        this.blockInstructions.add(instruction);
    }

    private void handleNullerInfo() {
        LLVMLivenessAnalysis.NullerInformation nuller;
        for (int i = this.nullerInfos.size() - 1; i >= 0 && (nuller = this.nullerInfos.get(i)).getInstructionIndex() <= this.instructionIndex; --i) {
            if (nuller.getInstructionIndex() == this.instructionIndex) {
                FrameSlot frameSlot = nuller.getFrameSlot();
                if (!this.notNullable.contains(frameSlot)) {
                    LLVMStatementNode nullerNode = this.nodeFactory.createFrameNuller(frameSlot);
                    this.blockInstructions.add(nullerNode);
                }
                this.nullerInfos.remove(i);
                continue;
            }
            assert (false) : "we either missed an instruction or the nuller information is not sorted correctly";
        }
    }

    private void setControlFlowNode(LLVMControlFlowNode controlFlowNode, Instruction sourceInstruction) {
        this.setControlFlowNode(controlFlowNode, sourceInstruction, SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION);
    }

    private void setControlFlowNode(LLVMControlFlowNode controlFlowNode, Instruction sourceInstruction, SourceInstrumentationStrategy intention) {
        assert (this.controlFlowNode == null);
        this.controlFlowNode = controlFlowNode;
        this.assignSourceLocation(controlFlowNode, sourceInstruction, intention);
    }

    private LLVMExpressionNode capsuleAddressByValue(LLVMExpressionNode child, Type type, AttributesGroup paramAttr) {
        Type pointee = ((PointerType)type).getPointeeType();
        int size = pointee.getSize(this.dataLayout);
        int alignment = pointee.getAlignment(this.dataLayout);
        for (Attribute attr : paramAttr.getAttributes()) {
            if (!(attr instanceof Attribute.KnownIntegerValueAttribute) || ((Attribute.KnownIntegerValueAttribute)attr).getAttr() != Attribute.Kind.ALIGN) continue;
            alignment = ((Attribute.KnownIntegerValueAttribute)attr).getValue();
        }
        return this.nodeFactory.createVarArgCompoundValue(size, alignment, child);
    }

    private static boolean isByValue(AttributesGroup parameter) {
        if (parameter == null) {
            return false;
        }
        for (Attribute a : parameter.getAttributes()) {
            if (!(a instanceof Attribute.KnownAttribute) || ((Attribute.KnownAttribute)a).getAttr() != Attribute.Kind.BYVAL) continue;
            return true;
        }
        return false;
    }

    private void assignSourceLocation(LLVMInstrumentableNode node, Instruction sourceInstruction) {
        this.assignSourceLocation(node, sourceInstruction, SourceInstrumentationStrategy.ONLY_FIRST_STATEMENT_ON_LOCATION);
    }

    private void assignSourceLocation(LLVMInstrumentableNode node, Instruction sourceInstruction, SourceInstrumentationStrategy instrumentationStrategy) {
        if (node == null) {
            return;
        }
        LLVMSourceLocation location = sourceInstruction.getSourceLocation();
        if (location == null) {
            return;
        }
        LLVMNodeSourceDescriptor sourceDescriptor = node.getOrCreateSourceDescriptor();
        sourceDescriptor.setSourceLocation(location);
        assert (instrumentationStrategy != null);
        switch (instrumentationStrategy) {
            case FORCED: {
                sourceDescriptor.setHasStatementTag(true);
                this.lastLocation = location;
                break;
            }
            case ONLY_FIRST_STATEMENT_ON_LOCATION: {
                if (this.lastLocation == location || this.lastLocation != null && Objects.equals(this.lastLocation.describeFile(), location.describeFile()) && this.lastLocation.getLine() == location.getLine()) break;
                sourceDescriptor.setHasStatementTag(true);
                this.lastLocation = location;
                break;
            }
            case DISABLED: {
                break;
            }
            default: {
                throw new LLVMParserException("Unknown instrumentation strategy: " + (Object)((Object)instrumentationStrategy));
            }
        }
    }

    private static enum SourceInstrumentationStrategy {
        FORCED,
        ONLY_FIRST_STATEMENT_ON_LOCATION,
        DISABLED;

    }
}

