/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.nodes;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.metadata.MetadataSymbol;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDeclaration;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionParameter;
import com.oracle.truffle.llvm.parser.model.symbols.constants.BinaryOperationConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.BlockAddressConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.CastConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.CompareConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.GetElementPointerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.InlineAsmConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.NullConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.SelectConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.StringConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.UndefinedConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.ArrayConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.StructureConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.VectorConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.DoubleConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.FloatConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.floatingpoint.X86FP80Constant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.BigIntegerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.integer.IntegerConstant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalAlias;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.ValueInstructionVisitor;
import com.oracle.truffle.llvm.parser.util.LLVMBitcodeTypeHelper;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.OpaqueType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.VariableBitWidthType;
import com.oracle.truffle.llvm.runtime.types.VectorType;
import com.oracle.truffle.llvm.runtime.types.VoidType;
import com.oracle.truffle.llvm.runtime.types.visitors.TypeVisitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public final class LLVMSymbolReadResolver {
    private final LLVMParserRuntime runtime;
    private final NodeFactory nodeFactory;
    private final FrameDescriptor frame;
    private final GetStackSpaceFactory getStackSpaceFactory;
    private final DataLayout dataLayout;
    private final InternalVisitor visitor = new InternalVisitor();
    private LLVMExpressionNode resolvedNode = null;

    private static void unsupported(Object obj) {
        throw new LLVMParserException("Cannot resolve symbol: " + obj);
    }

    public LLVMSymbolReadResolver(LLVMParserRuntime runtime, FrameDescriptor frame, GetStackSpaceFactory getStackSpaceFactory, DataLayout dataLayout) {
        this.runtime = runtime;
        this.nodeFactory = runtime.getNodeFactory();
        this.frame = frame;
        this.getStackSpaceFactory = getStackSpaceFactory;
        this.dataLayout = dataLayout;
    }

    public static Integer evaluateIntegerConstant(SymbolImpl constant) {
        if (constant instanceof IntegerConstant) {
            assert (((IntegerConstant)constant).getValue() == (long)((int)((IntegerConstant)constant).getValue()));
            return (int)((IntegerConstant)constant).getValue();
        }
        if (constant instanceof BigIntegerConstant) {
            return ((BigIntegerConstant)constant).getValue().intValueExact();
        }
        if (constant instanceof NullConstant) {
            return 0;
        }
        return null;
    }

    public static Long evaluateLongIntegerConstant(SymbolImpl constant) {
        if (constant instanceof IntegerConstant) {
            return ((IntegerConstant)constant).getValue();
        }
        if (constant instanceof BigIntegerConstant) {
            return ((BigIntegerConstant)constant).getValue().longValueExact();
        }
        if (constant instanceof NullConstant) {
            return 0L;
        }
        return null;
    }

    public LLVMExpressionNode resolveElementPointer(SymbolImpl base, List<SymbolImpl> indices) {
        LLVMExpressionNode currentAddress = this.resolve(base);
        Type currentType = base.getType();
        int indicesSize = indices.size();
        for (int i = 0; i < indicesSize; ++i) {
            LLVMExpressionNode indexNode;
            AggregateType aggregate;
            SymbolImpl indexSymbol = indices.get(i);
            Type indexType = indexSymbol.getType();
            Long indexInteger = LLVMSymbolReadResolver.evaluateLongIntegerConstant(indexSymbol);
            if (indexInteger == null) {
                if (currentType instanceof StructureType) {
                    throw new LLVMParserException("Indices on structs must be constant integers!");
                }
                aggregate = (AggregateType)currentType;
                long indexedTypeLength = aggregate.getOffsetOf(1L, this.dataLayout);
                currentType = aggregate.getElementType(1L);
                indexNode = this.resolve(indexSymbol);
                currentAddress = this.nodeFactory.createTypedElementPointer(currentAddress, indexNode, indexedTypeLength, currentType);
                continue;
            }
            aggregate = (AggregateType)currentType;
            long addressOffset = aggregate.getOffsetOf(indexInteger, this.dataLayout);
            currentType = aggregate.getElementType(indexInteger);
            if (addressOffset == 0L && i != indicesSize - 1) continue;
            if (indexType == PrimitiveType.I32) {
                indexNode = this.nodeFactory.createLiteral(1, PrimitiveType.I32);
            } else if (indexType == PrimitiveType.I64) {
                indexNode = this.nodeFactory.createLiteral(1L, PrimitiveType.I64);
            } else {
                throw new AssertionError(indexType);
            }
            currentAddress = this.nodeFactory.createTypedElementPointer(currentAddress, indexNode, addressOffset, currentType);
        }
        return currentAddress;
    }

    public LLVMExpressionNode resolve(SymbolImpl symbol) {
        if (symbol == null) {
            return null;
        }
        this.resolvedNode = null;
        symbol.accept(this.visitor);
        return this.resolvedNode;
    }

    private final class InternalVisitor
    extends ValueInstructionVisitor {
        private final TypeVisitor nullValueVisitor = new TypeVisitor(){

            private void unsupportedType(Type type) {
                throw new LLVMParserException("Unsupported Type for Zero Constant: " + type);
            }

            @Override
            public void visit(FunctionType type) {
                LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(null, type);
            }

            @Override
            public void visit(PrimitiveType type) {
                switch (type.getPrimitiveKind()) {
                    case I1: {
                        LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(false, type);
                        break;
                    }
                    case I8: {
                        LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray((byte)0, type);
                        break;
                    }
                    case I16: {
                        LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray((short)0, type);
                        break;
                    }
                    case I32: {
                        LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(0, type);
                        break;
                    }
                    case I64: {
                        LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(0L, type);
                        break;
                    }
                    case FLOAT: {
                        LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(Float.valueOf(0.0f), type);
                        break;
                    }
                    case DOUBLE: {
                        LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(0.0, type);
                        break;
                    }
                    case X86_FP80: {
                        LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(null, type);
                        break;
                    }
                    default: {
                        this.unsupportedType(type);
                    }
                }
            }

            @Override
            public void visit(MetaType metaType) {
                if (metaType == MetaType.DEBUG) {
                    LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(null, metaType);
                } else {
                    this.unsupportedType(metaType);
                }
            }

            @Override
            public void visit(PointerType type) {
                LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(null, type);
            }

            @Override
            public void visit(ArrayType type) {
                int arraySize = type.getSize(LLVMSymbolReadResolver.this.dataLayout);
                if (arraySize == 0) {
                    LLVMSymbolReadResolver.this.resolvedNode = null;
                } else {
                    LLVMExpressionNode target = LLVMSymbolReadResolver.this.getStackSpaceFactory.createGetStackSpace(LLVMSymbolReadResolver.this.nodeFactory, type);
                    LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createZeroNode(target, arraySize);
                }
            }

            @Override
            public void visit(StructureType structureType) {
                int structSize = structureType.getSize(LLVMSymbolReadResolver.this.dataLayout);
                if (structSize == 0) {
                    LLVMNativePointer minusOneNode = LLVMNativePointer.create(-1L);
                    LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createLiteral(minusOneNode, new PointerType(structureType));
                } else {
                    LLVMExpressionNode addressnode = LLVMSymbolReadResolver.this.getStackSpaceFactory.createGetStackSpace(LLVMSymbolReadResolver.this.nodeFactory, structureType);
                    LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createZeroNode(addressnode, structSize);
                }
            }

            @Override
            public void visit(VectorType vectorType) {
                int nrElements = vectorType.getNumberOfElements();
                LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createZeroVectorInitializer(nrElements, vectorType);
            }

            @Override
            public void visit(VariableBitWidthType type) {
                LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(BigInteger.ZERO, type);
            }

            @Override
            public void visit(VoidType type) {
                this.unsupportedType(type);
            }

            @Override
            public void visit(OpaqueType type) {
                this.unsupportedType(type);
            }
        };

        private InternalVisitor() {
        }

        @Override
        public void defaultAction(SymbolImpl symbol) {
            LLVMSymbolReadResolver.unsupported(symbol);
        }

        @Override
        public void visit(MetadataSymbol constant) {
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(0, PrimitiveType.I32);
        }

        @Override
        public void visit(ArrayConstant array) {
            LLVMExpressionNode[] values = new LLVMExpressionNode[array.getElementCount()];
            for (int i = 0; i < array.getElementCount(); ++i) {
                values[i] = LLVMSymbolReadResolver.this.resolve(array.getElement(i));
            }
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createArrayLiteral(values, array.getType(), LLVMSymbolReadResolver.this.getStackSpaceFactory);
        }

        @Override
        public void visit(StructureConstant constant) {
            int elementCount = constant.getElementCount();
            Type[] types = new Type[elementCount];
            LLVMExpressionNode[] constants = new LLVMExpressionNode[elementCount];
            for (int i = 0; i < elementCount; ++i) {
                types[i] = constant.getElementType(i);
                constants[i] = LLVMSymbolReadResolver.this.resolve(constant.getElement(i));
            }
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createStructureConstantNode(constant.getType(), LLVMSymbolReadResolver.this.getStackSpaceFactory, constant.isPacked(), types, constants);
        }

        @Override
        public void visit(VectorConstant constant) {
            ArrayList<LLVMExpressionNode> values = new ArrayList<LLVMExpressionNode>();
            for (int i = 0; i < constant.getLength(); ++i) {
                values.add(LLVMSymbolReadResolver.this.resolve(constant.getElement(i)));
            }
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createVectorLiteralNode(values, constant.getType());
        }

        @Override
        public void visit(BigIntegerConstant constant) {
            Type type = constant.getType();
            if (type.getBitSize() <= 64) {
                LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(constant.getValue().longValueExact(), type);
            } else {
                LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(constant.getValue(), type);
            }
        }

        @Override
        public void visit(BinaryOperationConstant operation) {
            LLVMExpressionNode lhs = LLVMSymbolReadResolver.this.resolve(operation.getLHS());
            LLVMExpressionNode rhs = LLVMSymbolReadResolver.this.resolve(operation.getRHS());
            LLVMSymbolReadResolver.this.resolvedNode = LLVMBitcodeTypeHelper.createArithmeticInstruction(LLVMSymbolReadResolver.this.nodeFactory, lhs, rhs, operation.getOperator(), operation.getType());
        }

        @Override
        public void visit(BlockAddressConstant constant) {
            LLVMNativePointer blockAddress = LLVMNativePointer.create(constant.getBlockIndex());
            PointerType type = new PointerType(null);
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createLiteral(blockAddress, type);
        }

        @Override
        public void visit(CastConstant constant) {
            LLVMExpressionNode fromNode = LLVMSymbolReadResolver.this.resolve(constant.getValue());
            LLVMSymbolReadResolver.this.resolvedNode = LLVMBitcodeTypeHelper.createCast(LLVMSymbolReadResolver.this.nodeFactory, fromNode, constant.getType(), constant.getValue().getType(), constant.getOperator());
        }

        @Override
        public void visit(CompareConstant compare) {
            LLVMExpressionNode lhs = LLVMSymbolReadResolver.this.resolve(compare.getLHS());
            LLVMExpressionNode rhs = LLVMSymbolReadResolver.this.resolve(compare.getRHS());
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createComparison(compare.getOperator(), compare.getLHS().getType(), lhs, rhs);
        }

        @Override
        public void visit(DoubleConstant constant) {
            double dVal = constant.getValue();
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(dVal, constant.getType());
        }

        @Override
        public void visit(FloatConstant constant) {
            float fVal = constant.getValue();
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(Float.valueOf(fVal), constant.getType());
        }

        @Override
        public void visit(X86FP80Constant constant) {
            byte[] xVal = constant.getValue();
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(xVal, constant.getType());
        }

        @Override
        public void visit(GetElementPointerConstant constant) {
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.resolveElementPointer(constant.getBasePointer(), constant.getIndices());
        }

        @Override
        public void visit(InlineAsmConstant inlineAsmConstant) {
            throw new LLVMParserException("Cannot resolve Inline ASM");
        }

        @Override
        public void visit(IntegerConstant constant) {
            block10: {
                long lVal;
                Type type;
                block9: {
                    type = constant.getType();
                    lVal = constant.getValue();
                    if (!(type instanceof PrimitiveType)) break block9;
                    switch (((PrimitiveType)type).getPrimitiveKind()) {
                        case I1: {
                            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(lVal != 0L, type);
                            break block10;
                        }
                        case I8: {
                            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray((byte)lVal, type);
                            break block10;
                        }
                        case I16: {
                            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray((short)lVal, type);
                            break block10;
                        }
                        case I32: {
                            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray((int)lVal, type);
                            break block10;
                        }
                        case I64: {
                            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(lVal, type);
                            break block10;
                        }
                        default: {
                            throw new LLVMParserException("Unsupported IntegerConstant: " + type);
                        }
                    }
                }
                if (type instanceof VariableBitWidthType) {
                    LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSimpleConstantNoArray(lVal, type);
                } else {
                    throw new LLVMParserException("Unsupported IntegerConstant: " + type);
                }
            }
        }

        @Override
        public void visit(NullConstant nullConstant) {
            nullConstant.getType().accept(this.nullValueVisitor);
        }

        @Override
        public void visit(StringConstant constant) {
            String chars = constant.getString();
            LLVMExpressionNode[] values = new LLVMExpressionNode[chars.length() + (constant.isCString() ? 1 : 0)];
            for (int i = 0; i < chars.length(); ++i) {
                values[i] = LLVMSymbolReadResolver.this.nodeFactory.createLiteral((byte)chars.charAt(i), PrimitiveType.I8);
            }
            if (constant.isCString()) {
                values[values.length - 1] = LLVMSymbolReadResolver.this.nodeFactory.createLiteral((byte)0, PrimitiveType.I8);
            }
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createArrayLiteral(values, constant.getType(), LLVMSymbolReadResolver.this.getStackSpaceFactory);
        }

        @Override
        public void visit(UndefinedConstant undefinedConstant) {
            undefinedConstant.getType().accept(this.nullValueVisitor);
        }

        @Override
        public void visit(SelectConstant constant) {
            LLVMExpressionNode conditionNode = LLVMSymbolReadResolver.this.resolve(constant.getCondition());
            LLVMExpressionNode trueValueNode = LLVMSymbolReadResolver.this.resolve(constant.getTrueValue());
            LLVMExpressionNode falseValueNode = LLVMSymbolReadResolver.this.resolve(constant.getFalseValue());
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createSelect(constant.getType(), conditionNode, trueValueNode, falseValueNode);
        }

        @Override
        public void visit(FunctionDeclaration toResolve) {
            LLVMManagedPointer value = LLVMManagedPointer.create(LLVMSymbolReadResolver.this.runtime.lookupFunction(toResolve.getName(), toResolve.isOverridable()));
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createLiteral(value, toResolve.getType());
        }

        @Override
        public void visit(FunctionDefinition toResolve) {
            LLVMManagedPointer value = LLVMManagedPointer.create(LLVMSymbolReadResolver.this.runtime.lookupFunction(toResolve.getName(), toResolve.isOverridable()));
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createLiteral(value, toResolve.getType());
        }

        @Override
        public void visit(GlobalAlias alias) {
            LLVMSymbol symbol = LLVMSymbolReadResolver.this.runtime.lookupSymbol(alias.getName(), alias.isOverridable());
            if (symbol.isFunction()) {
                LLVMManagedPointer value = LLVMManagedPointer.create(symbol.asFunction());
                LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createLiteral(value, alias.getType());
            } else if (symbol.isGlobalVariable()) {
                LLVMGlobal value = symbol.asGlobalVariable();
                LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createLiteral(value, alias.getType());
            } else {
                throw new LLVMParserException("Unexpected symbol: " + symbol.getClass());
            }
        }

        @Override
        public void visit(GlobalVariable global) {
            LLVMGlobal value = LLVMSymbolReadResolver.this.runtime.lookupGlobal(global.getName(), global.isOverridable());
            LLVMSymbolReadResolver.this.resolvedNode = LLVMSymbolReadResolver.this.nodeFactory.createLiteral(value, new PointerType(global.getType()));
        }

        @Override
        public void visit(FunctionParameter param) {
            FrameSlot slot = LLVMSymbolReadResolver.this.frame.findFrameSlot((Object)param.getName());
            LLVMSymbolReadResolver.this.resolvedNode = CommonNodeFactory.createFrameRead(param.getType(), slot);
        }

        @Override
        public void visitValueInstruction(ValueInstruction value) {
            FrameSlot slot = LLVMSymbolReadResolver.this.frame.findFrameSlot((Object)value.getName());
            LLVMSymbolReadResolver.this.resolvedNode = CommonNodeFactory.createFrameRead(value.getType(), slot);
        }
    }
}

