/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFileDetector;
import com.oracle.truffle.llvm.runtime.SulongLibrary;
import com.oracle.truffle.llvm.runtime.ToolchainConfig;
import com.oracle.truffle.llvm.runtime.ToolchainImpl;
import com.oracle.truffle.llvm.runtime.config.Configuration;
import com.oracle.truffle.llvm.runtime.config.Configurations;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import com.oracle.truffle.llvm.runtime.debug.LLDBSupport;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebuggerScopeFactory;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObject;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.Collections;
import java.util.List;
import org.graalvm.options.OptionDescriptors;

@TruffleLanguage.Registration(id="llvm", name="LLVM", internal=false, interactive=false, defaultMimeType="application/x-llvm-ir-bitcode", byteMimeTypes={"application/x-llvm-ir-bitcode", "application/x-sharedlib", "application/x-executable"}, characterMimeTypes={"application/x-llvm-ir-bitcode-base64"}, fileTypeDetectors={LLVMFileDetector.class}, services={Toolchain.class})
@ProvidedTags(value={StandardTags.StatementTag.class, StandardTags.CallTag.class, StandardTags.RootTag.class, StandardTags.RootBodyTag.class, DebuggerTags.AlwaysHalt.class})
public class LLVMLanguage
extends TruffleLanguage<LLVMContext> {
    static final String LLVM_BITCODE_MIME_TYPE = "application/x-llvm-ir-bitcode";
    static final String LLVM_BITCODE_EXTENSION = "bc";
    public static final String LLVM_BITCODE_BASE64_MIME_TYPE = "application/x-llvm-ir-bitcode-base64";
    public static final String LLVM_PRINT_TOOLCHAIN_PATH_MIME_TYPE = "application/x-llvm-ir-bitcode-base64";
    static final String LLVM_ELF_SHARED_MIME_TYPE = "application/x-sharedlib";
    static final String LLVM_ELF_EXEC_MIME_TYPE = "application/x-executable";
    static final String LLVM_ELF_LINUX_EXTENSION = "so";
    static final String MAIN_ARGS_KEY = "Sulong Main Args";
    static final String PARSE_ONLY_KEY = "Parse only";
    public static final String ID = "llvm";
    static final String NAME = "LLVM";
    @CompilerDirectives.CompilationFinal
    private List<ContextExtension> contextExtensions;
    @CompilerDirectives.CompilationFinal
    private Configuration activeConfiguration = null;
    private final LLDBSupport lldbSupport = new LLDBSupport(this);

    public List<ContextExtension> getLanguageContextExtension() {
        this.verifyContextExtensionsInitialized();
        return this.contextExtensions;
    }

    public <T extends ContextExtension> T getContextExtension(Class<T> type) {
        T result = this.getContextExtensionOrNull(type);
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("No context extension for: " + type);
    }

    public <T extends ContextExtension> T getContextExtensionOrNull(Class<T> type) {
        CompilerAsserts.neverPartOfCompilation();
        this.verifyContextExtensionsInitialized();
        for (ContextExtension ce : this.contextExtensions) {
            if (ce.extensionClass() != type) continue;
            return (T)((ContextExtension)type.cast(ce));
        }
        return null;
    }

    private void verifyContextExtensionsInitialized() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.contextExtensions == null) {
            throw new IllegalStateException("LLVMContext is not yet initialized");
        }
    }

    public static LLVMContext getContext() {
        CompilerAsserts.neverPartOfCompilation((String)"Use faster context lookup methods for the fast-path.");
        return (LLVMContext)LLVMLanguage.getCurrentContext(LLVMLanguage.class);
    }

    public static LLVMLanguage getLanguage() {
        return (LLVMLanguage)LLVMLanguage.getCurrentLanguage(LLVMLanguage.class);
    }

    public static LLDBSupport getLLDBSupport() {
        return LLVMLanguage.getLanguage().lldbSupport;
    }

    public <C extends LLVMCapability> C getCapability(Class<C> type) {
        CompilerAsserts.partialEvaluationConstant(type);
        C ret = this.activeConfiguration.getCapability(type);
        CompilerAsserts.partialEvaluationConstant(ret);
        return ret;
    }

    public final String getLLVMLanguageHome() {
        return this.getLanguageHome();
    }

    public Configuration getActiveConfiguration() {
        if (this.activeConfiguration != null) {
            return this.activeConfiguration;
        }
        throw new IllegalStateException("No context, please create the context before accessing the configuration.");
    }

    protected LLVMContext createContext(TruffleLanguage.Env env) {
        if (this.activeConfiguration == null) {
            this.activeConfiguration = Configurations.createConfiguration(this, env.getOptions());
        }
        ToolchainImpl toolchain = new ToolchainImpl(this.activeConfiguration.getCapability(ToolchainConfig.class), this);
        env.registerService((Object)toolchain);
        LLVMContext context = new LLVMContext(this, env, toolchain);
        return context;
    }

    protected void initializeContext(LLVMContext context) {
        this.contextExtensions = this.activeConfiguration.createContextExtensions(context.getEnv());
        context.initialize();
    }

    protected boolean patchContext(LLVMContext context, TruffleLanguage.Env newEnv) {
        boolean compatible = Configurations.areOptionsCompatible(context.getEnv().getOptions(), newEnv.getOptions());
        if (!compatible) {
            return false;
        }
        return context.patchContext(newEnv);
    }

    protected void finalizeContext(LLVMContext context) {
        context.finalizeContext();
    }

    protected void disposeContext(LLVMContext context) {
        LLVMMemory memory = this.getCapability(LLVMMemory.class);
        context.dispose(memory);
    }

    protected CallTarget parse(TruffleLanguage.ParsingRequest request) {
        Source source = request.getSource();
        return this.getCapability(Loader.class).load(LLVMLanguage.getContext(), source);
    }

    protected Iterable<Scope> findTopScopes(LLVMContext context) {
        Scope scope = Scope.newBuilder((String)"llvm-global", (Object)context.getGlobalScope()).build();
        return Collections.singleton(scope);
    }

    protected boolean isObjectOfLanguage(Object object) {
        return LLVMPointer.isInstance(object) || object instanceof LLVMInternalTruffleObject || object instanceof SulongLibrary || object instanceof LLVMDebuggerValue || object instanceof LLVMInteropType;
    }

    protected String toString(LLVMContext context, Object value) {
        if (value instanceof SulongLibrary) {
            return "LLVMLibrary:" + ((SulongLibrary)value).getName();
        }
        if (this.isObjectOfLanguage(value)) {
            return value.toString();
        }
        if (value instanceof String || value instanceof Number) {
            return value.toString();
        }
        return "<unknown object>";
    }

    protected OptionDescriptors getOptionDescriptors() {
        return Configurations.getOptionDescriptors();
    }

    protected Object findMetaObject(LLVMContext context, Object value) {
        if (value instanceof LLVMDebuggerValue) {
            return ((LLVMDebuggerValue)value).getMetaObject();
        }
        if (LLVMPointer.isInstance(value)) {
            LLVMPointer ptr = LLVMPointer.cast(value);
            return ptr.getExportType();
        }
        return super.findMetaObject((Object)context, value);
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    protected void disposeThread(LLVMContext context, Thread thread) {
        super.disposeThread((Object)context, thread);
        if (context.isInitialized()) {
            context.getThreadingStack().freeStack(this.getCapability(LLVMMemory.class), thread);
        }
    }

    protected SourceSection findSourceLocation(LLVMContext context, Object value) {
        LLVMSourceLocation location = null;
        if (value instanceof LLVMSourceType) {
            location = ((LLVMSourceType)value).getLocation();
        } else if (value instanceof LLVMDebugObject) {
            location = ((LLVMDebugObject)value).getDeclaration();
        }
        if (location != null) {
            return location.getSourceSection();
        }
        return null;
    }

    protected Iterable<Scope> findLocalScopes(LLVMContext context, Node node, Frame frame) {
        if (((Boolean)context.getEnv().getOptions().get(SulongEngineOption.ENABLE_LVI)).booleanValue()) {
            return LLVMDebuggerScopeFactory.createSourceLevelScope(node, frame, context);
        }
        return LLVMDebuggerScopeFactory.createIRLevelScope(node, frame, context);
    }

    public static abstract class Loader
    implements LLVMCapability {
        public abstract CallTarget load(LLVMContext var1, Source var2);
    }
}

